/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.model.render.RenderMode;

public abstract class Panel3d
extends GuiElement {
    private Panel3dNative nat;
    protected int backgroundColor;

    public Panel3d(IGui gui) {
        super(gui);
        this.nat = (Panel3dNative)gui.getNative().getNative(Panel3d.class, this);
    }

    public abstract void render(MatrixStack var1, VBuffers var2, float var3);

    public abstract ViewportCamera getCamera();

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.bounds);
        this.gui.setupCut();
        if (this.backgroundColor != 0) {
            this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.backgroundColor);
        }
        if (this.enabled) {
            this.nat.renderPos = this.gui.getOffset();
            this.nat.render(partialTicks);
        }
        this.gui.popMatrix();
        this.gui.setupCut();
    }

    protected RenderTypes<RenderMode> getRenderTypes() {
        return this.nat.getRenderTypes();
    }

    protected RenderTypes<RenderMode> getRenderTypes(String tex) {
        return this.nat.getRenderTypes(tex);
    }

    public IGui getGui() {
        return this.gui;
    }

    protected int getColorUnderMouse() {
        return this.nat.getColorUnderMouse();
    }

    public Image takeScreenshot(Vec2i size) {
        return this.nat.takeScreenshot(size);
    }

    public void renderItem(MatrixStack stack, ItemSlot hand, DisplayItem item) {
        this.nat.renderItem(stack, hand, item);
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static abstract class Panel3dNative {
        protected Panel3d panel;
        protected Vec2i renderPos = new Vec2i();

        public Panel3dNative(Panel3d panel) {
            this.panel = panel;
        }

        public abstract void render(float var1);

        public abstract RenderTypes<RenderMode> getRenderTypes();

        public abstract RenderTypes<RenderMode> getRenderTypes(String var1);

        public abstract int getColorUnderMouse();

        public abstract Image takeScreenshot(Vec2i var1);

        public abstract void renderItem(MatrixStack var1, ItemSlot var2, DisplayItem var3);

        public Box getBounds() {
            return this.panel.bounds;
        }
    }
}

