/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.LegacySkinConverter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SelectSkinPopup
extends PopupPanel
implements ModelDisplayPanel.IModelDisplayPanel {
    private ViewportCamera camera;
    private ScrollPanel list;
    private List<SkinPanel> panels;
    private List<Consumer<Vec2i>> sizeSetters = new ArrayList<Consumer<Vec2i>>();
    private TextureProvider selected;
    private TextureProvider selectedOpen;
    private ModelDisplayPanel display;
    private ModelDefinition selectedDef;
    private Button openSkin;
    private Button set;
    private SkinType type;

    public SelectSkinPopup(Frame frm, SkinType typeIn, BiConsumer<SkinType, Image> accept) {
        super(frm.getGui());
        File[] fs;
        this.camera = new ViewportCamera();
        this.type = typeIn;
        this.list = new ScrollPanel(this.gui);
        Panel panel = new Panel(this.gui);
        this.sizeSetters.add(s -> panel.setBounds(new Box(0, 0, s.x, 40)));
        this.panels = new ArrayList<SkinPanel>();
        File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
        File[] fileArray = fs = modelsDir.exists() ? modelsDir.listFiles((f, n) -> n.endsWith(".png")) : null;
        if (fs == null || fs.length == 0) {
            Label lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_skins", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            panel.addElement(lbl);
        } else {
            Label lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            MinecraftClientAccess.get().getDefinitionLoader().execute(() -> {
                int y = 0;
                for (int i = 0; i < fs.length; ++i) {
                    if (fs[i].getName().equals(".temp.cpmmodel")) continue;
                    try {
                        Image img = Image.loadFrom(fs[i]);
                        if (img.getWidth() != 64 || img.getHeight() != 64 && img.getHeight() != 32) continue;
                        if (img.getHeight() == 32) {
                            img = LegacySkinConverter.processLegacySkin(img);
                        }
                        SkinPanel p = new SkinPanel(this.gui, fs[i].getName(), img, y);
                        y += p.getHeight();
                        this.panels.add(p);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int fy = y;
                MinecraftClientAccess.get().executeLater(() -> {
                    this.panels.forEach(panel::addElement);
                    if (panel.getBounds() != null) {
                        int w = panel.getBounds().w;
                        this.panels.forEach(p -> p.setSize(w));
                        panel.setBounds(new Box(0, 0, w, fy));
                    }
                    this.sizeSetters.add(s -> {
                        panel.setBounds(new Box(0, 0, s.x, fy));
                        this.panels.forEach(p -> p.setSize(s.x));
                    });
                    panel.getElements().remove(lbl);
                });
            });
        }
        this.openSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.openSkin", new Object[0]), () -> {
            FileChooserPopup fc = new FileChooserPopup(frm);
            fc.setTitle(this.gui.i18nFormat("button.cpm.openSkin", new Object[0]));
            fc.setFileDescText(this.gui.i18nFormat("label.cpm.file_png", new Object[0]));
            fc.setFilter(new FileChooserPopup.FileFilter("png"));
            fc.setExtAdder(n -> n + ".png");
            fc.setAccept(f -> {
                try {
                    Image imgIn = Image.loadFrom(f);
                    if (imgIn.getWidth() != 64 || imgIn.getHeight() != 64 && imgIn.getHeight() != 32) {
                        frm.openPopup(new MessagePopup(frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.vanillaSkinSize", new Object[0])));
                        return;
                    }
                    Image img = imgIn.getHeight() == 32 ? LegacySkinConverter.processLegacySkin(imgIn) : imgIn;
                    frm.openPopup(new ConfirmPopup(frm, this.gui.i18nFormat("button.cpm.openSkin", new Object[0]), this.gui.i18nFormat("label.cpm.addSkinToFolder", new Object[0]), () -> {
                        File fn = new File(modelsDir, f.getName());
                        modelsDir.mkdirs();
                        if (fn.exists()) {
                            int ind = f.getName().lastIndexOf(46);
                            String name = ind != -1 ? f.getName() : f.getName().substring(0, ind);
                            fn = new File(modelsDir, name + "_" + System.nanoTime() % 1000L + ".png");
                        }
                        try {
                            img.storeTo(fn);
                        }
                        catch (IOException e) {
                            this.gui.onGuiException("Failed to save image to models folder", e, false);
                        }
                        this.selectedOpen.setImage(img);
                        this.selected = this.selectedOpen;
                    }, () -> {
                        this.selectedOpen.setImage(img);
                        this.selected = this.selectedOpen;
                    }));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
            frm.openPopup(fc);
        });
        this.addElement(this.openSkin);
        this.list.setDisplay(panel);
        panel.setBackgroundColor(this.gui.getColors().panel_background & 0xFFFFFF | Integer.MIN_VALUE);
        this.addElement(this.list);
        this.display = new ModelDisplayPanel(this.gui, this);
        this.display.setLoadingText(this.gui.i18nFormat("button.cpm.selectSkin", new Object[0]));
        this.addElement(this.display);
        this.set = new Button(this.gui, this.gui.i18nFormat("button.cpm.selectSkin", new Object[0]), () -> {
            if (this.selected != null && this.selected.getImage() != null) {
                accept.accept(this.type, this.selected.getImage());
                this.close();
            }
        });
        this.addElement(this.set);
        this.selectedOpen = new TextureProvider();
        this.setSize(400, 300);
        this.selectedDef = ModelDefinition.createVanilla(() -> this.selected, this.type);
    }

    public void setSize(int width, int height) {
        Vec2i s = new Vec2i(width / 2 - 30, height - 80);
        this.list.setBounds(new Box(20, 40, s.x, s.y));
        this.openSkin.setBounds(new Box(20, 45 + s.y, s.x, 20));
        this.sizeSetters.forEach(c -> c.accept(s));
        int dispSize = Math.min(width / 2 - 40, height - 100);
        this.set.setBounds(new Box(width / 2 + dispSize / 2 - 50, height / 2 + dispSize / 2 + 10, 100, 20));
        this.display.setBounds(new Box(width / 2 + 10, height / 2 - dispSize / 2, dispSize, dispSize));
        this.setBounds(new Box(0, 0, width, height));
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.panels.forEach(rec$ -> ((SkinPanel)rec$).onClosed());
        this.selectedOpen.free();
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        return this.selected != null ? this.selectedDef : null;
    }

    @Override
    public ViewportCamera getCamera() {
        return this.camera;
    }

    @Override
    public void preRender() {
    }

    @Override
    public boolean doRender() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.selectSkin", new Object[0]);
    }

    private class SkinPanel
    extends Panel {
        private TextureProvider icon;
        private Button select;
        private int y;

        public SkinPanel(IGui gui, String fileName, Image img, int y) {
            super(gui);
            this.icon = new TextureProvider(img, new Vec2i(64, 64));
            this.y = y;
            Label lbl = new Label(gui, fileName);
            lbl.setBounds(new Box(68, 5, 100, 10));
            this.addElement(lbl);
            this.select = new Button(gui, gui.i18nFormat("button.cpm.select", new Object[0]), () -> SelectSkinPopup.this.selected = this.icon);
            this.addElement(this.select);
        }

        public int getHeight() {
            return 70;
        }

        public void setSize(int w) {
            this.select.setBounds(new Box(w - 50, 15, 40, 20));
            this.setBounds(new Box(0, this.y, w, this.getHeight()));
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon != null) {
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + 1, this.bounds.y + 1, 64, 64, 0.125f, 0.125f, 0.25f, 0.25f);
                this.gui.drawTexture(this.bounds.x + 1, this.bounds.y + 1, 64, 64, 0.625f, 0.125f, 0.875f, 0.25f);
            }
        }

        private void onClosed() {
            if (this.icon != null) {
                this.icon.free();
            }
        }
    }
}

