/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tree;

import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.tree.TreeElement;

public class ScalingElement
implements TreeElement {
    private Editor editor;
    private Tooltip tt;

    public ScalingElement(Editor editor) {
        this.editor = editor;
    }

    @Override
    public String getName() {
        return this.editor.gui().i18nFormat("label.cpm.display.scaling", new Object[0]);
    }

    @Override
    public void updateGui() {
        this.editor.applyScaling = true;
        this.editor.setValue.accept(Float.valueOf(this.editor.scaling));
        this.editor.setModePanel.accept(PosPanel.ModeDisplayType.VALUE);
    }

    @Override
    public Tooltip getTooltip() {
        if (this.tt == null) {
            this.tt = new Tooltip(this.editor.frame, this.editor.gui().i18nFormat("tooltip.cpm.display.scaling", new Object[0]));
        }
        return this.tt;
    }

    @Override
    public float getValue() {
        return this.editor.scaling;
    }

    @Override
    public void setValue(float value) {
        this.editor.scaling = value;
        if (this.editor.scaling > 10.0f) {
            this.editor.scaling = 10.0f;
            this.editor.setValue.accept(Float.valueOf(this.editor.scaling));
        }
        if (this.editor.scaling < 0.05f) {
            this.editor.scaling = 0.05f;
            this.editor.setValue.accept(Float.valueOf(this.editor.scaling));
        }
    }
}

