/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template.args;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.template.args.TexArg;
import java.util.List;
import java.util.Map;

public class TexEditorArg
implements TemplateArgHandler.TemplateArg<TexArg> {
    public static final String NAME = "__tex";
    private int u;
    private int v;
    private int texSize;
    private TexArg arg;
    private EditorTemplate et;

    @Override
    public void saveProject(Map<String, Object> map) {
    }

    @Override
    public void loadProject(Map<String, Object> map) {
    }

    @Override
    public TexArg export() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyArgs(Map<String, Object> map, List<ModelElement> parts) {
    }

    @Override
    public void loadTemplate(TexArg arg) {
        this.arg = arg;
        this.u = arg.u;
        this.v = arg.v;
        this.texSize = arg.texSize;
    }

    @Override
    public void applyToArg() {
        this.arg.u = this.u;
        this.arg.v = this.v;
        this.arg.texSize = this.texSize;
    }

    @Override
    public boolean requiresParts() {
        throw new UnsupportedOperationException();
    }

    private void setUV(Editor editor, Vec3f vec) {
        editor.action("set", "action.cpm.texUV").updateValueOp(this, this.u, (int)vec.x, 0, Integer.MAX_VALUE, (a, b) -> {
            a.u = b;
        }, v -> editor.setTexturePanel.accept(new Vec3i(this.u, (int)v, this.texSize))).updateValueOp(this, this.v, (int)vec.y, 0, Integer.MAX_VALUE, (a, b) -> {
            a.v = b;
        }, v -> editor.setTexturePanel.accept(new Vec3i(this.u, (int)v, this.texSize))).updateValueOp(this, this.texSize, (int)vec.z, 0, 64, (a, b) -> {
            a.texSize = b;
        }, v -> editor.setTexturePanel.accept(new Vec3i(this.u, (int)v, this.texSize))).execute();
        editor.templates.forEach(EditorTemplate::applyToModel);
    }

    private void draw(Editor editor, IGui gui, int x, int y, float xs, float ys, int alpha) {
        if (this.texSize != 0 && this.et.getTemplateTexture() != null) {
            int bx = (int)(xs * (float)this.u * (float)this.texSize);
            int by = (int)(ys * (float)this.v * (float)this.texSize);
            Image img = this.et.getTemplateTexture().getImage();
            gui.drawBox((float)(x + bx), (float)(y + by), (float)img.getWidth() * xs * (float)this.texSize, (float)img.getHeight() * ys * (float)this.texSize, 0xFFFFFF | alpha << 24);
        }
    }

    @Override
    public void createTreeElements(List<TreeElement> c, final Editor editor) {
        c.add(new TreeElement(){

            @Override
            public String getName() {
                return editor.gui().i18nFormat("label.cpm.template_tex_setup", new Object[0]);
            }

            @Override
            public void updateGui() {
                if (TexEditorArg.this.texSize != 0) {
                    editor.setModeBtn.accept(editor.gui().i18nFormat("button.cpm.template_remove_tex", new Object[0]));
                }
                editor.setModePanel.accept(PosPanel.ModeDisplayType.TEX);
                editor.setTexturePanel.accept(new Vec3i(TexEditorArg.this.u, TexEditorArg.this.v, TexEditorArg.this.texSize));
            }

            @Override
            public void modeSwitch() {
                if (TexEditorArg.this.texSize != 0) {
                    editor.frame.openPopup(new ConfirmPopup(editor.frame, editor.gui().i18nFormat("label.cpm.confirmDel", new Object[0]), editor.gui().i18nFormat("label.cpm.template_remove_tex", new Object[0]), () -> {
                        editor.action("i", "label.cpm.template_remove_tex").updateValueOp(TexEditorArg.this, TexEditorArg.this.texSize, 0, (a, b) -> ((TexEditorArg)a).texSize = b).execute();
                        editor.updateGui();
                    }, null));
                }
            }

            @Override
            public void setVec(Vec3f vec, TreeElement.VecType object) {
                if (object == TreeElement.VecType.TEXTURE) {
                    TexEditorArg.this.setUV(editor, vec);
                }
            }

            @Override
            public ETextures getTexture() {
                return editor.textures.get((Object)TextureSheetType.SKIN);
            }

            @Override
            public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
                TexEditorArg.this.draw(editor, gui, x, y, xs, ys, editor.selectedElement == this ? 204 : 85);
            }
        });
        c.add(new TreeElement(){

            @Override
            public String getName() {
                return editor.gui().i18nFormat("label.cpm.template_place_tex", new Object[0]);
            }

            @Override
            public void modeSwitch() {
                if (TexEditorArg.this.texSize == 0) {
                    TexEditorArg.this.texSize = 1;
                }
                editor.frame.openPopup(new ConfirmPopup(editor.frame, editor.gui().i18nFormat("label.cpm.template_place_tex.title", new Object[0]), editor.gui().i18nFormat("label.cpm.template_place_tex.desc", new Object[0]), () -> {
                    ETextures tex = editor2.textures.get((Object)TextureSheetType.SKIN);
                    ActionBuilder ab = editor.action("placeTex").updateValueOp(tex, new Image(tex.getImage()), tex.getImage(), ETextures::setImage).onAction(editor::restitchTextures);
                    tex.getImage().draw(TexEditorArg.this.et.getTemplateTexture().getImage(), TexEditorArg.this.u, TexEditorArg.this.v);
                    ab.execute();
                    editor.updateGui();
                }, null));
            }

            @Override
            public void updateGui() {
                editor.setModeBtn.accept(editor.gui().i18nFormat("button.cpm.template_place_tex", new Object[0]));
                editor.setModePanel.accept(PosPanel.ModeDisplayType.TEX);
                editor.setTexturePanel.accept(new Vec3i(TexEditorArg.this.u, TexEditorArg.this.v, TexEditorArg.this.texSize));
            }

            @Override
            public void setVec(Vec3f vec, TreeElement.VecType object) {
                if (object == TreeElement.VecType.TEXTURE) {
                    TexEditorArg.this.setUV(editor, vec);
                }
            }

            @Override
            public ETextures getTexture() {
                return editor.textures.get((Object)TextureSheetType.SKIN);
            }

            @Override
            public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
                if (editor.selectedElement == this) {
                    TexEditorArg.this.draw(editor, gui, x, y, xs, ys, 204);
                }
            }
        });
    }

    public void bind(EditorTemplate et) {
        this.et = et;
    }
}

