/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.RootGroups;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;

public class TexturesLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "textures";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        JsonMap data = project.getJson("config.json");
        JsonMap texDt = data.getMap("textures");
        for (TextureSheetType tex : TextureSheetType.VALUES) {
            String name = tex.name().toLowerCase();
            if (!tex.editable) {
                if (!data.getBoolean(name + "Tex", false) && project.getEntry(name + ".png") == null) continue;
                ETextures eTex = editor.textures.get((Object)tex);
                if (eTex == null) {
                    eTex = new ETextures(editor, tex);
                }
                editor.textures.put(tex, eTex);
                eTex.provider.size = tex.getDefSize();
                Image def = new Image(eTex.provider.size.x, eTex.provider.size.y);
                try (InputStream is2 = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/" + tex.name().toLowerCase() + ".png");){
                    def = Image.loadFrom(is2);
                }
                catch (IOException is2) {
                    // empty catch block
                }
                eTex.setDefaultImg(def);
                eTex.setImage(new Image(def));
                eTex.markDirty();
                continue;
            }
            Image img = project.getIfExists(name + ".png", Image::loadFrom);
            if (img == null) continue;
            if (img.getWidth() > 8192 || img.getHeight() > 8192) {
                Log.error("Illegal image size for texture: " + name);
                continue;
            }
            ETextures eTex = editor.textures.get((Object)tex);
            if (eTex == null) {
                eTex = new ETextures(editor, tex);
            }
            editor.textures.put(tex, eTex);
            eTex.setImage(img);
            eTex.markDirty();
            JsonMap skinTexSize = data.getMap(name + "Size");
            eTex.provider.size = new Vec2i(skinTexSize, tex.getDefSize());
            if (texDt == null || !texDt.containsKey(name)) continue;
            this.loadAnimatedTexture(editor, texDt.getMap(name), eTex, tex);
        }
        HashSet<RootGroups> groups = new HashSet<RootGroups>();
        for (ModelElement e : editor.elements) {
            for (RootModelType rmt : RootModelType.VALUES) {
                if (e.typeData != rmt) continue;
                groups.add(RootGroups.getGroup(rmt));
            }
        }
        groups.forEach(g -> Generators.loadTextures(editor, g, editor.textures::put));
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        JsonMap data = project.getJson("config.json");
        JsonMap texDt = data.putMap("textures");
        for (TextureSheetType tex : TextureSheetType.VALUES) {
            String name = tex.name().toLowerCase();
            ETextures eTex = editor.textures.get((Object)tex);
            if (eTex != null) {
                if (eTex.isEditable()) {
                    HashMap<String, Integer> size = new HashMap<String, Integer>();
                    data.put(name + "Size", size);
                    size.put("x", eTex.provider.size.x);
                    size.put("y", eTex.provider.size.y);
                    if (eTex.provider.texture != null && eTex.isEdited()) {
                        project.putFile(name + ".png", eTex.getImage(), Image::storeTo);
                    }
                    this.saveAnimatedTexture(texDt.putMap(name), eTex);
                    continue;
                }
                data.put(name + "Tex", true);
                continue;
            }
            project.delete(name + ".png");
        }
    }

    protected void loadAnimatedTexture(Editor editor, JsonMap dt, ETextures tex, TextureSheetType sheet) {
        JsonList list = dt.getList("anim");
        list.forEachMap(elem -> tex.animatedTexs.add(new AnimatedTex(editor, sheet, (JsonMap)elem)));
    }

    protected void saveAnimatedTexture(JsonMap dt, ETextures tex) {
        JsonList list = dt.putList("anim");
        tex.animatedTexs.forEach(t -> t.save(list.addMap()));
    }
}

