/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.template.TemplateArgType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class TemplateLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "template";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        project.jsonIfExists("templates.json", data -> {
            JsonList lst = data.getList("templates");
            lst.forEachMap(map -> editor.templates.add(EditorTemplate.load(editor, map)));
        });
        project.jsonIfExists("template_settings.json", data -> {
            editor.templateSettings.hasTex = data.getBoolean("texture");
            JsonList lst = data.getList("args");
            lst.forEachMap(map -> {
                TemplateArgType type = TemplateArgType.lookup(map.getString("type"));
                TemplateArgHandler arg = new TemplateArgHandler(editor, map.getString("name"), map.getString("desc"), type);
                editor.templateSettings.templateArgs.add(arg);
                arg.handler.loadProject(map.getMap("data").asMap());
                if (arg.handler.requiresParts() && arg.effectedElems != null) {
                    JsonList partList = map.getList("parts");
                    partList.forEach(e -> Editor.walkElements(editor.elements, elem -> {
                        if (elem.storeID == e.longValue()) {
                            arg.effectedElems.add((ModelElement)elem);
                        }
                    }));
                }
            });
            List templElems = data.getList("displayElems").stream().map(Number::longValue).collect(Collectors.toList());
            Editor.walkElements(editor.elements, e -> {
                if (templElems.contains(e.storeID)) {
                    e.templateElement = true;
                }
            });
        });
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        JsonList lst;
        JsonMap data;
        if (!editor.templates.isEmpty()) {
            data = project.getJson("templates.json");
            lst = data.putList("templates");
            for (EditorTemplate templ : editor.templates) {
                HashMap<String, Object> t = new HashMap<String, Object>();
                lst.add(t);
                templ.store(t);
            }
        }
        if (editor.templateSettings != null) {
            data = project.getJson("template_settings.json");
            lst = data.putList("args");
            data.put("texture", editor.templateSettings.hasTex);
            for (TemplateArgHandler arg : editor.templateSettings.templateArgs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                lst.add(map);
                map.put("name", arg.name);
                map.put("desc", arg.desc);
                map.put("type", arg.type.name().toLowerCase());
                if (arg.handler.requiresParts() && arg.effectedElems != null) {
                    ArrayList partList = new ArrayList();
                    arg.effectedElems.forEach(e -> partList.add(e.storeID));
                    map.put("parts", partList);
                }
                HashMap<String, Object> m = new HashMap<String, Object>();
                map.put("data", m);
                arg.handler.saveProject(m);
            }
            ArrayList dispIds = new ArrayList();
            data.put("displayElems", dispIds);
            Editor.walkElements(editor.elements, e -> {
                if (e.templateElement) {
                    dispIds.add(e.storeID);
                }
            });
        }
    }

    @Override
    public int getLoadOrder() {
        return 1;
    }
}

