/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project;

import com.tom.cpm.shared.editor.project.JsonList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public interface JsonMap {
    public Object get(String var1);

    public JsonMap getMap(String var1);

    public JsonList getList(String var1);

    public void forEach(BiConsumer<String, Object> var1);

    default public Object getOrDefault(String name, Object def) {
        Object v = this.get(name);
        if (v == null) {
            return def;
        }
        return v;
    }

    default public int getInt(String name) {
        return ((Number)this.get(name)).intValue();
    }

    default public int getInt(String name, int def) {
        return ((Number)this.getOrDefault(name, def)).intValue();
    }

    default public float getFloat(String name) {
        return ((Number)this.get(name)).floatValue();
    }

    default public float getFloat(String name, float def) {
        return ((Number)this.getOrDefault(name, Float.valueOf(def))).floatValue();
    }

    default public boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    default public boolean getBoolean(String name, boolean def) {
        return (Boolean)this.getOrDefault(name, def);
    }

    default public String getString(String name) {
        return (String)this.get(name);
    }

    default public String getString(String name, String def) {
        return (String)this.getOrDefault(name, def);
    }

    default public long getLong(String name) {
        return ((Number)this.get(name)).longValue();
    }

    default public long getLong(String name, long def) {
        return ((Number)this.getOrDefault(name, def)).longValue();
    }

    default public boolean containsKey(String name) {
        return this.get(name) != null;
    }

    public Map<String, Object> asMap();

    public void put(String var1, Object var2);

    default public JsonMap putMap(String name) {
        JsonMap map = this.getMap(name);
        if (map == null) {
            this.put(name, new HashMap());
        }
        return this.getMap(name);
    }

    default public JsonList putList(String name) {
        JsonList map = this.getList(name);
        if (map == null) {
            this.put(name, new ArrayList());
        }
        return this.getList(name);
    }

    default public <T> T getObject(String name, BiFunction<JsonMap, T, T> ctr, T def) {
        return ctr.apply(this.getMap(name), (JsonMap)def);
    }
}

