/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.util.PaintImageCreator;

public class ViewportPaintPanel
extends ViewportPanel {
    private int color;
    private int dragging;

    public ViewportPaintPanel(IGui gui, Editor editor) {
        super(gui, editor);
    }

    @Override
    public void render(MatrixStack stack, VBuffers buf, float partialTicks) {
        if (this.editor.renderBase && !this.editor.renderPaint) {
            this.renderBase(stack, buf);
        }
        this.renderModel(stack, buf, partialTicks);
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.editor.renderPaint = true;
        super.draw(event, partialTicks);
        this.editor.renderPaint = false;
        int colorUnderMouse = this.getColorUnderMouse();
        this.color = this.bounds.isInBounds(this.mouseCursorPos.x - this.bounds.x, this.mouseCursorPos.y - this.bounds.y) ? colorUnderMouse : 0;
        if (!MinecraftObjectHolder.DEBUGGING || !this.gui.isAltDown()) {
            this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, -13421773);
            super.draw(event, partialTicks);
        }
        if (MinecraftObjectHolder.DEBUGGING) {
            ETextures tex;
            Vec2i v = this.getHoveredTexPos();
            if (v != null) {
                this.gui.drawText(this.bounds.x, this.bounds.y, v.x + " " + v.y, -1);
            }
            Vec2i size = (tex = this.editor.getTextureProvider()) != null ? tex.provider.size : new Vec2i(64, 64);
            this.gui.drawText(this.bounds.x, this.bounds.y + 10, "(" + size.x + " " + size.y + ")", -1);
            if ((this.color & 0xC00000) == 0) {
                this.gui.drawText(this.bounds.x, this.bounds.y + 20, "Out of bounds", -1);
            } else {
                int x = this.color >> 10 & 0x3FF;
                int y = this.color & 0x3FF;
                this.gui.drawText(this.bounds.x, this.bounds.y + 20, "(" + x + " " + y + ")", -1);
            }
            this.gui.drawText(this.bounds.x, this.bounds.y + 30, Integer.toHexString(this.color), -1);
            this.gui.drawBox(this.bounds.x, this.bounds.y + 40, 16, 16, -1);
            this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 41, 14, 14, this.color | 0xFF000000);
        }
    }

    public Vec2i getHoveredTexPos() {
        ETextures tex = this.editor.getTextureProvider();
        Vec2i size = tex != null ? tex.provider.size : new Vec2i(64, 64);
        return PaintImageCreator.getImageCoords(this.color, size.x, size.y);
    }

    @Override
    public boolean mouseClick(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y) && btn == 0) {
            this.dragging = 1;
            Vec2i v = this.getHoveredTexPos();
            if (v != null) {
                if (this.gui.isCtrlDown()) {
                    ETextures tex = this.editor.getTextureProvider();
                    if (tex != null) {
                        this.editor.penColor = tex.getImage().getRGB(v.x, v.y);
                        this.editor.setPenColor.accept(this.editor.penColor);
                        this.dragging = 2;
                    }
                } else {
                    this.editor.drawPixel(v.x, v.y, true);
                }
            }
            return true;
        }
        return super.mouseClick(x, y, btn);
    }

    @Override
    public boolean mouseDrag(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y) && btn == 0) {
            Vec2i v = this.getHoveredTexPos();
            if (v != null) {
                ETextures tex;
                if (this.dragging == 1) {
                    this.editor.drawPixel(v.x, v.y, true);
                } else if (this.dragging == 2 && (tex = this.editor.getTextureProvider()) != null) {
                    this.editor.penColor = tex.getImage().getRGB(v.x, v.y);
                    this.editor.setPenColor.accept(this.editor.penColor);
                }
            }
            return true;
        }
        return super.mouseDrag(x, y, btn);
    }

    @Override
    public boolean mouseRelease(int x, int y, int btn) {
        if (btn == 0 && this.dragging > 0) {
            this.dragging = 0;
            return true;
        }
        return super.mouseRelease(x, y, btn);
    }

    @Override
    public boolean applyLighting() {
        return !this.editor.renderPaint;
    }
}

