/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.RootGroups;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.VanillaModelPart;

public class TextureDisplay
extends GuiElement {
    private Editor editor;

    public TextureDisplay(IGui gui, Editor editor) {
        super(gui);
        this.editor = editor;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        ETextures provider = this.editor.getTextureProvider();
        if (provider != null) {
            this.gui.pushMatrix();
            this.gui.setPosOffset(this.getBounds());
            this.gui.setupCut();
            this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.gui.getColors().button_fill);
            provider.provider.bind();
            this.gui.drawTexture(0, 0, this.bounds.w, this.bounds.h, 0.0f, 0.0f, 1.0f, 1.0f);
            float x = (float)this.bounds.w / (float)provider.provider.size.x;
            float y = (float)this.bounds.h / (float)provider.provider.size.y;
            TextureDisplay.drawBoxTextureOverlay(this.gui, this.editor, 0, 0, x, y);
            this.gui.popMatrix();
            this.gui.setupCut();
        }
    }

    public static void drawBoxTextureOverlay(IGui gui, Editor editor, int x, int y, float xs, float ys) {
        if (editor.drawAllUVs) {
            ETextures provider = editor.getTextureProvider();
            Editor.walkElements(editor.elements, e -> {
                if (e.getTexture() == provider) {
                    e.drawTexture(gui, x, y, xs, ys);
                }
            });
        } else if (editor.selectedElement != null) {
            editor.selectedElement.drawTexture(gui, x, y, xs, ys);
        }
    }

    public static void drawBoxTextureOverlay(IGui gui, ModelElement element, int x, int y, float xs, float ys, int alpha) {
        if (element.type == ElementType.NORMAL) {
            int a = alpha << 24;
            if (element.singleTex) {
                Box bx = element.getTextureBox();
                gui.drawBox((float)x + (float)bx.x * xs, (float)y + (float)bx.y * ys, (float)bx.w * xs, (float)bx.h * ys, 0xFFFFFF | a);
            } else if (element.faceUV != null) {
                if (element.faceUV.contains(element.editor.perfaceFaceDir)) {
                    Vec4f vec = element.faceUV.getVec(element.editor.perfaceFaceDir);
                    float su = Math.min(vec.x, vec.z);
                    float sv = Math.min(vec.y, vec.w);
                    float eu = Math.max(vec.x, vec.z);
                    float ev = Math.max(vec.y, vec.w);
                    gui.drawBox((float)x + su * xs, (float)y + sv * ys, (eu - su) * xs, (ev - sv) * ys, 0xFFFFFF | a);
                }
            } else {
                int ts = Math.abs(element.texSize);
                int bx = (int)(xs * (float)element.u * (float)ts);
                int by = (int)(ys * (float)element.v * (float)ts);
                int dx = MathHelper.ceil(element.size.x * (float)ts);
                int dy = MathHelper.ceil(element.size.y * (float)ts);
                int dz = MathHelper.ceil(element.size.z * (float)ts);
                gui.drawBox((float)(x + bx) + (float)dx * xs + (float)dz * xs, (float)(y + by) + (float)dz * ys, (float)dz * xs, (float)dy * ys, 0xFF0000 | a);
                gui.drawBox((float)(x + bx), (float)(y + by) + (float)dz * ys, (float)dz * xs, (float)dy * ys, 0xDD0000 | a);
                gui.drawBox((float)(x + bx) + (float)dz * xs, (float)(y + by), (float)dx * xs, (float)dz * ys, 0xFF00 | a);
                gui.drawBox((float)(x + bx) + (float)dz * xs + (float)dx * xs, (float)(y + by), (float)dx * xs, (float)dz * ys, 0xDD00 | a);
                gui.drawBox((float)(x + bx) + (float)dz * xs, (float)(y + by) + (float)dz * ys, (float)dx * xs, (float)dy * ys, 0xFF | a);
                gui.drawBox((float)(x + bx) + (float)dz * xs * 2.0f + (float)dx * xs, (float)(y + by) + (float)dz * ys, (float)dx * xs, (float)dy * ys, 0xDD | a);
            }
        } else if (element.type == ElementType.ROOT_PART) {
            Object size;
            RootGroups gr;
            PartValues val = ((VanillaModelPart)element.typeData).getDefaultSize(element.editor.skinType);
            float texW = 64.0f;
            float texH = 64.0f;
            if (element.typeData instanceof RootModelType && (gr = RootGroups.getGroup((RootModelType)element.typeData)) != null) {
                TextureSheetType sheet = gr.getTexSheet((RootModelType)element.typeData);
                size = sheet.getDefSize();
                texW = ((Vec2i)size).x;
                texH = ((Vec2i)size).y;
            }
            ETextures provider = element.getTexture();
            xs = xs * (float)provider.provider.size.x / texW;
            ys = ys * (float)provider.provider.size.y / texH;
            Vec2i uv = val.getUV();
            size = val.getSize();
            int bx = (int)(xs * (float)uv.x);
            int by = (int)(ys * (float)uv.y);
            int dx = MathHelper.ceil(((Vec3f)size).x);
            int dy = MathHelper.ceil(((Vec3f)size).y);
            int dz = MathHelper.ceil(((Vec3f)size).z);
            int a = alpha << 24;
            gui.drawBox((float)(x + bx) + (float)dx * xs + (float)dz * xs, (float)(y + by) + (float)dz * ys, (float)dz * xs, (float)dy * ys, 0xFF0000 | a);
            gui.drawBox((float)(x + bx), (float)(y + by) + (float)dz * ys, (float)dz * xs, (float)dy * ys, 0xDD0000 | a);
            gui.drawBox((float)(x + bx) + (float)dz * xs, (float)(y + by), (float)dx * xs, (float)dz * ys, 0xFF00 | a);
            gui.drawBox((float)(x + bx) + (float)dz * xs + (float)dx * xs, (float)(y + by), (float)dx * xs, (float)dz * ys, 0xDD00 | a);
            gui.drawBox((float)(x + bx) + (float)dz * xs, (float)(y + by) + (float)dz * ys, (float)dx * xs, (float)dy * ys, 0xFF | a);
            gui.drawBox((float)(x + bx) + (float)dz * xs * 2.0f + (float)dx * xs, (float)(y + by) + (float)dz * ys, (float)dx * xs, (float)dy * ys, 0xDD | a);
        }
    }
}

