/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.gui.EditorGui;

public class TestIngameManager {
    private static final String VANILLA_MODEL = "~~VANILLA~~";

    public static void checkConfig() {
        String old = ModConfig.getCommonConfig().getString("selectedModelOld", null);
        if (old != null) {
            ModConfig.getCommonConfig().clearValue("selectedModelOld");
            if (VANILLA_MODEL.equals(old)) {
                ModConfig.getCommonConfig().clearValue("selectedModel");
            } else {
                ModConfig.getCommonConfig().setString("selectedModel", old);
            }
            ModConfig.getCommonConfig().save();
        }
    }

    public static boolean openTestIngame(EditorGui e) {
        if (e.getEditor().dirty || e.getEditor().file == null) {
            e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.error", new Object[0]), e.getGui().i18nFormat("label.cpm.must_save.test", new Object[0])));
            return false;
        }
        try {
            Runnable open;
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                open = () -> {
                    MinecraftClientAccess.get().sendSkinUpdate();
                    e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.info", new Object[0]), e.getGui().i18nFormat("label.cpm.test_model_exported", new Object[0])));
                };
            } else if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.OFFLINE) {
                open = MinecraftClientAccess.get().openSingleplayer();
            } else {
                throw new UnsupportedOperationException();
            }
            if (!Exporter.exportTempModel(e.getEditor(), e)) {
                return false;
            }
            String model = ModConfig.getCommonConfig().getString("selectedModel", null);
            if (model != null) {
                ModConfig.getCommonConfig().setString("selectedModelOld", model);
            } else {
                ModConfig.getCommonConfig().setString("selectedModelOld", VANILLA_MODEL);
            }
            ModConfig.getCommonConfig().setString("selectedModel", ".temp.cpmmodel");
            open.run();
            ModConfig.getCommonConfig().setString("reopenProject", e.getEditor().file.getAbsolutePath());
            ModConfig.getCommonConfig().save();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.error", new Object[0]), e.getGui().i18nFormat("label.cpm.test_unsupported", new Object[0])));
            return false;
        }
    }
}

