/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.model.render.PerFaceUV;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class PerfaceUVPanel
extends Panel {
    public PerfaceUVPanel(IGui gui, EditorGui e, TabFocusHandler tabHandler) {
        super(gui);
        this.setBounds(new Box(0, 0, 170, 95));
        Editor editor = e.getEditor();
        DropDownBox faces = new DropDownBox(e, Arrays.stream(PerFaceUV.Dir.VALUES).map(d -> new NamedElement<PerFaceUV.Dir>((PerFaceUV.Dir)((Object)d), dir -> gui.i18nFormat("label.cpm.dir." + dir.name().toLowerCase(), new Object[0]))).collect(Collectors.toList()));
        faces.setBounds(new Box(5, 0, 160, 20));
        faces.setAction(() -> {
            editor.perfaceFaceDir = (PerFaceUV.Dir)((Object)((Object)((NamedElement)faces.getSelected()).getElem()));
            editor.updateGui();
        });
        this.addElement(faces);
        Spinner spinnerSU = new Spinner(gui);
        Spinner spinnerSV = new Spinner(gui);
        Spinner spinnerEU = new Spinner(gui);
        Spinner spinnerEV = new Spinner(gui);
        spinnerSU.setBounds(new Box(5, 25, 35, 18));
        spinnerSV.setBounds(new Box(45, 25, 35, 18));
        spinnerEU.setBounds(new Box(85, 25, 35, 18));
        spinnerEV.setBounds(new Box(125, 25, 35, 18));
        spinnerSU.setDp(0);
        spinnerSV.setDp(0);
        spinnerEU.setDp(0);
        spinnerEV.setDp(0);
        Runnable r = () -> {
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("set", "action.cpm.texUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                Vec4f v = new Vec4f(spinnerSU.getValue(), spinnerSV.getValue(), spinnerEU.getValue(), spinnerEV.getValue());
                if (f.autoUV) {
                    PerfaceUVPanel.autoUV(v, editor.perfaceFaceDir, el.size);
                    editor.setFaceUVs.accept(v);
                }
                ab.updateValueOp(f, f.getVec(), v, PerFaceUV.Face::set);
                ab.execute();
            }
        };
        Runnable r2 = () -> {
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("set", "action.cpm.texUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                Vec4f v = new Vec4f(spinnerSU.getValue(), spinnerSV.getValue(), spinnerEU.getValue(), spinnerEV.getValue());
                ab.updateValueOp(f, f.getVec(), v, PerFaceUV.Face::set);
                ab.updateValueOp(f, f.autoUV, false, (a, b) -> {
                    a.autoUV = b;
                });
                ab.execute();
            }
        };
        spinnerSU.addChangeListener(r);
        spinnerSV.addChangeListener(r);
        spinnerEU.addChangeListener(r2);
        spinnerEV.addChangeListener(r2);
        tabHandler.add(spinnerSU);
        tabHandler.add(spinnerSV);
        tabHandler.add(spinnerEU);
        tabHandler.add(spinnerEV);
        this.addElement(spinnerSU);
        this.addElement(spinnerSV);
        this.addElement(spinnerEU);
        this.addElement(spinnerEV);
        editor.setFaceUVs.add(v -> {
            spinnerSU.setValue(v.x);
            spinnerSV.setValue(v.y);
            spinnerEU.setValue(v.z);
            spinnerEV.setValue(v.w);
        });
        TreeMap<PerFaceUV.Rot, NamedElement<PerFaceUV.Rot>> rotMap = new TreeMap<PerFaceUV.Rot, NamedElement<PerFaceUV.Rot>>();
        for (PerFaceUV.Rot ro : PerFaceUV.Rot.VALUES) {
            rotMap.put(ro, new NamedElement<PerFaceUV.Rot>(ro, rot -> gui.i18nFormat("label.cpm.rot." + rot.name().toLowerCase(), new Object[0])));
        }
        DropDownBox rots = new DropDownBox(e, new ArrayList(rotMap.values()));
        rots.setBounds(new Box(5, 45, 80, 20));
        rots.setAction(() -> {
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("rotateUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                ab.updateValueOp(f, f.rotation, ((NamedElement)rots.getSelected()).getElem(), (a, b) -> {
                    a.rotation = b;
                });
                ab.execute();
            }
        });
        editor.setFaceRot.add(rot -> rots.setSelected(rotMap.get(rot)));
        this.addElement(rots);
        Checkbox autoUV = new Checkbox(gui, gui.i18nFormat("label.cpm.auto_uv", new Object[0]));
        autoUV.setAction(() -> {
            autoUV.setSelected(!autoUV.isSelected());
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("autoUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                ab.updateValueOp(f, f.autoUV, autoUV.isSelected(), (a, b) -> {
                    a.autoUV = b;
                });
                if (!f.autoUV) {
                    Vec4f v = f.getVec();
                    PerfaceUVPanel.autoUV(v, editor.perfaceFaceDir, el.size);
                    ab.updateValueOp(f, f.getVec(), v, PerFaceUV.Face::set);
                    editor.setFaceUVs.accept(v);
                }
                ab.execute();
            }
        });
        autoUV.setBounds(new Box(5, 70, 60, 18));
        editor.setAutoUV.add(autoUV::updateState);
        this.addElement(autoUV);
        ButtonIcon delBtn = new ButtonIcon(gui, "editor", 14, 16, () -> {
            PerFaceUV.Face f;
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null && (f = el.faceUV.faces.get((Object)editor.perfaceFaceDir)) != null) {
                editor.action("deleteFace").removeFromMap(el.faceUV.faces, editor.perfaceFaceDir, f).execute();
                editor.updateGui();
            }
        });
        delBtn.setBounds(new Box(70, 70, 18, 18));
        delBtn.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.deleteFace", new Object[0])));
        this.addElement(delBtn);
        Button toAllUVs = new Button(gui, gui.i18nFormat("button.cpm.toAllFaces", new Object[0]), () -> {
            PerFaceUV.Face f;
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null && (f = el.faceUV.faces.get((Object)editor.perfaceFaceDir)) != null) {
                ActionBuilder ab = editor.action("toAllFaces");
                for (PerFaceUV.Dir d : PerFaceUV.Dir.VALUES) {
                    if (d == editor.perfaceFaceDir) continue;
                    ab.addToMap(el.faceUV.faces, d, new PerFaceUV.Face(f));
                }
                ab.execute();
                editor.updateGui();
            }
        });
        toAllUVs.setBounds(new Box(92, 70, 70, 18));
        toAllUVs.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.toAllFaces", new Object[0])));
        this.addElement(toAllUVs);
    }

    private static PerFaceUV.Face getFace(Editor editor, ActionBuilder ab) {
        ModelElement el = editor.getSelectedElement();
        PerFaceUV.Face f = el.faceUV.faces.get((Object)editor.perfaceFaceDir);
        if (f == null) {
            f = new PerFaceUV.Face();
            ab.addToMap(el.faceUV.faces, editor.perfaceFaceDir, f);
        }
        return f;
    }

    private static void autoUV(Vec4f v, PerFaceUV.Dir dir, Vec3f size) {
        int dx = MathHelper.ceil(size.x);
        int dy = MathHelper.ceil(size.y);
        int dz = MathHelper.ceil(size.z);
        int tx = (int)v.x;
        int ty = (int)v.y;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                tx += dx;
                ty += dy;
                break;
            }
            case UP: 
            case DOWN: {
                tx += dx;
                ty += dz;
                break;
            }
            case EAST: 
            case WEST: {
                tx += dz;
                ty += dy;
                break;
            }
        }
        v.z = tx;
        v.w = ty;
    }
}

