/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.EditorGui;
import java.util.ArrayList;
import java.util.HashSet;

public class AnimTestPanel
extends Panel {
    private Editor editor;
    private DropDownBox<NamedElement<IPose>> poseSel;
    private DropDownBox<NamedElement<String>> gestureSel;

    public AnimTestPanel(IGui gui, EditorGui e) {
        super(gui);
        this.editor = e.getEditor();
        this.setBounds(new Box(0, 0, 170, 80));
        this.setBackgroundColor(gui.getColors().panel_background);
        ArrayList poses = new ArrayList();
        ArrayList gestures = new ArrayList();
        this.editor.updateGui.add(() -> {
            poses.clear();
            gestures.clear();
            gestures.add(new NamedElement<String>(null, k -> gui.i18nFormat("label.cpm.no_gesture", new Object[0])));
            for (VanillaPose p : VanillaPose.VALUES) {
                if (p == VanillaPose.CUSTOM || p == VanillaPose.GLOBAL) continue;
                poses.add(new NamedElement<IPose>(p, k -> k.getName(gui, null)));
            }
            HashSet addedGestures = new HashSet();
            HashSet addedPoses = new HashSet();
            this.editor.animations.forEach(a -> {
                if (a.isCustom()) {
                    if (a.pose != null) {
                        String name = ((CustomPose)a.pose).getName();
                        if (!addedPoses.contains(name)) {
                            addedPoses.add(name);
                            poses.add(new NamedElement<IPose>(a.pose, k -> name));
                        }
                    } else if (!addedGestures.contains(a.displayName)) {
                        addedGestures.add(a.displayName);
                        gestures.add(new NamedElement<String>(a.displayName, k -> k));
                    }
                }
            });
        });
        this.addElement(new Label(gui, gui.i18nFormat("label.cpm.pose", new Object[0])).setBounds(new Box(5, 5, 160, 10)));
        this.poseSel = new DropDownBox(e, poses);
        this.poseSel.setBounds(new Box(5, 15, 160, 20));
        this.addElement(this.poseSel);
        this.addElement(new Label(gui, gui.i18nFormat("label.cpm.gesture", new Object[0])).setBounds(new Box(5, 40, 160, 10)));
        this.gestureSel = new DropDownBox(e, gestures);
        this.gestureSel.setBounds(new Box(5, 50, 160, 20));
        this.gestureSel.setAction(() -> {
            this.editor.gestureStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
        });
        this.addElement(this.gestureSel);
        this.editor.gestureFinished.add(() -> this.gestureSel.setSelected(null));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.editor.playStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
            this.editor.playFullAnim = true;
            this.editor.selectedAnim = null;
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        NamedElement<String> gesture;
        super.draw(event, partialTicks);
        this.editor.animsToPlay.clear();
        NamedElement<IPose> pose = this.poseSel.getSelected();
        if (pose != null) {
            this.editor.poseToApply = pose.getElem();
            for (EditorAnim anim : this.editor.animations) {
                if (anim.pose != null && (anim.pose == pose.getElem() || pose.getElem() instanceof CustomPose && anim.pose instanceof CustomPose && ((CustomPose)pose.getElem()).getName().equals(((CustomPose)anim.pose).getName()))) {
                    this.editor.animsToPlay.add(anim);
                    continue;
                }
                if (anim.pose != VanillaPose.GLOBAL) continue;
                this.editor.animsToPlay.add(anim);
            }
        }
        if ((gesture = this.gestureSel.getSelected()) != null && gesture.getElem() != null) {
            for (EditorAnim anim : this.editor.animations) {
                if (!anim.isCustom() || anim.pose != null || !anim.displayName.equals(gesture.getElem())) continue;
                this.editor.animsToPlay.add(anim);
            }
        }
    }
}

