/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.InterpolatorChannel;

public interface IElem {
    public Vec3f getPosition();

    public Vec3f getRotation();

    public Vec3f getColor();

    public boolean isVisible();

    default public float part(InterpolatorChannel i) {
        switch (i) {
            case POS_X: {
                return this.getPosition().x;
            }
            case POS_Y: {
                return this.getPosition().y;
            }
            case POS_Z: {
                return this.getPosition().z;
            }
            case ROT_X: {
                return (float)Math.toRadians(this.getRotation().x);
            }
            case ROT_Y: {
                return (float)Math.toRadians(this.getRotation().y);
            }
            case ROT_Z: {
                return (float)Math.toRadians(this.getRotation().z);
            }
            case COLOR_R: {
                return this.getColor().x;
            }
            case COLOR_G: {
                return this.getColor().y;
            }
            case COLOR_B: {
                return this.getColor().z;
            }
        }
        return 0.0f;
    }
}

