/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.PolynomialSplineInterpolator;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.AnimationType;
import com.tom.cpm.shared.editor.gui.AnimPanel;
import com.tom.cpm.shared.editor.project.JsonMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;

public class EditorAnim
implements AnimPanel.IAnim {
    private List<ModelElement> components;
    private final List<AnimFrame> frames = new ArrayList<AnimFrame>();
    public int duration = 1000;
    private DoubleUnaryOperator[][] psfs;
    private AnimFrame currentFrame;
    public final Editor editor;
    public String filename;
    public AnimationType type;
    public IPose pose;
    public String displayName;
    public boolean add = true;
    public boolean loop;
    public int priority;

    public EditorAnim(Editor e, String filename, AnimationType type, boolean initNew) {
        this.editor = e;
        this.filename = filename;
        this.type = type;
        if (initNew) {
            this.addFrame();
        }
    }

    private void calculateSplines() {
        this.components = this.frames.stream().flatMap(AnimFrame::getAllElements).distinct().collect(Collectors.toList());
        this.psfs = new DoubleUnaryOperator[this.components.size()][InterpolatorChannel.VALUES.length];
        for (int component = 0; component < this.components.size(); ++component) {
            for (InterpolatorChannel channel : InterpolatorChannel.VALUES) {
                PolynomialSplineInterpolator i = new PolynomialSplineInterpolator();
                i.init(AnimFrame.toArray(this, this.components.get(component), channel), channel);
                this.psfs[component][channel.channelID()] = i;
            }
        }
    }

    public float getValue(ModelElement component, InterpolatorChannel attribute, double time) {
        return (float)this.psfs[this.components.indexOf(component)][attribute.channelID()].applyAsDouble(time);
    }

    public void apply() {
        if (this.currentFrame != null) {
            this.currentFrame.apply();
        }
    }

    public void applyPlay(long millis) {
        if (this.components == null || this.psfs == null) {
            this.calculateSplines();
        }
        float step = (float)millis % (float)this.duration / (float)this.duration * (float)this.frames.size();
        for (int i = 0; i < this.components.size(); ++i) {
            ModelElement component = this.components.get(i);
            component.rc.setRotation(this.add, this.getValue(component, InterpolatorChannel.ROT_X, step), this.getValue(component, InterpolatorChannel.ROT_Y, step), this.getValue(component, InterpolatorChannel.ROT_Z, step));
            component.rc.setPosition(this.add, this.getValue(component, InterpolatorChannel.POS_X, step), this.getValue(component, InterpolatorChannel.POS_Y, step), this.getValue(component, InterpolatorChannel.POS_Z, step));
            component.rc.setColor(this.getValue(component, InterpolatorChannel.COLOR_R, step), this.getValue(component, InterpolatorChannel.COLOR_G, step), this.getValue(component, InterpolatorChannel.COLOR_B, step));
            component.rc.setVisible(this.frames.get((int)step).getVisible(component));
        }
    }

    public void setPosition(Vec3f v) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setPos(this.editor.getSelectedElement(), v);
        }
        this.components = null;
        this.psfs = null;
    }

    public void setRotation(Vec3f v) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setRot(this.editor.getSelectedElement(), v);
        }
        this.components = null;
        this.psfs = null;
    }

    public void switchVisible() {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.switchVis(this.editor.getSelectedElement());
        }
        this.components = null;
        this.psfs = null;
    }

    public void clearSelectedData() {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.clearSelectedData(this.editor.getSelectedElement());
        }
        this.components = null;
        this.psfs = null;
    }

    public void setColor(int rgb) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setColor(this.editor.getSelectedElement(), rgb);
        }
        this.components = null;
        this.psfs = null;
    }

    public void addFrame() {
        AnimFrame frm = new AnimFrame(this);
        this.editor.action("add", "action.cpm.animFrame").addToList(this.frames, frm).onAction(this::clearCache).execute();
        if (this.currentFrame != null) {
            frm.copy(this.currentFrame);
        }
        this.currentFrame = frm;
    }

    public void deleteFrame() {
        if (this.currentFrame != null) {
            this.editor.action("remove", "action.cpm.animFrame").removeFromList(this.frames, this.currentFrame).onAction(this::clearCache).execute();
        }
    }

    public void loadFrame(JsonMap data) {
        AnimFrame frm = new AnimFrame(this);
        frm.loadFrom(data);
        this.frames.add(frm);
        if (this.currentFrame == null) {
            this.currentFrame = frm;
        }
    }

    public List<Map<String, Object>> writeFrames() {
        return this.frames.stream().map(AnimFrame::store).collect(Collectors.toList());
    }

    public List<AnimFrame> getFrames() {
        return this.frames;
    }

    public List<ModelElement> getComponentsFiltered() {
        return this.frames.stream().flatMap(AnimFrame::getAllElementsFiltered).distinct().collect(Collectors.toList());
    }

    public String toString() {
        if (this.pose != null) {
            return this.editor.gui().i18nFormat("label.cpm.anim_pose", this.pose.getName(this.editor.gui(), this.displayName));
        }
        return this.editor.gui().i18nFormat("label.cpm.anim_gesture", this.displayName);
    }

    public AnimFrame getSelectedFrame() {
        return this.currentFrame;
    }

    public void prevFrame() {
        if (this.currentFrame == null && !this.frames.isEmpty()) {
            this.currentFrame = this.frames.get(0);
        }
        if (this.frames.size() > 1) {
            int ind = this.frames.indexOf(this.currentFrame) - 1 + this.frames.size();
            this.currentFrame = this.frames.get(ind % this.frames.size());
        }
    }

    public void nextFrame() {
        if (this.currentFrame == null && !this.frames.isEmpty()) {
            this.currentFrame = this.frames.get(0);
        }
        if (this.frames.size() > 1) {
            int ind = this.frames.indexOf(this.currentFrame) + 1;
            this.currentFrame = this.frames.get(ind % this.frames.size());
        }
    }

    public boolean isCustom() {
        return this.type == AnimationType.GESTURE || this.pose instanceof CustomPose;
    }

    public void clearCache() {
        this.components = null;
        this.psfs = null;
    }

    public void moveFrame(int i) {
        if (this.currentFrame == null || this.frames.size() < 2) {
            return;
        }
        int ind = this.frames.indexOf(this.currentFrame);
        if (ind == -1) {
            return;
        }
        int newInd = ind + i;
        if (newInd < 0 || newInd > this.frames.size()) {
            return;
        }
        ActionBuilder ab = this.editor.action("move", "action.cpm.animFrame");
        HashMap<AnimFrame, Float> map = new HashMap<AnimFrame, Float>();
        for (int j = 0; j < this.frames.size(); ++j) {
            map.put(this.frames.get(j), Float.valueOf(j));
        }
        ab.addToMap(map, this.currentFrame, Float.valueOf((float)newInd + 0.1f * (float)i));
        ab.onAction(() -> this.frames.sort(Comparator.comparing(map::get)));
        ab.onAction(this::clearCache);
        ab.execute();
    }
}

