/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimatedTexture;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.model.TextureSheetType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public class AnimatedTex
implements TreeElement {
    private final Editor editor;
    private List<TreeElement> options;
    public Vec2i uvStart;
    public Vec2i uvSize;
    public Vec2i animStart;
    public int frameTime;
    public int frameCount;
    public boolean anX;
    public boolean interpolate;
    private final TextureSheetType sheet;
    private int lastFrame;
    private long lastUpdate;

    public AnimatedTex(Editor editor, TextureSheetType sheet, JsonMap map) {
        this(editor, sheet);
        this.frameTime = map.getInt("frameTime", 0);
        this.frameCount = map.getInt("frameCount", 0);
        this.uvStart = map.getObject("start", Vec2i::new, new Vec2i());
        this.uvSize = map.getObject("size", Vec2i::new, new Vec2i());
        this.animStart = map.getObject("from", Vec2i::new, new Vec2i());
        this.anX = map.getBoolean("anX");
        this.interpolate = map.getBoolean("interpolate");
    }

    public AnimatedTex(Editor editor, TextureSheetType sheet) {
        this.editor = editor;
        this.sheet = sheet;
        this.uvStart = new Vec2i();
        this.uvSize = new Vec2i();
        this.animStart = new Vec2i();
        this.options = new ArrayList<TreeElement>();
        this.options.add(new TexElem("start", this.uvStart));
        this.options.add(new TexElem("size", this.uvSize));
        this.options.add(new TexElem("from", this.animStart));
        this.options.add(new ValElem("frameTime", () -> this.frameTime, v -> {
            this.frameTime = v;
        }));
        this.options.add(new ValElem("frameCount", () -> this.frameCount, v -> {
            this.frameCount = v;
        }));
        this.options.add(new BoolElem("anX", () -> this.anX, v -> {
            this.anX = v;
        }));
        this.options.add(new BoolElem("interpolate", () -> this.interpolate, v -> {
            this.interpolate = v;
        }));
    }

    public void save(JsonMap map) {
        map.put("frameTime", this.frameTime);
        map.put("frameCount", this.frameCount);
        map.put("start", this.uvStart.toMap());
        map.put("size", this.uvSize.toMap());
        map.put("from", this.animStart.toMap());
        map.put("anX", this.anX);
        map.put("interpolate", this.interpolate);
    }

    public boolean apply(Image ri, Image img) {
        if (this.frameCount == 0 || this.frameTime == 0) {
            return false;
        }
        long time = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
        int frm = (int)(time / (long)this.frameTime % (long)this.frameCount);
        if (this.interpolate) {
            if (time - this.lastUpdate > 50L) {
                float t = (float)frm + (float)(time % (long)this.frameTime) / (float)this.frameTime;
                int uvx = this.uvStart.x;
                int uvy = this.uvStart.y;
                int sx = this.uvSize.x;
                int sy = this.uvSize.y;
                int ax = this.animStart.x;
                int ay = this.animStart.y;
                AnimatedTexture.copyTextureInt(ri, img, uvx, uvy, sx, sy, ax, ay, t, this.anX, this.frameCount);
                return true;
            }
        } else if (frm != this.lastFrame) {
            this.lastFrame = frm;
            int uvx = this.uvStart.x;
            int uvy = this.uvStart.y;
            int sx = this.uvSize.x;
            int sy = this.uvSize.y;
            int ax = this.animStart.x;
            int ay = this.animStart.y;
            AnimatedTexture.copyTexture(ri, img, uvx, uvy, sx, sy, ax, ay, frm, this.anX);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.editor.gui().i18nFormat("label.cpm.tree.animatedRegion", new Object[0]);
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        this.options.forEach(c);
    }

    @Override
    public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
        gui.drawBox((float)x + (float)this.uvStart.x * xs, (float)y + (float)this.uvStart.y * ys, (float)this.uvSize.x * xs, (float)this.uvSize.y * ys, -2130706688);
        gui.drawBox((float)x + (float)this.animStart.x * xs, (float)y + (float)this.animStart.y * ys, (float)this.uvSize.x * xs, (float)this.uvSize.y * ys, -2130706433);
        if (this.anX) {
            gui.drawBox((float)x + (float)(this.animStart.x + this.uvSize.x) * xs, (float)y + (float)this.animStart.y * ys, (float)(this.uvSize.x * (this.frameCount - 1)) * xs, (float)this.uvSize.y * ys, -2136298838);
        } else {
            gui.drawBox((float)x + (float)this.animStart.x * xs, (float)y + (float)(this.animStart.y + this.uvSize.y) * ys, (float)this.uvSize.x * xs, (float)(this.uvSize.y * (this.frameCount - 1)) * ys, -2136298838);
        }
    }

    @Override
    public ETextures getTexture() {
        ETextures tex = this.editor.textures.get((Object)this.sheet);
        if (tex != null) {
            return tex;
        }
        return this.editor.textures.get((Object)TextureSheetType.SKIN);
    }

    @Override
    public void delete() {
        ETextures tex = this.editor.textures.get((Object)this.sheet);
        this.editor.action("remove", "action.cpm.animTex").removeFromList(tex.animatedTexs, this).onRun(() -> {
            this.editor.selectedElement = null;
            tex.refreshTexture();
        }).execute();
        this.editor.updateGui();
    }

    @Override
    public void updateGui() {
        this.editor.setDelEn.accept(true);
    }

    private class BoolElem
    extends OptionElem {
        private BooleanSupplier get;
        private Consumer<Boolean> set;

        public BoolElem(String name, BooleanSupplier get, Consumer<Boolean> set) {
            super(name);
            this.get = get;
            this.set = set;
        }

        @Override
        public void updateGui() {
            ((AnimatedTex)AnimatedTex.this).editor.setModeBtn.accept(AnimatedTex.this.editor.gui().i18nFormat("button.cpm.at." + this.name + "." + (this.get.getAsBoolean() ? "on" : "off"), new Object[0]));
        }

        @Override
        public void modeSwitch() {
            AnimatedTex.this.editor.action("set", "label.cpm.tree.at." + this.name).updateValueOp(this.set, this.get.getAsBoolean(), !this.get.getAsBoolean(), Consumer::accept).execute();
            this.updateGui();
        }
    }

    private class ValElem
    extends OptionElem {
        private IntSupplier get;
        private IntConsumer set;

        public ValElem(String name, IntSupplier get, IntConsumer set) {
            super(name);
            this.get = get;
            this.set = set;
        }

        @Override
        public void updateGui() {
            ((AnimatedTex)AnimatedTex.this).editor.setModePanel.accept(PosPanel.ModeDisplayType.VALUE);
            ((AnimatedTex)AnimatedTex.this).editor.setValue.accept(Float.valueOf(this.get.getAsInt()));
        }

        @Override
        public void setValue(float value) {
            this.set.accept((int)value);
            AnimatedTex.this.editor.action("set", "label.cpm.tree.at." + this.name).updateValueOp(this.set, this.get.getAsInt(), (int)value, IntConsumer::accept).execute();
        }
    }

    private class TexElem
    extends OptionElem {
        private Vec2i vec;

        public TexElem(String name, Vec2i vec) {
            super(name);
            this.vec = vec;
        }

        @Override
        public void updateGui() {
            ((AnimatedTex)AnimatedTex.this).editor.setModePanel.accept(PosPanel.ModeDisplayType.TEX);
            ((AnimatedTex)AnimatedTex.this).editor.setTexturePanel.accept(new Vec3i(this.vec.x, this.vec.y, 0));
        }

        @Override
        public void setVec(Vec3f v, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                this.vec.x = (int)v.x;
                this.vec.y = (int)v.y;
                AnimatedTex.this.editor.action("set", "label.cpm.tree.at." + this.name).updateValueOp(this.vec, this.vec.x, (int)v.x, (a, b) -> {
                    a.x = b;
                }).updateValueOp(this.vec, this.vec.y, (int)v.y, (a, b) -> {
                    a.y = b;
                }).execute();
            }
        }
    }

    private class OptionElem
    implements TreeElement {
        protected String name;
        private Tooltip tooltip;

        public OptionElem(String name) {
            this.name = name;
            this.tooltip = new Tooltip(((AnimatedTex)AnimatedTex.this).editor.frame, AnimatedTex.this.editor.gui().i18nFormat("tooltip.cpm.tree.at." + name, new Object[0]));
        }

        @Override
        public String getName() {
            return AnimatedTex.this.editor.gui().i18nFormat("label.cpm.tree.at." + this.name, new Object[0]);
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            AnimatedTex.this.drawTexture(gui, x, y, xs, ys);
        }

        @Override
        public ETextures getTexture() {
            return AnimatedTex.this.getTexture();
        }

        @Override
        public Tooltip getTooltip() {
            return this.tooltip;
        }
    }
}

