/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.RootGroups;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.actions.ImageAction;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.PlayerPartValues;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ItemRenderer;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Generators {
    public static List<Generators> generators = new ArrayList<Generators>();
    public String name;
    public String tooltip;
    public Consumer<EditorGui> func;

    public Generators(String name, String tooltip, Consumer<EditorGui> func) {
        this.name = name;
        this.tooltip = tooltip;
        this.func = func;
    }

    private static void addSkinLayer(Editor e) {
        ActionBuilder ab = e.action("i", "button.cpm.tools.add_skin_layer2");
        ab.onUndo(() -> {
            e.selectedElement = null;
        });
        block0: for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : e.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p) continue;
                ModelElement elem = new ModelElement(e);
                ab.addToList(el.children, elem);
                elem.parent = el;
                PlayerPartValues val = PlayerPartValues.getFor(p, e.skinType);
                elem.size = val.getSize();
                elem.offset = val.getOffset();
                elem.texture = true;
                elem.u = val.u2;
                elem.v = val.v2;
                elem.name = e.frame.getGui().i18nFormat("label.cpm.layer_" + val.layer.getLowerName(), new Object[0]);
                elem.mcScale = 0.25f;
                continue block0;
            }
        }
        ab.execute();
        e.updateGui();
    }

    public static void convertModel(Editor e) {
        ActionBuilder ab = e.action("i", "button.cpm.tools.convert_model_custom");
        ab.onUndo(() -> {
            e.selectedElement = null;
        });
        for (ModelElement el : e.elements) {
            if (el.type != ElementType.ROOT_PART || el.hidden) continue;
            ModelElement elem = new ModelElement(e);
            ab.addToList(el.children, elem);
            elem.parent = el;
            PartValues val = ((VanillaModelPart)el.typeData).getDefaultSize(e.skinType);
            elem.size = val.getSize();
            elem.offset = val.getOffset();
            elem.texture = true;
            elem.mcScale = val.getMCScale();
            elem.mirror = val.isMirror();
            Vec2i uv = val.getUV();
            elem.u = uv.x;
            elem.v = uv.y;
            elem.name = el.name;
            elem.generated = true;
            ab.updateValueOp(el, false, true, (a, b) -> {
                a.hidden = b;
            });
        }
        ab.execute();
        e.updateGui();
    }

    public static void setupTemplateModel(Editor e) {
        ActionBuilder ab = e.action("i", "button.cpm.tools.convert2template");
        ab.onUndo(() -> {
            e.selectedElement = null;
        });
        block0: for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : e.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p) continue;
                if (el.hidden) continue block0;
                ModelElement elem = new ModelElement(e);
                ab.addToList(el.children, elem);
                elem.parent = el;
                PlayerPartValues val = PlayerPartValues.getFor(p, e.skinType);
                elem.size = val.getSize();
                elem.offset = val.getOffset();
                elem.texture = false;
                elem.rgb = 0xFFFFFF;
                elem.name = el.name;
                elem.templateElement = true;
                ab.updateValueOp(el, false, true, (a, b) -> {
                    a.hidden = b;
                });
                continue block0;
            }
        }
        ab.execute();
    }

    private static void convertTemplate(EditorGui eg) {
        Editor editor = eg.getEditor();
        IGui gui = eg.getGui();
        if (editor.templateSettings == null) {
            if (editor.dirty) {
                eg.openPopup(new MessagePopup(eg, gui.i18nFormat("label.cpm.info", new Object[0]), gui.i18nFormat("label.cpm.must_save", new Object[0])));
            } else if (editor.file == null) {
                Generators.setupTemplate(editor);
            } else {
                eg.openPopup(new ConfirmPopup(eg, gui.i18nFormat("label.cpm.warning", new Object[0]), gui.i18nFormat("label.cpm.warn_c2t", new Object[0]), () -> Generators.setupTemplate(editor), null));
            }
        }
    }

    private static void setupTemplate(Editor editor) {
        editor.templateSettings = new TemplateSettings(editor);
        Generators.setupTemplateModel(editor);
        editor.markDirty();
        editor.updateGui();
    }

    private static void fillUV(EditorGui eg) {
        Editor editor = eg.getEditor();
        ModelElement me = editor.getSelectedElement();
        if (me != null && me.type == ElementType.NORMAL && me.texture) {
            Box box = me.getTextureBox();
            int ts = Math.abs(me.texSize);
            int bx = me.u * ts;
            int by = me.v * ts;
            int dx = MathHelper.ceil(me.size.x * (float)ts);
            int dy = MathHelper.ceil(me.size.y * (float)ts);
            int dz = MathHelper.ceil(me.size.z * (float)ts);
            editor.action("i", "button.cpm.tools.fillUV").action(new ImageAction(me.getTexture().getImage(), box, img -> {
                img.fill(bx + dx + dz, by + dz, dz, dy, -65536);
                img.fill(bx, by + dz, dz, dy, -2293760);
                img.fill(bx + dz, by, dx, dz, -16711936);
                img.fill(bx + dz + dx, by, dx, dz, -16720640);
                img.fill(bx + dz, by + dz, dx, dy, -16776961);
                img.fill(bx + dz * 2 + dx, by + dz, dx, dy, -16776995);
            })).onAction(me.getTexture()::markDirty).execute();
        }
    }

    public static void addItemHoldPos(Editor editor) {
        ActionBuilder ab = editor.action("add", "action.cpm.itemHold");
        HashSet added = new HashSet();
        Editor.walkElements(editor.elements, e -> {
            if (e.itemRenderer != null) {
                added.add(e.itemRenderer.slot);
            }
        });
        for (ItemSlot itemSlot : ItemSlot.SLOTS) {
            if (added.contains((Object)itemSlot)) continue;
            ModelElement elem = new ModelElement(editor);
            elem.itemRenderer = new ItemRenderer(itemSlot, 0);
            elem.name = editor.gui().i18nFormat("label.cpm.elem.item." + itemSlot.name().toLowerCase(), new Object[0]);
            elem.size = new Vec3f(0.0f, 0.0f, 0.0f);
            switch (itemSlot) {
                case HEAD: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.HEAD);
                    break;
                }
                case LEFT_HAND: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.LEFT_ARM);
                    break;
                }
                case RIGHT_HAND: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.RIGHT_ARM);
                    break;
                }
            }
            if (elem.parent == null) continue;
            ab.addToList(elem.parent.children, elem);
        }
        ab.execute();
        editor.updateGui();
    }

    private static ModelElement findPart(Editor editor, VanillaModelPart part) {
        for (ModelElement e : editor.elements) {
            if (e.typeData != part) continue;
            return e;
        }
        return null;
    }

    public static void loadTextures(Editor editor, RootGroups group, BiConsumer<TextureSheetType, ETextures> texs) {
        Arrays.stream(group.types).map(group::getTexSheet).distinct().forEach(tx -> {
            if (!editor.textures.containsKey(tx)) {
                ETextures tex = new ETextures(editor, (TextureSheetType)((Object)tx));
                texs.accept((TextureSheetType)((Object)tx), tex);
                tex.provider.size = tx.getDefSize();
                Image def = new Image(tex.provider.size.x, tex.provider.size.y);
                try (InputStream is2 = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/" + tx.name().toLowerCase() + ".png");){
                    def = Image.loadFrom(is2);
                }
                catch (IOException is2) {
                    // empty catch block
                }
                tex.setDefaultImg(def);
                tex.setImage(new Image(def));
                tex.markDirty();
                tex.setEdited(tx.texType == null && tx.editable);
                if (tx.texType != null) {
                    Player<?, ?> profile = MinecraftClientAccess.get().getClientPlayer();
                    profile.getTextures().load().thenRun(() -> Generators.loadTexture(tex, profile, tx.texType));
                }
            }
        });
    }

    private static void loadTexture(ETextures tex, Player<?, ?> profile, TextureType type) {
        CompletableFuture<Image> img = profile.getTextures().getTexture(type);
        img.thenAccept(s -> {
            if (!tex.isEdited()) {
                if (s != null) {
                    tex.setDefaultImg((Image)s);
                    tex.setImage(new Image((Image)s));
                    tex.restitchTexture();
                } else if (type == TextureType.ELYTRA) {
                    Generators.loadTexture(tex, profile, TextureType.CAPE);
                }
            }
        });
    }

    static {
        generators.add(new Generators("button.cpm.tools.convert_model_custom", "tooltip.cpm.tools.convert_model_custom", eg -> Generators.convertModel(eg.getEditor())));
        generators.add(new Generators("button.cpm.tools.add_skin_layer2", null, eg -> Generators.addSkinLayer(eg.getEditor())));
        generators.add(new Generators("button.cpm.tools.convert2template", null, Generators::convertTemplate));
        generators.add(new Generators("button.cpm.tools.fillUV", null, Generators::fillUV));
    }
}

