/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.CreateGistPopup;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.effects.EffectColor;
import com.tom.cpm.shared.effects.EffectGlow;
import com.tom.cpm.shared.effects.EffectHide;
import com.tom.cpm.shared.effects.EffectHideSkull;
import com.tom.cpm.shared.effects.EffectPerFaceUV;
import com.tom.cpm.shared.effects.EffectRemoveArmorOffset;
import com.tom.cpm.shared.effects.EffectRenderItem;
import com.tom.cpm.shared.effects.EffectScale;
import com.tom.cpm.shared.effects.EffectSingleTexture;
import com.tom.cpm.shared.effects.EffectUV;
import com.tom.cpm.shared.io.ChecksumOutputStream;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.io.SkinDataOutputStream;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.ModelPartAnimatedTexture;
import com.tom.cpm.shared.parts.ModelPartAnimation;
import com.tom.cpm.shared.parts.ModelPartCloneable;
import com.tom.cpm.shared.parts.ModelPartDefinition;
import com.tom.cpm.shared.parts.ModelPartDefinitionLink;
import com.tom.cpm.shared.parts.ModelPartDupRoot;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartPlayer;
import com.tom.cpm.shared.parts.ModelPartPlayerPos;
import com.tom.cpm.shared.parts.ModelPartRenderEffect;
import com.tom.cpm.shared.parts.ModelPartRoot;
import com.tom.cpm.shared.parts.ModelPartScale;
import com.tom.cpm.shared.parts.ModelPartSkin;
import com.tom.cpm.shared.parts.ModelPartSkinType;
import com.tom.cpm.shared.parts.ModelPartTemplate;
import com.tom.cpm.shared.parts.ModelPartTexture;
import com.tom.cpm.shared.parts.ModelPartUUIDLockout;
import com.tom.cpm.shared.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Exporter {
    public static final String TEMP_MODEL = ".temp.cpmmodel";
    public static final Gson sgson = new GsonBuilder().serializeSpecialFloatingPointValues().create();

    public static void exportSkin(Editor e, EditorGui gui, File f, boolean forceOut) {
        if (e.vanillaSkin == null) {
            gui.openPopup(new MessagePopup(gui, "Unknown Error", "Couldn't load vanilla skin"));
            return;
        }
        if (e.vanillaSkin.getWidth() != 64 || e.vanillaSkin.getHeight() != 64) {
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("error.cpm.vanillaSkinSize", new Object[0])));
            return;
        }
        Image img = new Image(e.vanillaSkin);
        Exporter.exportSkin0(e, gui, new Result(() -> new SkinDataOutputStream(img, MinecraftClientAccess.get().getDefinitionLoader().getTemplate(), e.skinType.getChannel()), () -> {
            img.storeTo(f);
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.export_success", new Object[0]), gui.getGui().i18nFormat("label.cpm.export_success.desc", f.getName())));
        }, (d, c) -> Exporter.handleGistOverflow(d, c, gui)), forceOut);
    }

    public static void exportSkin(Editor e, EditorGui gui, Consumer<Image> out, boolean forceOut) {
        if (e.vanillaSkin == null) {
            gui.openPopup(new MessagePopup(gui, "Unknown Error", "Couldn't load vanilla skin"));
            return;
        }
        if (e.vanillaSkin.getWidth() != 64 || e.vanillaSkin.getHeight() != 64) {
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("error.cpm.vanillaSkinSize", new Object[0])));
            return;
        }
        Image img = new Image(e.vanillaSkin);
        Exporter.exportSkin0(e, gui, new Result(() -> new SkinDataOutputStream(img, MinecraftClientAccess.get().getDefinitionLoader().getTemplate(), e.skinType.getChannel()), () -> out.accept(img), (d, c) -> Exporter.handleGistOverflow(d, c, gui)), forceOut);
    }

    public static void exportB64(Editor e, EditorGui gui, Consumer<String> b64Out, boolean forceOut) {
        byte[] buffer = new byte[200];
        int[] size = new int[]{0};
        Exporter.exportSkin0(e, gui, new Result(() -> {
            size[0] = 0;
            return new BAOS(buffer, size);
        }, () -> b64Out.accept(Base64.getEncoder().encodeToString(Arrays.copyOf(buffer, size[0]))), (d, c) -> Exporter.handleGistOverflow(d, c, gui)), forceOut);
    }

    public static void exportGistUpdate(Editor e, EditorGui gui, Consumer<String> b64Out) {
        try {
            ModelPartDefinition def = Exporter.prepareDefinition(e);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(83);
            ChecksumOutputStream cos = new ChecksumOutputStream(baos);
            def.write(new IOHelper(cos));
            cos.close();
            String b64 = Base64.getEncoder().encodeToString(baos.toByteArray());
            Log.info(b64);
            b64Out.accept(b64);
        }
        catch (ExportException ex) {
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("label.cpm.export_error", gui.getGui().i18nFormat(ex.getMessage(), new Object[0]))));
        }
        catch (Exception ex) {
            gui.getGui().onGuiException("Error while exporting", ex, false);
        }
    }

    public static void exportModel(Editor e, EditorGui gui, File f, ModelDescription desc, boolean skinCompat) {
        ModelWriter wr = new ModelWriter(gui, f, skinCompat);
        wr.setDesc(desc.name, desc.desc, desc.icon);
        Exporter.exportSkin0(e, gui, new Result(wr::getOut, () -> {
            if (wr.finish()) {
                gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.export_success", new Object[0]), gui.getGui().i18nFormat("label.cpm.export_success.desc", f.getName())));
            }
        }, (d, c) -> Exporter.handleGistOverflow(d, l -> {
            wr.setOverflow((byte[])d, (Link)l);
            c.accept(l);
        }, gui)), false);
    }

    public static boolean exportTempModel(Editor e, EditorGui gui) {
        File models = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
        models.mkdirs();
        ModelWriter wr = new ModelWriter(gui, new File(models, TEMP_MODEL), false);
        wr.setDesc("Test model", "", null);
        return Exporter.exportSkin0(e, gui, new Result(wr::getOut, wr::finish, (d, c) -> {
            Link l = new Link("local:test");
            wr.setOverflow((byte[])d, l);
            c.accept(l);
        }), false);
    }

    private static ModelPartDefinition prepareDefinition(Editor e) throws IOException {
        ArrayList<Cube> flatList = new ArrayList<Cube>();
        Exporter.walkElements(e.elements, new int[]{10}, flatList);
        ModelPartDefinition def = new ModelPartDefinition(e.textures.get((Object)TextureSheetType.SKIN).isEdited() ? new ModelPartSkin(e) : null, flatList);
        ModelPartPlayer player = new ModelPartPlayer(e);
        def.setPlayer(player);
        ArrayList<IModelPart> otherParts = new ArrayList<IModelPart>();
        for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el2 : e.elements) {
                if (el2.type != ElementType.ROOT_PART || el2.typeData != p || el2.duplicated || !(Math.abs(el2.pos.x) >= 0.1f || Math.abs(el2.pos.y) >= 0.1f || Math.abs(el2.pos.z) >= 0.1f || Math.abs(el2.rotation.x) >= 0.1f || Math.abs(el2.rotation.y) >= 0.1f) && !(Math.abs(el2.rotation.z) >= 0.1f)) continue;
                otherParts.add(new ModelPartPlayerPos(p.getId(el2.rc), el2.pos, el2.rotation));
            }
        }
        Exporter.walkElements(e.elements, el -> {
            if (el.type == ElementType.NORMAL) {
                if (el.glow) {
                    otherParts.add(new ModelPartRenderEffect(new EffectGlow(el.id)));
                }
                if (Math.abs(el.mcScale) > 1.0E-4f || Math.abs(el.scale.x - 1.0f) > 0.01f || Math.abs(el.scale.y - 1.0f) > 0.01f || Math.abs(el.scale.z - 1.0f) > 0.01f) {
                    otherParts.add(new ModelPartRenderEffect(new EffectScale(el.id, el.scale, el.mcScale)));
                }
                if (el.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el.id)));
                }
                if (el.recolor) {
                    otherParts.add(new ModelPartRenderEffect(new EffectColor(el.id, el.rgb)));
                }
                if (el.singleTex) {
                    otherParts.add(new ModelPartRenderEffect(new EffectSingleTexture(el.id)));
                }
                if (el.faceUV != null) {
                    otherParts.add(new ModelPartRenderEffect(new EffectPerFaceUV(el.id, el.faceUV)));
                } else if (el.u > 255 || el.v > 255) {
                    otherParts.add(new ModelPartRenderEffect(new EffectUV(el.id, el.u, el.v)));
                }
                if (el.itemRenderer != null) {
                    otherParts.add(new ModelPartRenderEffect(new EffectRenderItem(el.id, el.itemRenderer.slot, el.itemRenderer.slotID)));
                }
            }
        });
        for (ModelElement el3 : e.elements) {
            if (el3.type != ElementType.ROOT_PART) continue;
            if (el3.duplicated && el3.typeData instanceof PlayerModelParts) {
                if (el3.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el3.id)));
                }
                otherParts.add(new ModelPartDupRoot(el3.id, (PlayerModelParts)el3.typeData));
                continue;
            }
            if (!(el3.typeData instanceof RootModelType)) continue;
            if (el3.hidden) {
                otherParts.add(new ModelPartRenderEffect(new EffectHide(el3.id)));
            }
            otherParts.add(new ModelPartRoot(el3.id, (RootModelType)el3.typeData));
        }
        if (!e.animations.isEmpty()) {
            otherParts.add(new ModelPartAnimation(e));
        }
        e.textures.forEach((type, tex) -> {
            if (type != TextureSheetType.SKIN) {
                otherParts.add(new ModelPartTexture(e, (TextureSheetType)((Object)type)));
            }
            if (!tex.animatedTexs.isEmpty() && type.editable) {
                tex.animatedTexs.forEach(at -> otherParts.add(new ModelPartAnimatedTexture((TextureSheetType)((Object)type), (AnimatedTex)at)));
            }
        });
        for (EditorTemplate et : e.templates) {
            otherParts.add(new ModelPartTemplate(et));
        }
        if (e.scaling != 0.0f && e.scaling != 1.0f) {
            otherParts.add(new ModelPartScale(e.scaling));
        }
        if (!e.hideHeadIfSkull) {
            otherParts.add(new ModelPartRenderEffect(new EffectHideSkull(e.hideHeadIfSkull)));
        }
        if (e.removeArmorOffset) {
            otherParts.add(new ModelPartRenderEffect(new EffectRemoveArmorOffset(e.removeArmorOffset)));
        }
        if (e.description != null) {
            switch (e.description.copyProtection) {
                case CLONEABLE: {
                    otherParts.add(new ModelPartCloneable(e.description.name, e.description.desc, e.description.icon));
                    break;
                }
                case NORMAL: {
                    break;
                }
                case UUID_LOCK: {
                    otherParts.add(new ModelPartUUIDLockout(e.description.uuid != null ? e.description.uuid : MinecraftClientAccess.get().getClientPlayer().getUUID()));
                    break;
                }
            }
        }
        def.setOtherParts(otherParts);
        if (MinecraftObjectHolder.DEBUGGING) {
            Log.info(def);
        }
        return def;
    }

    private static boolean exportSkin0(Editor e, EditorGui gui, Result result, boolean forceOut) {
        try {
            ModelPartDefinition def = Exporter.prepareDefinition(e);
            if (forceOut) {
                Exporter.writeOut(e, gui, def, result);
                return true;
            }
            try (OutputStream out = result.get();){
                out.write(83);
                ChecksumOutputStream cos = new ChecksumOutputStream(out);
                try (IOHelper dout = new IOHelper(cos);){
                    dout.writeObjectBlock(new ModelPartSkinType(e.skinType));
                    dout.writeObjectBlock(def);
                    dout.writeObjectBlock(ModelPartEnd.END);
                }
            }
            catch (EOFException unusedException) {
                Exporter.writeOut(e, gui, def, result);
                return true;
            }
            catch (IOException e1) {
                throw new ExportException("error.cpm.unknownError", e1);
            }
            result.close();
            return true;
        }
        catch (ExportException ex) {
            Log.error("Export exception", ex);
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("label.cpm.export_error", gui.getGui().i18nFormat(ex.getMessage(), new Object[0]))));
            return false;
        }
        catch (Exception ex) {
            gui.getGui().onGuiException("Error while exporting", ex, false);
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("label.cpm.unknownError", new Object[0])));
            return false;
        }
    }

    private static void writeOut(Editor e, EditorGui gui, ModelPartDefinition def, Result result) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(83);
        ChecksumOutputStream cos = new ChecksumOutputStream(baos);
        def.write(new IOHelper(cos));
        cos.close();
        result.overflowWriter.accept(baos.toByteArray(), link -> {
            try {
                ModelPartDefinitionLink defLink = new ModelPartDefinitionLink((Link)link);
                try (OutputStream out = result.get();){
                    out.write(83);
                    ChecksumOutputStream cos = new ChecksumOutputStream(out);
                    try (IOHelper dout = new IOHelper(cos);){
                        dout.writeObjectBlock(new ModelPartSkinType(e.skinType));
                        dout.writeObjectBlock(defLink);
                        dout.writeObjectBlock(ModelPartEnd.END);
                    }
                }
                result.close();
            }
            catch (ExportException ex) {
                gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("label.cpm.export_error", ex.getMessage())));
            }
            catch (Exception ex) {
                gui.getGui().onGuiException("Error while exporting", ex, false);
            }
        });
    }

    public static void exportTemplate(Editor e, EditorGui gui, ModelDescription desc, Consumer<String> templateOut) {
        try {
            ArrayList<Cube> flatList = new ArrayList<Cube>();
            Exporter.walkElements(e.elements, new int[]{10000}, flatList);
            HashMap<String, Object> data = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> cubesList = new ArrayList<HashMap<String, Object>>();
            data.put("cubes", cubesList);
            HashMap cubeDataList = new HashMap();
            flatList.sort((a, b) -> Integer.compare(a.id, b.id));
            for (Cube cube : flatList) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                Cube.saveDefinitionCube(m, cube);
                cubesList.add(m);
                HashMap dtMap = new HashMap();
                m.put("data", dtMap);
                m.put("id", cube.id);
                cubeDataList.put(cube.id, dtMap);
            }
            Exporter.walkElements(e.elements, el -> {
                if (el.type == ElementType.NORMAL && !el.templateElement) {
                    Map dt = (Map)cubeDataList.get(el.id);
                    dt.put("hidden", el.hidden);
                    dt.put("recolor", el.recolor);
                    dt.put("glow", el.glow);
                }
            });
            ArrayList argsList = new ArrayList();
            data.put("args", argsList);
            for (TemplateArgHandler a2 : e.templateSettings.templateArgs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                argsList.add(map);
                map.put("name", a2.name);
                map.put("desc", a2.desc);
                map.put("type", a2.type.baseType.name().toLowerCase());
                map.put("elem_type", a2.type.name().toLowerCase());
                HashMap<String, Object> d = new HashMap<String, Object>();
                a2.handler.export().export(d);
                map.put("data", d);
                a2.handler.applyArgs(data, a2.effectedElems);
            }
            if (e.textures.get((Object)TextureSheetType.SKIN).isEdited()) {
                IOHelper iOHelper = new IOHelper();
                e.textures.get((Object)TextureSheetType.SKIN).write(iOHelper);
                data.put("texture", iOHelper.toB64());
            }
            data.put("name", desc.name);
            data.put("desc", desc.desc);
            if (desc.icon != null) {
                try (IOHelper iOHelper = new IOHelper();){
                    iOHelper.writeImage(desc.icon);
                    data.put("icon", iOHelper.toB64());
                }
            }
            String string = sgson.toJson(data);
            templateOut.accept(string);
        }
        catch (ExportException ex) {
            gui.openPopup(new MessagePopup(gui, gui.getGui().i18nFormat("label.cpm.error", new Object[0]), gui.getGui().i18nFormat("label.cpm.export_error", gui.getGui().i18nFormat(ex.getMessage(), new Object[0]))));
        }
        catch (Exception ex) {
            gui.getGui().onGuiException("Error while exporting", ex, false);
        }
    }

    private static void walkElements(List<ModelElement> elems, int[] id, List<Cube> flatList) {
        for (ModelElement me : elems) {
            if (me.templateElement) continue;
            switch (me.type) {
                case NORMAL: {
                    id[0] = id[0] + 1;
                    me.id = me.id;
                    flatList.add(me);
                    break;
                }
                case ROOT_PART: {
                    if (me.duplicated || me.typeData instanceof RootModelType) {
                        Cube fake = Cube.newFakeCube();
                        id[0] = id[0] + 1;
                        fake.id = me.id = me.id;
                        fake.pos = me.pos;
                        fake.rotation = me.rotation;
                        flatList.add(fake);
                        break;
                    }
                    me.id = ((RootModelElement)me.rc).getPart().getId(me.rc);
                    break;
                }
            }
            if (me.parent != null) {
                me.parentId = me.parent.id;
            }
            Exporter.walkElements(me.children, id, flatList);
        }
    }

    private static void walkElements(List<ModelElement> elems, Consumer<ModelElement> c) {
        for (ModelElement me : elems) {
            c.accept(me);
            Exporter.walkElements(me.children, c);
        }
    }

    public static boolean check(Editor editor, EditorGui editorGui, Runnable next) {
        if (!editor.animations.isEmpty() && editor.animEnc == null && editor.animations.stream().anyMatch(EditorAnim::isCustom)) {
            editorGui.openPopup(new AnimEncConfigPopup(editorGui.getGui(), editor, next));
            return false;
        }
        return true;
    }

    private static void handleGistOverflow(byte[] data, Consumer<Link> linkC, EditorGui gui) {
        String b64 = Base64.getEncoder().encodeToString(data);
        Log.info(b64);
        gui.openPopup(new CreateGistPopup(gui, gui.getGui(), "skinOverflow", b64, linkC));
    }

    public static void convert(ModelFile file, Image imgIn, SkinType type, Consumer<Image> outCons, Runnable error) {
        Image img = new Image(imgIn);
        try (SkinDataOutputStream out = new SkinDataOutputStream(img, MinecraftClientAccess.get().getDefinitionLoader().getTemplate(), type.getChannel());){
            out.write(file.getDataBlock());
        }
        catch (IOException e) {
            Log.error("Failed to convert model file to skin", e);
            error.run();
            return;
        }
        outCons.accept(img);
    }

    private static class ModelWriter {
        private final EditorGui gui;
        private byte[] buffer;
        private int[] size = new int[]{0};
        private byte[] overflow;
        private File out;
        private String name;
        private String desc;
        private Link l;
        private Image icon;

        public ModelWriter(EditorGui gui, File out, boolean skinCompat) {
            this.gui = gui;
            this.out = out;
            this.buffer = new byte[skinCompat ? 2048 : 32768];
        }

        public void setDesc(String name, String desc, Image icon) {
            this.name = name;
            this.desc = desc;
            this.icon = icon;
        }

        public OutputStream getOut() {
            this.size[0] = 0;
            return new BAOS(this.buffer, this.size);
        }

        public void setOverflow(byte[] d, Link l) {
            this.overflow = d;
            this.l = l;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean finish() {
            try (FileOutputStream fout = new FileOutputStream(this.out);){
                fout.write(83);
                ChecksumOutputStream cos = new ChecksumOutputStream(fout);
                IOHelper h = new IOHelper(cos);
                h.writeUTF(this.name);
                h.writeUTF(this.desc);
                h.writeVarInt(this.size[0]);
                h.write(this.buffer, 0, this.size[0]);
                if (this.overflow != null) {
                    h.writeByteArray(this.overflow);
                    this.l.write(h);
                } else {
                    h.writeVarInt(0);
                }
                if (this.icon != null) {
                    h.writeImage(this.icon);
                } else {
                    h.writeVarInt(0);
                }
                cos.close();
                boolean bl = true;
                return bl;
            }
            catch (ExportException ex) {
                this.gui.openPopup(new MessagePopup(this.gui, this.gui.getGui().i18nFormat("label.cpm.error", new Object[0]), this.gui.getGui().i18nFormat("label.cpm.export_error", this.gui.getGui().i18nFormat(ex.getMessage(), new Object[0]))));
                return false;
            }
            catch (Exception ex) {
                this.gui.getGui().onGuiException("Error while exporting", ex, false);
            }
            return false;
        }
    }

    private static class BAOS
    extends OutputStream {
        private byte[] buffer;
        private int[] size;

        public BAOS(byte[] buffer, int[] size) {
            this.buffer = buffer;
            this.size = size;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer.length <= this.size[0]) {
                throw new EOFException();
            }
            int n = this.size[0];
            this.size[0] = n + 1;
            this.buffer[n] = (byte)b;
        }
    }

    private static class Result
    implements Supplier<OutputStream>,
    Closeable {
        private Supplier<OutputStream> out;
        private Closeable finish;
        private BiConsumer<byte[], Consumer<Link>> overflowWriter;

        public Result(Supplier<OutputStream> out, Closeable finish, BiConsumer<byte[], Consumer<Link>> overflowWriter) {
            this.out = out;
            this.finish = finish;
            this.overflowWriter = overflowWriter;
        }

        @Override
        public OutputStream get() {
            return this.out.get();
        }

        @Override
        public void close() throws IOException {
            this.finish.close();
        }
    }

    public static class ExportException
    extends RuntimeException {
        private static final long serialVersionUID = 3255847899314886673L;

        public ExportException(String message, Throwable cause) {
            super(message, cause);
        }

        public ExportException(String message) {
            super(message);
        }
    }
}

