/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.UpdaterRegistry;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.EditorDefinition;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.EditorTool;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.RootGroups;
import com.tom.cpm.shared.editor.actions.Action;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.anim.AnimationEncodingData;
import com.tom.cpm.shared.editor.anim.AnimationType;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.project.ProjectFile;
import com.tom.cpm.shared.editor.project.ProjectIO;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import com.tom.cpm.shared.editor.tree.ScalingElement;
import com.tom.cpm.shared.editor.tree.TexturesElement;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.editor.util.StoreIDGen;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.PlayerPartValues;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.PerFaceUV;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.PlayerModelLayer;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Editor {
    public UpdaterRegistry updaterReg = new UpdaterRegistry();
    public UpdaterRegistry.Updater<Vec3f> setOffset = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3f> setRot = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3f> setPosition = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3f> setSize = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3f> setScale = this.updaterReg.create();
    public UpdaterRegistry.Updater<Float> setMCScale = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setMirror = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> updateName = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setModeBtn = this.updaterReg.create();
    public UpdaterRegistry.Updater<PosPanel.ModeDisplayType> setModePanel = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3i> setTexturePanel = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setVis = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setDelEn = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAddEn = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setNameDisplay = this.updaterReg.create();
    public UpdaterRegistry.Updater<Void> updateGui = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setUndo = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setRedo = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setGlow = this.updaterReg.create();
    public UpdaterRegistry.Updater<Integer> setPenColor = this.updaterReg.create();
    public UpdaterRegistry.Updater<Integer> setPartColor = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setReColor = this.updaterReg.create();
    public UpdaterRegistry.Updater<Integer> setAnimFrame = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3f> setAnimPos = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec3f> setAnimRot = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setFrameAddEn = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAnimDelEn = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setFrameDelEn = this.updaterReg.create();
    public UpdaterRegistry.Updater<Integer> setAnimDuration = this.updaterReg.create();
    public UpdaterRegistry.Updater<Integer> setAnimColor = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAnimShow = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAnimPlayEn = this.updaterReg.create();
    public UpdaterRegistry.Updater<EditorAnim> setSelAnim = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setHiddenEffect = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setSingleTex = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setPerFaceUV = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setSkinEdited = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setReload = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAnimPlay = this.updaterReg.create();
    public UpdaterRegistry.Updater<Integer> setAnimPriority = this.updaterReg.create();
    public UpdaterRegistry.Updater<Void> gestureFinished = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> displayViewport = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> heldRenderEnable = this.updaterReg.create();
    public UpdaterRegistry.Updater<Float> setValue = this.updaterReg.create();
    public UpdaterRegistry.Updater<EditorTool> setTool = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec4f> setFaceUVs = this.updaterReg.create();
    public UpdaterRegistry.Updater<PerFaceUV.Rot> setFaceRot = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAutoUV = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setEnAddAnimTex = this.updaterReg.create();
    public UpdaterRegistry.Updater<Pair<Integer, String>> setInfoMsg = this.updaterReg.create();
    public Supplier<Vec2i> cursorPos;
    public int penColor = 0xFFFFFF;
    public EditorTool drawMode = EditorTool.PEN;
    public int brushSize = 1;
    public boolean drawAllUVs = false;
    public boolean onlyDrawOnSelected = true;
    public boolean playVanillaAnims = true;
    public boolean playAnimatedTex = true;
    public EnumMap<ItemSlot, DisplayItem> handDisplay = new EnumMap(ItemSlot.class);
    public Set<PlayerModelLayer> modelDisplayLayers = new HashSet<PlayerModelLayer>();
    public ScalingElement scalingElem = new ScalingElement(this);
    public PerFaceUV.Dir perfaceFaceDir = PerFaceUV.Dir.UP;
    public ViewportCamera camera = new ViewportCamera();
    private Stack<Action> undoQueue = new Stack();
    private Stack<Action> redoQueue = new Stack();
    public boolean renderPaint;
    public boolean renderBase = true;
    public boolean applyAnim;
    public boolean playFullAnim;
    public boolean playerTpose;
    public boolean applyScaling;
    public long playStartTime;
    public long gestureStartTime;
    public StoreIDGen storeIDgen;
    public AnimationEncodingData animEnc;
    public Frame frame;
    public TreeElement selectedElement;
    public List<ModelElement> elements = new ArrayList<ModelElement>();
    public EditorAnim selectedAnim;
    public List<EditorAnim> animsToPlay = new ArrayList<EditorAnim>();
    public IPose poseToApply;
    public List<EditorAnim> animations = new ArrayList<EditorAnim>();
    public List<EditorTemplate> templates = new ArrayList<EditorTemplate>();
    public TemplateSettings templateSettings;
    public TexturesElement texElem = new TexturesElement(this);
    public SkinType skinType;
    public boolean customSkinType;
    public ModelDescription description;
    public float scaling;
    public boolean hideHeadIfSkull;
    public boolean removeArmorOffset;
    public Image vanillaSkin;
    public boolean dirty;
    public boolean autoSaveDirty;
    public long lastEdit;
    public ModelDefinition definition;
    public Map<TextureSheetType, ETextures> textures = new HashMap<TextureSheetType, ETextures>();
    public File file;
    public ProjectFile project = new ProjectFile();

    public Editor() {
        this.definition = new EditorDefinition(this);
        this.textures.put(TextureSheetType.SKIN, new ETextures(this, TextureSheetType.SKIN, stitcher -> this.templates.forEach(e -> e.stitch((TextureStitcher)stitcher))));
    }

    public void setGui(EditorGui gui) {
        this.frame = gui;
    }

    public void setVec(Vec3f v, TreeElement.VecType object) {
        if (this.selectedElement != null) {
            this.selectedElement.setVec(v, object);
        }
    }

    public void setValue(float value) {
        if (this.selectedElement != null) {
            this.action("set", "action.cpm.value").updateValueOp(this.selectedElement, Float.valueOf(this.selectedElement.getValue()), Float.valueOf(value), TreeElement::setValue).execute();
        }
    }

    public void setName(String name) {
        if (this.selectedElement != null) {
            this.action("set", "label.cpm.name").updateValueOp(this.selectedElement, this.selectedElement.getElemName(), name, TreeElement::setElemName).execute();
        }
    }

    public void switchMode() {
        if (this.selectedElement != null) {
            this.selectedElement.modeSwitch();
        }
    }

    public void setColor(int color) {
        this.updateValue(color, TreeElement::setElemColor);
    }

    public void setMcScale(float value) {
        this.updateValue(Float.valueOf(value), TreeElement::setMCScale);
    }

    public void addNew() {
        if (this.selectedElement != null) {
            this.selectedElement.addNew();
        }
    }

    public void deleteSel() {
        if (this.selectedElement != null) {
            this.selectedElement.delete();
        }
    }

    public void switchVis() {
        if (this.selectedElement != null) {
            this.selectedElement.switchVis();
        }
    }

    public void switchMirror() {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(Effect.MIRROR);
        }
    }

    public void switchGlow() {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(Effect.GLOW);
        }
    }

    public void switchSingleTex() {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(Effect.SINGLE_TEX);
        }
    }

    public void switchPerfaceUV() {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(Effect.PER_FACE_UV);
        }
    }

    public void switchHide() {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(Effect.HIDE);
        }
    }

    public void setTexSize(int x, int y) {
        ETextures texs = this.getTextureProvider();
        if (texs != null) {
            EditorTexture tex = texs.provider;
            this.action("set", "action.cpm.texSize").updateValueOp(tex, tex.size.x, x, (a, b) -> {
                a.size.x = b;
            }).updateValueOp(tex, tex.size.y, y, (a, b) -> {
                a.size.y = b;
            }).onRun(texs::restitchTexture).execute();
        }
    }

    public void switchReColorEffect() {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(Effect.RECOLOR);
        }
    }

    public void drawPixel(int x, int y, boolean isSkin) {
        switch (this.drawMode) {
            case PEN: {
                this.setPixel(x, y, this.penColor | 0xFF000000);
                break;
            }
            case RUBBER: {
                this.setPixel(x, y, 0);
                break;
            }
            case FILL: {
                Box box;
                ETextures texs = this.getTextureProvider();
                if (texs == null || !texs.isEditable()) break;
                Box box2 = box = this.selectedElement != null ? this.selectedElement.getTextureBox() : null;
                if (box != null && this.onlyDrawOnSelected && !box.isInBounds(x, y)) {
                    return;
                }
                Image img = texs.getImage();
                if (x < 0 || y < 0 || x >= img.getWidth() || y >= img.getHeight()) {
                    return;
                }
                int old = img.getRGB(x, y);
                if ((old & 0xFFFFFF) == this.penColor) {
                    return;
                }
                if (!texs.isEdited()) {
                    this.setSkinEdited.accept(true);
                }
                HashSet<Vec2i> pixels = new HashSet<Vec2i>();
                Stack<Vec2i> nextPixels = new Stack<Vec2i>();
                nextPixels.add(new Vec2i(x, y));
                while (!nextPixels.empty()) {
                    int color;
                    Vec2i p = (Vec2i)nextPixels.pop();
                    if (pixels.contains(p) || p.x < 0 || p.y < 0 || p.x >= img.getWidth() || p.y >= img.getHeight() || (color = img.getRGB(p.x, p.y)) != old) continue;
                    pixels.add(p);
                    nextPixels.add(new Vec2i(p.x - 1, p.y));
                    nextPixels.add(new Vec2i(p.x + 1, p.y));
                    nextPixels.add(new Vec2i(p.x, p.y - 1));
                    nextPixels.add(new Vec2i(p.x, p.y + 1));
                }
                int color = this.penColor | 0xFF000000;
                this.action("bucketFill").onRun(() -> pixels.forEach(p -> texs.setRGB(p.x, p.y, color))).onUndo(() -> pixels.forEach(p -> texs.setRGB(p.x, p.y, old))).onAction(texs::refreshTexture).execute();
                break;
            }
        }
    }

    private void setPixel(int x, int y, int color) {
        ETextures texs = this.getTextureProvider();
        if (texs != null && texs.isEditable()) {
            Box box;
            Box box2 = box = this.selectedElement != null ? this.selectedElement.getTextureBox() : null;
            if (box != null && this.onlyDrawOnSelected && !box.isInBounds(x, y)) {
                return;
            }
            Image img = texs.getImage();
            if (x < 0 || y < 0 || x >= img.getWidth() || y >= img.getHeight()) {
                return;
            }
            int old = img.getRGB(x, y);
            if (old == color) {
                return;
            }
            if (!texs.isEdited()) {
                this.setSkinEdited.accept(true);
            }
            this.action("draw").onUndo(() -> texs.setRGB(x, y, old)).onRun(() -> texs.setRGB(x, y, color)).onAction(texs::refreshTexture).execute();
        }
    }

    public void markDirty() {
        this.setNameDisplay.accept((this.file == null ? this.frame.getGui().i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()) + "*");
        this.dirty = true;
        if (!this.autoSaveDirty) {
            this.lastEdit = System.currentTimeMillis();
        }
        this.autoSaveDirty = true;
        this.redoQueue.clear();
        this.setUndo.accept(this.undoQueue.empty() ? null : this.undoQueue.peek().getName());
        this.setRedo.accept(null);
    }

    public void updateGui() {
        this.setOffset.accept(null);
        this.setRot.accept(null);
        this.setPosition.accept(null);
        this.setSize.accept(null);
        this.setScale.accept(null);
        this.setMCScale.accept(null);
        this.setMirror.accept(null);
        this.updateName.accept(null);
        this.setModeBtn.accept(null);
        this.setModePanel.accept(PosPanel.ModeDisplayType.NULL);
        this.setTexturePanel.accept(null);
        this.setVis.accept(null);
        this.setDelEn.accept(false);
        this.setAddEn.accept(false);
        this.setGlow.accept(null);
        this.setPartColor.accept(null);
        this.setReColor.accept(null);
        this.setAnimPos.accept(null);
        this.setAnimRot.accept(null);
        this.setAnimFrame.accept(null);
        this.setAnimDelEn.accept(false);
        this.setFrameAddEn.accept(false);
        this.setFrameDelEn.accept(false);
        this.setAnimDuration.accept(null);
        this.setAnimColor.accept(null);
        this.setAnimShow.accept(null);
        this.setAnimPlayEn.accept(false);
        this.setHiddenEffect.accept(null);
        this.setSingleTex.accept(null);
        this.setPerFaceUV.accept(null);
        this.setVis.accept(false);
        this.setAnimPriority.accept(null);
        this.displayViewport.accept(true);
        this.setEnAddAnimTex.accept(false);
        this.applyScaling = false;
        if (this.templateSettings != null) {
            this.templateSettings.templateArgs.forEach(TemplateArgHandler::applyToModel);
        }
        this.templates.forEach(EditorTemplate::applyToModel);
        if (this.selectedElement != null) {
            this.selectedElement.updateGui();
        }
        this.setNameDisplay.accept((this.file == null ? this.frame.getGui().i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()) + (this.dirty ? "*" : ""));
        this.setUndo.accept(this.undoQueue.empty() ? null : this.undoQueue.peek().getName());
        this.setRedo.accept(this.redoQueue.empty() ? null : this.redoQueue.peek().getName());
        if (this.selectedAnim != null) {
            AnimFrame selFrm = this.selectedAnim.getSelectedFrame();
            if (selFrm != null) {
                ModelElement selectedElement = this.getSelectedElement();
                this.setAnimFrame.accept(this.selectedAnim.getFrames().indexOf(selFrm));
                if (selectedElement != null) {
                    IElem dt = selFrm.getData(selectedElement);
                    if (dt == null) {
                        if (this.selectedAnim.add) {
                            this.setAnimPos.accept(new Vec3f());
                            this.setAnimRot.accept(new Vec3f());
                        } else if (selectedElement.type == ElementType.ROOT_PART) {
                            PlayerPartValues val = PlayerPartValues.getFor((PlayerModelParts)selectedElement.typeData, this.skinType);
                            this.setAnimPos.accept(val.getPos());
                            this.setAnimRot.accept(new Vec3f());
                        } else {
                            this.setAnimPos.accept(selectedElement.pos);
                            this.setAnimRot.accept(selectedElement.rotation);
                        }
                        if (!selectedElement.texture || selectedElement.recolor) {
                            this.setAnimColor.accept(selectedElement.rgb);
                        }
                        if (selectedElement.type != ElementType.ROOT_PART && selectedElement.itemRenderer == null) {
                            this.setAnimShow.accept(!selectedElement.hidden);
                        }
                    } else {
                        if (!selectedElement.texture || selectedElement.recolor) {
                            Vec3f c = dt.getColor();
                            this.setAnimColor.accept((int)c.x << 16 | (int)c.y << 8 | (int)c.z);
                        }
                        this.setAnimPos.accept(dt.getPosition());
                        this.setAnimRot.accept(dt.getRotation());
                        if (selectedElement.type != ElementType.ROOT_PART && selectedElement.itemRenderer == null) {
                            this.setAnimShow.accept(dt.isVisible());
                        }
                    }
                }
                this.setFrameDelEn.accept(true);
            }
            this.setFrameAddEn.accept(true);
            this.setAnimDelEn.accept(true);
            this.setAnimDuration.accept(this.selectedAnim.duration);
            this.setAnimPlayEn.accept(this.selectedAnim.getFrames().size() > 1);
            this.setAnimPriority.accept(this.selectedAnim.priority);
        }
        this.setSelAnim.accept(this.selectedAnim);
        ETextures tex = this.getTextureProvider();
        this.setSkinEdited.accept(tex != null ? tex.isEdited() : false);
        this.setReload.accept(tex != null && tex.file != null ? tex.file.getName() : null);
        this.updateGui.accept(null);
    }

    public void loadDefaultPlayerModel() {
        Image skin;
        this.project = new ProjectFile();
        this.elements.clear();
        this.animations.clear();
        this.templates.clear();
        this.templateSettings = null;
        this.textures.values().forEach(ETextures::free);
        ETextures skinTex = this.textures.get((Object)TextureSheetType.SKIN);
        this.textures.clear();
        skinTex.clean();
        this.textures.put(TextureSheetType.SKIN, skinTex);
        this.undoQueue.clear();
        this.redoQueue.clear();
        this.skinType = MinecraftClientAccess.get().getSkinType();
        this.vanillaSkin = skin = this.skinType.getSkinTexture();
        skinTex.setDefaultImg(this.vanillaSkin);
        this.customSkinType = false;
        skinTex.setImage(new Image(skin));
        skinTex.provider.size = new Vec2i(skin.getWidth(), skin.getHeight());
        this.dirty = false;
        this.autoSaveDirty = false;
        this.file = null;
        this.selectedElement = null;
        this.selectedAnim = null;
        this.animEnc = null;
        this.description = null;
        this.scaling = 0.0f;
        this.removeArmorOffset = true;
        this.hideHeadIfSkull = true;
        this.storeIDgen = new StoreIDGen();
        Player<?, ?> profile = MinecraftClientAccess.get().getClientPlayer();
        profile.getTextures().load().thenRun(() -> {
            if (!this.customSkinType) {
                this.skinType = profile.getSkinType();
            }
            CompletableFuture<Image> img = profile.getTextures().getTexture(TextureType.SKIN);
            this.vanillaSkin = this.skinType.getSkinTexture();
            skinTex.setDefaultImg(this.vanillaSkin);
            img.thenAccept(s -> {
                if (!skinTex.isEdited()) {
                    if (s != null) {
                        this.vanillaSkin = s;
                        skinTex.provider.size = new Vec2i(s.getWidth(), s.getHeight());
                        skinTex.setDefaultImg(this.vanillaSkin);
                        skinTex.setImage(new Image(this.vanillaSkin));
                    } else {
                        skinTex.setImage(new Image(this.vanillaSkin));
                    }
                    this.restitchTextures();
                }
            });
        });
        for (PlayerModelParts type : PlayerModelParts.values()) {
            if (type == PlayerModelParts.CUSTOM_PART) continue;
            this.elements.add(new ModelElement(this, ElementType.ROOT_PART, type, this.frame.getGui()));
        }
        this.restitchTextures();
    }

    public void preRender() {
        this.definition.clearTransforms();
        this.elements.forEach(ModelElement::preRender);
        this.applyAnimations();
        if (this.playAnimatedTex) {
            this.textures.values().forEach(ETextures::updateAnim);
        }
    }

    public void applyAnimations() {
        if (this.applyAnim && this.selectedAnim != null) {
            if (this.playFullAnim) {
                long playTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
                long currentStep = playTime - this.playStartTime;
                this.selectedAnim.applyPlay(currentStep);
                if (currentStep > (long)this.selectedAnim.duration && !this.selectedAnim.loop && this.selectedAnim.pose == null) {
                    this.playFullAnim = false;
                    this.setAnimPlay.accept(false);
                }
            } else {
                this.selectedAnim.apply();
            }
        } else if (this.applyAnim && !this.animsToPlay.isEmpty()) {
            this.animsToPlay.sort((a, b) -> Integer.compare(a.priority, b.priority));
            for (EditorAnim anim : this.animsToPlay) {
                long playTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
                long currentStep = playTime - (anim.pose == null ? this.gestureStartTime : this.playStartTime);
                anim.applyPlay(currentStep);
                if (currentStep <= (long)anim.duration || anim.loop || anim.pose != null) continue;
                this.gestureFinished.accept(null);
            }
            this.animsToPlay.clear();
        }
    }

    private void save0(File file) throws IOException {
        ProjectIO.saveProject(this, this.project);
        this.project.save(file);
    }

    public void save(File file) throws IOException {
        this.setInfoMsg.accept(Pair.of(200000, this.gui().i18nFormat("tooltip.cpm.saving", file.getName())));
        this.save0(file);
        this.file = file;
        this.dirty = false;
        this.autoSaveDirty = false;
        this.setInfoMsg.accept(Pair.of(2000, this.gui().i18nFormat("tooltip.cpm.saveSuccess", file.getName())));
        this.updateGui();
    }

    public void load(File file) throws IOException {
        this.loadDefaultPlayerModel();
        this.project.load(file);
        ProjectIO.loadProject(this, this.project);
        this.file = file;
        this.restitchTextures();
        this.updateGui();
    }

    public void reloadSkin() {
        ETextures tex = this.getTextureProvider();
        if (tex != null && tex.file != null) {
            try {
                Image img = Image.loadFrom(tex.file);
                if (img.getWidth() > 512 || img.getHeight() > 512) {
                    throw new IOException(this.frame.getGui().i18nFormat("label.cpm.tex_size_too_big", 512));
                }
                tex.setImage(img);
                tex.setEdited(true);
                this.setSkinEdited.accept(true);
                tex.restitchTexture();
            }
            catch (IOException e) {
                Log.error("Failed to load image", e);
                this.frame.openPopup(new MessagePopup(this.frame, this.frame.getGui().i18nFormat("label.cpm.error", new Object[0]), this.frame.getGui().i18nFormat("error.cpm.img_load_failed", e.getLocalizedMessage())));
            }
        }
    }

    public void saveSkin(File f) {
        ETextures tex = this.getTextureProvider();
        if (tex != null) {
            try {
                tex.getImage().storeTo(f);
                tex.file = f;
            }
            catch (IOException e) {
                Log.error("Failed to save image", e);
                this.frame.openPopup(new MessagePopup(this.frame, this.frame.getGui().i18nFormat("label.cpm.error", new Object[0]), this.frame.getGui().i18nFormat("error.cpm.img_save_failed", e.getLocalizedMessage())));
            }
        }
    }

    public ActionBuilder action(String name) {
        return new ActionBuilder(this, this.gui().i18nFormat("action.cpm." + name, new Object[0]));
    }

    public ActionBuilder action(String name, String arg) {
        return new ActionBuilder(this, this.gui().i18nFormat("action.cpm." + name, this.gui().i18nFormat(arg, new Object[0])));
    }

    public void executeAction(Action a) {
        this.undoQueue.add(a);
        a.run();
    }

    public void undo() {
        if (this.undoQueue.empty()) {
            return;
        }
        Action r = this.undoQueue.pop();
        if (r != null) {
            this.redoQueue.add(r);
            r.undo();
        }
        this.updateGui();
    }

    public void redo() {
        if (this.redoQueue.empty()) {
            return;
        }
        Action r = this.redoQueue.pop();
        if (r != null) {
            this.undoQueue.add(r);
            r.run();
        }
        this.updateGui();
    }

    public <T> void updateValue(T value, BiConsumer<TreeElement, T> func) {
        if (this.selectedElement != null) {
            func.accept(this.selectedElement, (TreeElement)value);
        }
    }

    public void moveElement(ModelElement element, ModelElement to) {
        if (this.checkChild(element.children, to)) {
            return;
        }
        this.action("move", "action.cpm.cube").addToList(to.children, element).removeFromList(element.parent.children, element).updateValueOp(element, element.parent, to, (a, b) -> {
            a.parent = b;
        }).execute();
        this.selectedElement = null;
        this.updateGui();
    }

    private boolean checkChild(List<ModelElement> elem, ModelElement to) {
        for (ModelElement modelElement : elem) {
            if (modelElement == to) {
                return true;
            }
            if (!this.checkChild(modelElement.children, to)) continue;
            return true;
        }
        return false;
    }

    public static void walkElements(List<ModelElement> elem, Consumer<ModelElement> c) {
        for (ModelElement modelElement : elem) {
            c.accept(modelElement);
            Editor.walkElements(modelElement.children, c);
        }
    }

    public void setAnimRot(Vec3f v) {
        if (this.selectedAnim != null) {
            if (v.x < 0.0f || v.x > 360.0f || v.y < 0.0f || v.y > 360.0f || v.z < 0.0f || v.z > 360.0f) {
                while (v.x < 0.0f) {
                    v.x += 360.0f;
                }
                while (v.x > 360.0f) {
                    v.x -= 360.0f;
                }
                while (v.y < 0.0f) {
                    v.y += 360.0f;
                }
                while (v.y > 360.0f) {
                    v.y -= 360.0f;
                }
                while (v.z < 0.0f) {
                    v.z += 360.0f;
                }
                while (v.z > 360.0f) {
                    v.z -= 360.0f;
                }
                this.setAnimRot.accept(v);
            }
            this.selectedAnim.setRotation(v);
        }
    }

    public void setAnimPos(Vec3f v) {
        if (this.selectedAnim != null) {
            this.selectedAnim.setPosition(v);
        }
    }

    public void addNewAnim(IPose pose, String displayName, boolean add, boolean loop) {
        AnimationType type;
        String fname = null;
        if (pose instanceof VanillaPose) {
            fname = "v_" + ((VanillaPose)pose).name().toLowerCase() + "_" + displayName.replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + this.storeIDgen.newId() % 10000L + ".json";
            type = AnimationType.POSE;
        } else if (pose != null) {
            fname = "c_" + ((CustomPose)pose).getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + this.storeIDgen.newId() % 10000L + ".json";
            type = AnimationType.POSE;
        } else {
            fname = "g_" + displayName.replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + this.storeIDgen.newId() % 10000L + ".json";
            type = AnimationType.GESTURE;
        }
        EditorAnim anim = new EditorAnim(this, fname, type, true);
        anim.pose = pose;
        anim.add = add;
        anim.loop = loop;
        anim.displayName = displayName;
        this.action("add", "action.cpm.anim").addToList(this.animations, anim).onUndo(() -> {
            this.selectedAnim = null;
        }).execute();
        this.selectedAnim = anim;
        this.markDirty();
        this.updateGui();
    }

    public void editAnim(IPose pose, String displayName, boolean add, boolean loop) {
        if (this.selectedAnim != null) {
            AnimationType type;
            String fname = null;
            if (pose instanceof VanillaPose) {
                fname = "v_" + ((VanillaPose)pose).name().toLowerCase() + "_" + displayName.replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + this.storeIDgen.newId() % 10000L + ".json";
                type = AnimationType.POSE;
            } else if (pose != null) {
                fname = "c_" + ((CustomPose)pose).getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + this.storeIDgen.newId() % 10000L + ".json";
                type = AnimationType.POSE;
            } else {
                fname = "g_" + displayName.replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + this.storeIDgen.newId() % 10000L + ".json";
                type = AnimationType.GESTURE;
            }
            this.action("edit", "action.cpm.anim").updateValueOp(this.selectedAnim, this.selectedAnim.add, add, (a, b) -> {
                a.add = b;
            }).updateValueOp(this.selectedAnim, this.selectedAnim.loop, loop, (a, b) -> {
                a.loop = b;
            }).updateValueOp(this.selectedAnim, this.selectedAnim.displayName, displayName, (a, b) -> {
                a.displayName = b;
            }).updateValueOp(this.selectedAnim, this.selectedAnim.pose, pose, (a, b) -> {
                a.pose = b;
            }).updateValueOp(this.selectedAnim, this.selectedAnim.type, type, (a, b) -> {
                a.type = b;
            }).updateValueOp(this.selectedAnim, this.selectedAnim.filename, fname, (a, b) -> {
                a.filename = b;
            }).execute();
            this.updateGui();
        }
    }

    public void delSelectedAnim() {
        if (this.selectedAnim != null) {
            EditorAnim anim = this.selectedAnim;
            this.action("remove", "action.cpm.anim").removeFromList(this.animations, anim).onRun(() -> {
                this.selectedAnim = null;
            }).execute();
            this.selectedAnim = null;
            this.updateGui();
        }
    }

    public void addNewAnimFrame() {
        if (this.selectedAnim != null) {
            this.selectedAnim.addFrame();
            this.updateGui();
        }
    }

    public void delSelectedAnimFrame() {
        if (this.selectedAnim != null) {
            this.selectedAnim.deleteFrame();
            this.updateGui();
        }
    }

    public void setAnimDuration(int value) {
        if (this.selectedAnim == null) {
            return;
        }
        this.action("setAnim", "label.cpm.duration").updateValueOp(this.selectedAnim, this.selectedAnim.duration, value, 1, Short.MAX_VALUE, (a, b) -> {
            a.duration = b;
        }, this.setAnimDuration).execute();
    }

    public void setAnimPriority(int value) {
        if (this.selectedAnim == null) {
            return;
        }
        this.action("setAnim", "label.cpm.anim_priority").updateValueOp(this.selectedAnim, this.selectedAnim.priority, value, -128, 127, (a, b) -> {
            a.priority = b;
        }, this.setAnimPriority).execute();
    }

    public void animPrevFrm() {
        if (this.selectedAnim != null) {
            this.selectedAnim.prevFrame();
            this.updateGui();
        }
    }

    public void animNextFrm() {
        if (this.selectedAnim != null) {
            this.selectedAnim.nextFrame();
            this.updateGui();
        }
    }

    public void setAnimColor(int rgb) {
        if (this.selectedAnim != null) {
            this.selectedAnim.setColor(rgb);
            this.updateGui();
        }
    }

    public void delSelectedAnimPartData() {
        if (this.selectedAnim != null) {
            this.selectedAnim.clearSelectedData();
            this.updateGui();
        }
    }

    public void switchAnimShow() {
        if (this.selectedAnim != null) {
            this.selectedAnim.switchVisible();
            this.updateGui();
        }
    }

    public void applyRenderPoseForAnim(Consumer<VanillaPose> func) {
        if (this.applyAnim && this.selectedAnim != null && this.selectedAnim.pose instanceof VanillaPose) {
            func.accept((VanillaPose)this.selectedAnim.pose);
        } else if (this.applyAnim && this.poseToApply != null && this.poseToApply instanceof VanillaPose) {
            func.accept((VanillaPose)this.poseToApply);
        }
        this.poseToApply = null;
    }

    public UIColors colors() {
        return this.frame.getGui().getColors();
    }

    public boolean hasVanillaParts() {
        for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : this.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p || el.hidden) continue;
                return true;
            }
        }
        return false;
    }

    public IGui gui() {
        return this.frame.getGui();
    }

    public ETextures getTextureProvider() {
        return this.selectedElement != null ? this.selectedElement.getTexture() : this.textures.get((Object)TextureSheetType.SKIN);
    }

    public ModelElement getSelectedElement() {
        return this.selectedElement instanceof ModelElement ? (ModelElement)this.selectedElement : null;
    }

    public void free() {
        this.textures.values().forEach(ETextures::free);
        this.definition.cleanup();
    }

    public void restitchTextures() {
        this.textures.values().forEach(ETextures::restitchTexture);
        if (this.textures.get((Object)TextureSheetType.SKIN).hasStitches() && this.hasVanillaParts()) {
            Generators.convertModel(this);
        }
    }

    public void tick() {
        if (this.autoSaveDirty && this.lastEdit + 300000L < System.currentTimeMillis()) {
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            File autosaves = new File(modelsDir, "autosaves");
            autosaves.mkdirs();
            File file = new File(autosaves, String.format("autosave-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS-", System.currentTimeMillis()) + (this.file == null ? this.frame.getGui().i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()));
            Log.info("Editor autosave: " + file.getName());
            this.setInfoMsg.accept(Pair.of(5000, this.gui().i18nFormat("tooltip.cpm.autosaving", file.getName())));
            try {
                this.save0(file);
                this.setInfoMsg.accept(Pair.of(2000, this.gui().i18nFormat("tooltip.cpm.autoSaveSuccess", file.getName())));
            }
            catch (Exception e) {
                this.frame.getGui().onGuiException("Failed to autosave", e, false);
            }
            this.autoSaveDirty = false;
        }
    }

    public void addRoot(RootGroups group) {
        ArrayList<ModelElement> elems = new ArrayList<ModelElement>();
        for (int i = 0; i < group.types.length; ++i) {
            RootModelType type = group.types[i];
            if (!this.elements.stream().noneMatch(e -> e.type == ElementType.ROOT_PART && e.typeData == type)) continue;
            ModelElement e2 = new ModelElement(this, ElementType.ROOT_PART, type, this.frame.getGui());
            elems.add(e2);
        }
        ActionBuilder ab = this.action("add", "action.cpm.root");
        elems.forEach(e -> ab.addToList(this.elements, e));
        ab.onUndo(() -> {
            this.selectedElement = null;
        });
        Generators.loadTextures(this, group, (a, b) -> ab.addToMap(this.textures, a, b));
        ab.execute();
        this.updateGui();
    }

    public void render(MatrixStack stack, VBuffers buf) {
        if (this.selectedElement != null) {
            this.selectedElement.render3d(stack, buf);
        }
    }

    public void animMoveFrame(int i) {
        if (this.selectedAnim != null) {
            this.selectedAnim.moveFrame(i);
            this.updateGui();
        }
    }

    public void addAnimTex() {
        ETextures tex;
        if (this.selectedElement != null && (tex = this.selectedElement.getTexture()) != null && tex.isEditable()) {
            this.action("add", "action.cpm.animTex").addToList(tex.animatedTexs, new AnimatedTex(this, tex.getType())).execute();
            this.updateGui();
        }
    }
}

