/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimatedTexture;
import com.tom.cpm.shared.animation.Animation;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimationRegistry {
    private List<AnimatedTexture> animatedTextures = new ArrayList<AnimatedTexture>();
    private Map<IPose, List<Animation>> animations = new HashMap<IPose, List<Animation>>();
    private Map<Integer, IPose> encodedToPose = new HashMap<Integer, IPose>();
    private Map<Integer, Gesture> encodedToGesture = new HashMap<Integer, Gesture>();
    private Map<IPose, Integer> poseToEncoded = new HashMap<IPose, Integer>();
    private Map<Gesture, Integer> gestureToEncoded = new HashMap<Gesture, Integer>();
    private Map<String, Gesture> gestures = new HashMap<String, Gesture>();
    private Map<String, CustomPose> customPoses = new HashMap<String, CustomPose>();
    private int blankGesture;
    private int poseResetId;

    public List<Animation> getPoseAnimations(IPose id) {
        return this.animations.getOrDefault(id, Collections.emptyList());
    }

    public IPose getPose(int gesture, IPose pose) {
        return this.encodedToPose.getOrDefault(gesture, pose);
    }

    public Gesture getGesture(int gesture) {
        return this.encodedToGesture.get(gesture);
    }

    public void register(IPose pose, Animation anim) {
        this.animations.computeIfAbsent(pose, k -> new ArrayList()).add(anim);
    }

    public void register(int gid, IPose pose) {
        this.encodedToPose.put(gid, pose);
        this.poseToEncoded.put(pose, gid);
    }

    public void register(CustomPose pose) {
        this.customPoses.put(pose.getName(), pose);
    }

    public void register(Gesture gesture) {
        this.gestures.put(gesture.name, gesture);
    }

    public void register(int gid, Gesture gesture) {
        this.encodedToGesture.put(gid, gesture);
        this.gestureToEncoded.put(gesture, gid);
    }

    public int getEncoded(Gesture g) {
        return this.gestureToEncoded.getOrDefault(g, -1);
    }

    public int getEncoded(CustomPose pose) {
        return this.poseToEncoded.getOrDefault(pose, -1);
    }

    public Map<String, Gesture> getGestures() {
        return this.gestures;
    }

    public Map<String, CustomPose> getCustomPoses() {
        return this.customPoses;
    }

    public int getBlankGesture() {
        return this.blankGesture;
    }

    public void setBlankGesture(int blankGesture) {
        this.blankGesture = blankGesture;
    }

    public void setPoseResetId(int poseResetId) {
        this.poseResetId = poseResetId;
    }

    public int getPoseResetId() {
        return this.poseResetId;
    }

    public void addAnimatedTexture(AnimatedTexture tex) {
        this.animatedTextures.add(tex);
    }

    public void tickAnimated(long time) {
        for (int i = 0; i < this.animatedTextures.size(); ++i) {
            this.animatedTextures.get(i).update(time);
        }
    }

    public static class Gesture {
        public List<Animation> animation;
        public boolean isLoop;
        public String name;

        public Gesture(List<Animation> animation, String name, boolean isLoop) {
            this.animation = animation;
            this.name = name;
            this.isLoop = isLoop;
        }
    }
}

