/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.skin.TextureProvider;

public class AnimatedTexture {
    private final ModelDefinition def;
    private final TextureSheetType sheet;
    private final Vec2i uvStart;
    private final Vec2i uvSize;
    private final Vec2i animStart;
    private final int frameTime;
    private final int frameCount;
    private final boolean anX;
    private final boolean interpolate;
    private int lastFrame;
    private long lastUpdate;

    public AnimatedTexture(ModelDefinition def, TextureSheetType sheet, Vec2i uvStart, Vec2i uvSize, Vec2i animStart, int frameCount, int frameTime, boolean anX, boolean interpolate) {
        this.def = def;
        this.sheet = sheet;
        this.uvStart = uvStart;
        this.uvSize = uvSize;
        this.animStart = animStart;
        this.frameCount = frameCount;
        this.frameTime = frameTime;
        this.anX = anX;
        this.interpolate = interpolate;
    }

    public void update(long time) {
        if (this.frameCount == 0 || this.frameTime == 0) {
            return;
        }
        int frm = (int)(time / (long)this.frameTime % (long)this.frameCount);
        if (this.interpolate) {
            if (time - this.lastUpdate > 50L) {
                TextureProvider tex = this.def.getTexture(this.sheet, false);
                Image img = tex.getImage();
                float t = (float)frm + (float)(time % (long)this.frameTime) / (float)this.frameTime;
                int uvx = this.uvStart.x;
                int uvy = this.uvStart.y;
                int sx = this.uvSize.x;
                int sy = this.uvSize.y;
                int ax = this.animStart.x;
                int ay = this.animStart.y;
                AnimatedTexture.copyTextureInt(img, img, uvx, uvy, sx, sy, ax, ay, t, this.anX, this.frameCount);
                if (tex.texture != null) {
                    tex.texture.markDirty();
                }
            }
        } else if (frm != this.lastFrame) {
            TextureProvider tex = this.def.getTexture(this.sheet, false);
            Image img = tex.getImage();
            this.lastFrame = frm;
            int uvx = this.uvStart.x;
            int uvy = this.uvStart.y;
            int sx = this.uvSize.x;
            int sy = this.uvSize.y;
            int ax = this.animStart.x;
            int ay = this.animStart.y;
            AnimatedTexture.copyTexture(img, img, uvx, uvy, sx, sy, ax, ay, frm, this.anX);
            if (tex.texture != null) {
                tex.texture.markDirty();
            }
        }
    }

    public static void copyTexture(Image dest, Image img, int uvx, int uvy, int sx, int sy, int ax, int ay, int frame, boolean anX) {
        if (anX) {
            ax += sx * frame;
        } else {
            ay += sy * frame;
        }
        for (int x = 0; x < sx; ++x) {
            for (int y = 0; y < sy; ++y) {
                dest.setRGB(x + uvx, y + uvy, img.getRGB(x + ax, y + ay));
            }
        }
    }

    public static void copyTextureInt(Image dest, Image img, int uvx, int uvy, int sx, int sy, int axIn, int ayIn, float time, boolean anX, int frms) {
        int frame = (int)time;
        float subfrm = 1.0f - (time - (float)frame);
        int axf = axIn;
        int ayf = ayIn;
        int axs = axIn;
        int ays = ayIn;
        if (anX) {
            axf = axIn + sx * frame;
            axs = axIn + sx * ((frame + 1) % frms);
        } else {
            ayf = ayIn + sy * frame;
            ays = ayIn + sy * ((frame + 1) % frms);
        }
        for (int x = 0; x < sx; ++x) {
            for (int y = 0; y < sy; ++y) {
                int first = img.getRGB(x + axf, y + ayf);
                int second = img.getRGB(x + axs, y + ays);
                int r = AnimatedTexture.mix(subfrm, first >> 16 & 0xFF, second >> 16 & 0xFF);
                int g = AnimatedTexture.mix(subfrm, first >> 8 & 0xFF, second >> 8 & 0xFF);
                int b = AnimatedTexture.mix(subfrm, first & 0xFF, second & 0xFF);
                dest.setRGB(x + uvx, y + uvy, first & 0xFF000000 | r << 16 | g << 8 | b);
            }
        }
    }

    private static int mix(float time, int first, int second) {
        return (int)(time * (float)first + (1.0f - time) * (float)second);
    }
}

