/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.shared.IPlayerRenderManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.MojangSkinUploadAPI;
import java.io.File;
import java.util.List;
import java.util.function.Function;

public interface MinecraftClientAccess {
    public IPlayerRenderManager getPlayerRenderManager();

    public ModelDefinitionLoader getDefinitionLoader();

    public DynamicTexture.ITexture createTexture();

    public void executeLater(Runnable var1);

    public static MinecraftClientAccess get() {
        return MinecraftObjectHolder.clientObject;
    }

    default public Player<?, ?> getClientPlayer() {
        return this.getDefinitionLoader().loadPlayer(this.getPlayerIDObject());
    }

    default public Player<?, ?> getCurrentClientPlayer() {
        Object v = this.getCurrentPlayerIDObject();
        if (v == null) {
            return this.getClientPlayer();
        }
        return this.getDefinitionLoader().loadPlayer(v);
    }

    public Object getPlayerIDObject();

    public Object getCurrentPlayerIDObject();

    public SkinType getSkinType();

    public void setEncodedGesture(int var1);

    public boolean isInGame();

    public List<IKeybind> getKeybinds();

    public File getGameDir();

    public NetHandler<?, ?, ?, ?, ?> getNetHandler();

    public void openGui(Function<IGui, Frame> var1);

    public ImageIO.IImageIO getImageIO();

    public MojangSkinUploadAPI getUploadAPI();

    public void clearSkinCache();

    public String getConnectedServer();

    public List<Object> getPlayers();

    default public Runnable openSingleplayer() {
        throw new UnsupportedOperationException();
    }

    default public void sendSkinUpdate() {
        this.getNetHandler().sendSkinData();
    }

    default public void setModelScale(float scl) {
        this.getNetHandler().setScale(scl);
    }

    default public ServerStatus getServerSideStatus() {
        return this.isInGame() ? (this.getNetHandler().hasModClient() ? ServerStatus.INSTALLED : ServerStatus.SKIN_LAYERS_ONLY) : ServerStatus.OFFLINE;
    }

    public static enum ServerStatus {
        OFFLINE,
        UNAVAILABLE,
        SKIN_LAYERS_ONLY,
        INSTALLED;

    }
}

