/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpm.common.CommandCPM;
import com.tom.cpm.common.PehkuiInterface;
import com.tom.cpm.common.ShrinkInterface;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ServerHandler {
    public static NetHandler<ResourceLocation, CompoundNBT, ServerPlayerEntity, PacketBuffer, ServerPlayNetHandler> netHandler = new NetHandler(ResourceLocation::new);

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        netHandler.onJoin((ServerPlayerEntity)evt.getPlayer());
    }

    @SubscribeEvent
    public void onTrackingStart(PlayerEvent.StartTracking evt) {
        ServerPlayNetHandler handler = ((ServerPlayerEntity)evt.getPlayer()).field_71135_a;
        NetH h = (NetH)handler;
        if (h.cpm$hasMod() && evt.getTarget() instanceof PlayerEntity) {
            netHandler.sendPlayerData((ServerPlayerEntity)evt.getTarget(), (ServerPlayerEntity)evt.getPlayer());
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        CommandDispatcher d = evt.getDispatcher();
        CommandCPM.register((CommandDispatcher<CommandSource>)d);
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        if (!evt.isEndConquered()) {
            netHandler.onRespawn((ServerPlayerEntity)evt.getPlayer());
        }
    }

    public static boolean hasMod(ServerPlayerEntity spe) {
        return ((NetH)spe.field_71135_a).cpm$hasMod();
    }

    public static void sendToAllTrackingAndSelf(ServerPlayerEntity ent, IPacket<?> pckt, Predicate<ServerPlayerEntity> test, GenericFutureListener<? extends Future<? super Void>> future) {
        ChunkManager.EntityTracker tr = (ChunkManager.EntityTracker)((ServerWorld)ent.field_70170_p).func_72863_F().field_217237_a.field_219272_z.get(ent.func_145782_y());
        for (ServerPlayerEntity p : tr.field_219406_f) {
            if (!test.test(p)) continue;
            p.field_71135_a.func_211148_a(pckt, future);
        }
        ent.field_71135_a.func_211148_a(pckt, future);
    }

    static {
        netHandler.setNewNbt(CompoundNBT::new);
        netHandler.setNewPacketBuffer(() -> new PacketBuffer(Unpooled.buffer()));
        netHandler.setGetPlayerUUID(Entity::func_110124_au);
        netHandler.setWriteCompound(PacketBuffer::func_150786_a, PacketBuffer::func_150793_b);
        netHandler.setSendPacket((c, rl, pb) -> c.func_147359_a((IPacket)new SCustomPayloadPlayPacket(rl, pb)), (spe, rl, pb) -> ServerHandler.sendToAllTrackingAndSelf(spe, new SCustomPayloadPlayPacket(rl, pb), ServerHandler::hasMod, null));
        netHandler.setWritePlayerId((pb, pl) -> pb.func_150787_b(pl.func_145782_y()));
        netHandler.setNBTSetters(CompoundNBT::func_74757_a, CompoundNBT::func_74773_a, CompoundNBT::func_74776_a);
        netHandler.setNBTGetters(CompoundNBT::func_74767_n, CompoundNBT::func_74770_j, CompoundNBT::func_74760_g);
        netHandler.setContains(CompoundNBT::func_74764_b);
        netHandler.setFindTracking((p, f) -> {
            for (ChunkManager.EntityTracker tr : ((ServerWorld)p.field_70170_p).func_72863_F().field_217237_a.field_219272_z.values()) {
                if (!(tr.field_219403_c instanceof PlayerEntity) || !tr.field_219406_f.contains(p)) continue;
                f.accept((ServerPlayerEntity)tr.field_219403_c);
            }
        });
        netHandler.setSendChat((p, m) -> p.field_71135_a.func_147359_a((IPacket)new SChatPacket((ITextComponent)new TranslationTextComponent(m), ChatType.CHAT, Util.field_240973_b_)));
        netHandler.setExecutor(ServerLifecycleHooks::getCurrentServer);
        netHandler.setScaleSetter((spe, sc) -> {
            if (ModList.get().isLoaded("pehkui")) {
                if (sc.floatValue() == 0.0f) {
                    PehkuiInterface.setScale(spe, 1.0f);
                } else {
                    PehkuiInterface.setScale(spe, sc.floatValue());
                }
            } else if (ModList.get().isLoaded("shrink")) {
                if (sc.floatValue() == 0.0f) {
                    ShrinkInterface.setScale(spe, 1.0f);
                } else {
                    ShrinkInterface.setScale(spe, sc.floatValue());
                }
            }
        });
        netHandler.setGetNet(spe -> spe.field_71135_a);
        netHandler.setGetPlayer(net -> net.field_147369_b);
    }
}

