/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PlayerProfile
extends Player<PlayerEntity, Model> {
    private final GameProfile profile;
    private String skinType;
    private VanillaPose pose;
    private int encodedGesture;
    public boolean hasPlayerHead;

    public PlayerProfile(GameProfile profile) {
        this.profile = profile;
        if (profile.getId() != null) {
            this.skinType = DefaultPlayerSkin.func_177332_b((UUID)profile.getId());
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public PlayerModel<AbstractClientPlayerEntity> getModel() {
        return (PlayerModel)((PlayerRenderer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get(this.skinType == null ? "default" : this.skinType)).func_217764_d();
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public VanillaPose getPose() {
        return this.pose;
    }

    @Override
    public void updateFromPlayer(PlayerEntity player) {
        ItemStack is;
        Pose p = player.func_213283_Z();
        this.pose = p == Pose.SLEEPING ? VanillaPose.SLEEPING : (!player.func_70089_S() ? VanillaPose.DYING : (p == Pose.FALL_FLYING ? VanillaPose.FLYING : (player.field_70143_R > 4.0f ? VanillaPose.FALLING : (player.func_184218_aH() && player.func_184187_bx() != null && player.func_184187_bx().shouldRiderSit() ? VanillaPose.RIDING : (p == Pose.SWIMMING ? VanillaPose.SWIMMING : (player.func_70051_ag() ? VanillaPose.RUNNING : (p == Pose.CROUCHING ? VanillaPose.SNEAKING : (Math.abs(player.func_226277_ct_() - player.field_70169_q) > 0.0 || Math.abs(player.func_226281_cx_() - player.field_70166_s) > 0.0 ? VanillaPose.WALKING : VanillaPose.STANDING))))))));
        this.encodedGesture = 0;
        if (player.func_175148_a(PlayerModelPart.HAT)) {
            this.encodedGesture |= 1;
        }
        if (player.func_175148_a(PlayerModelPart.JACKET)) {
            this.encodedGesture |= 2;
        }
        if (player.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG)) {
            this.encodedGesture |= 4;
        }
        if (player.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG)) {
            this.encodedGesture |= 8;
        }
        if (player.func_175148_a(PlayerModelPart.LEFT_SLEEVE)) {
            this.encodedGesture |= 0x10;
        }
        if (player.func_175148_a(PlayerModelPart.RIGHT_SLEEVE)) {
            this.encodedGesture |= 0x20;
        }
        this.hasPlayerHead = (is = player.func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof BlockItem && ((BlockItem)is.func_77973_b()).func_179223_d() instanceof AbstractSkullBlock;
    }

    public void setRenderPose(VanillaPose pose) {
        this.pose = pose;
        this.encodedGesture = 0;
    }

    @Override
    public int getEncodedGestureId() {
        return this.encodedGesture;
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture tex = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                    PlayerProfile.this.skinType = tex.getMetadata("model");
                    if (PlayerProfile.this.skinType == null) {
                        PlayerProfile.this.skinType = "default";
                    }
                    return CompletableFuture.completedFuture(null);
                }
                final CompletableFuture<Void> cf = new CompletableFuture<Void>();
                Minecraft.func_71410_x().func_152342_ad().func_152790_a(PlayerProfile.this.profile, new SkinManager.ISkinAvailableCallback(){

                    public void onSkinTextureAvailable(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                        this.defineTexture((Enum)typeIn, profileTexture.getUrl());
                        switch (typeIn) {
                            case SKIN: {
                                PlayerProfile.this.skinType = profileTexture.getMetadata("model");
                                if (PlayerProfile.this.skinType == null) {
                                    PlayerProfile.this.skinType = "default";
                                }
                                cf.complete(null);
                                break;
                            }
                        }
                    }
                }, true);
                return cf;
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }
}

