/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.client.CustomRenderTypes;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.render.RenderMode;
import java.nio.FloatBuffer;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Panel3dImpl
extends Panel3d.Panel3dNative {
    private com.mojang.blaze3d.matrix.MatrixStack matrixstack;
    private Minecraft mc = Minecraft.func_71410_x();

    public Panel3dImpl(Panel3d panel) {
        super(panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTicks) {
        ViewportCamera cam = this.panel.getCamera();
        float pitch = (float)Math.asin(cam.look.y);
        float yaw = cam.look.getYaw();
        Box bounds = this.getBounds();
        Vec2i off = this.panel.getGui().getOffset();
        float size = cam.camDist;
        RenderSystem.pushMatrix();
        try {
            RenderSystem.translatef((float)(off.x + bounds.w / 2), (float)(off.y + bounds.h / 2), (float)600.0f);
            RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-0.1f);
            this.matrixstack = new com.mojang.blaze3d.matrix.MatrixStack();
            this.matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
            this.matrixstack.func_227862_a_(size, size, size);
            Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            Quaternion quaternion1 = Vector3f.field_229179_b_.func_229193_c_(-pitch);
            quaternion.func_195890_a(quaternion1);
            this.matrixstack.func_227863_a_(quaternion);
            this.matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)((double)yaw + Math.PI)));
            this.matrixstack.func_227861_a_((double)(-cam.position.x), (double)(-cam.position.y), (double)(-cam.position.z));
            RenderSystem.enableDepthTest();
            IRenderTypeBuffer.Impl bufs = this.mc.func_228019_au_().func_228487_b_();
            int light = LightTexture.func_228451_a_((int)15, (int)15);
            this.panel.render(new MatrixStack(), new VBuffers(arg_0 -> this.lambda$render$0((IRenderTypeBuffer)bufs, light, arg_0)), partialTicks);
            this.mc.func_228019_au_().func_228487_b_().func_228461_a_();
        }
        finally {
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
            this.matrixstack = null;
        }
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return this.getRenderTypes(MinecraftObject.DynTexture.getBoundLoc());
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String texture) {
        return this.getRenderTypes(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
    }

    public RenderTypes<RenderMode> getRenderTypes(ResourceLocation rl) {
        RenderTypes<RenderMode> renderTypes = new RenderTypes<RenderMode>(RenderMode.class);
        renderTypes.put(RenderMode.NORMAL, new VBuffers.NativeRenderType(0));
        renderTypes.put(RenderMode.DEFAULT, new VBuffers.NativeRenderType(RenderType.func_228644_e_((ResourceLocation)rl), 0));
        renderTypes.put(RenderMode.PAINT, new VBuffers.NativeRenderType(CustomRenderTypes.getEntityTranslucentCullNoLight(rl), 0));
        renderTypes.put(RenderMode.GLOW, new VBuffers.NativeRenderType(RenderType.func_228652_i_((ResourceLocation)rl), 1));
        renderTypes.put(RenderMode.OUTLINE, new VBuffers.NativeRenderType(CustomRenderTypes.getLinesNoDepth(), 2));
        renderTypes.put(RenderMode.COLOR, new VBuffers.NativeRenderType(CustomRenderTypes.getEntityColorTranslucentCull(), 0));
        return renderTypes;
    }

    @Override
    public int getColorUnderMouse() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)3);
        GL11.glReadPixels((int)((int)this.mc.field_71417_B.func_198024_e()), (int)(this.mc.func_228018_at_().func_198091_l() - (int)this.mc.field_71417_B.func_198026_f()), (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)buffer);
        int colorUnderMouse = (int)(buffer.get(0) * 255.0f) << 16 | (int)(buffer.get(1) * 255.0f) << 8 | (int)(buffer.get(2) * 255.0f);
        GL11.glClear((int)256);
        return colorUnderMouse;
    }

    @Override
    public Image takeScreenshot(Vec2i size) {
        GuiImpl gui = (GuiImpl)this.panel.getGui();
        int dw = this.mc.func_228018_at_().func_198109_k();
        int dh = this.mc.func_228018_at_().func_198091_l();
        float multiplierX = (float)dw / (float)gui.field_230708_k_;
        float multiplierY = (float)dh / (float)gui.field_230709_l_;
        int width = (int)(multiplierX * (float)size.x);
        int height = (int)(multiplierY * (float)size.y);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(width * height * 3));
        GL11.glReadPixels((int)((int)(multiplierX * (float)this.renderPos.x)), (int)(this.mc.func_228018_at_().func_198091_l() - height - (int)(multiplierY * (float)this.renderPos.y)), (int)width, (int)height, (int)6407, (int)5126, (FloatBuffer)buffer);
        Image img = new Image(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = buffer.get((x + y * width) * 3);
                float g = buffer.get((x + y * width) * 3 + 1);
                float b = buffer.get((x + y * width) * 3 + 2);
                int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                img.setRGB(x, height - y - 1, color);
            }
        }
        Image rImg = new Image(size.x, size.y);
        rImg.draw(img, 0, 0, size.x, size.y);
        return rImg;
    }

    @Override
    public void renderItem(MatrixStack stack, ItemSlot hand, DisplayItem item) {
        this.renderItem(stack, this.getHandStack(item), hand);
    }

    private ItemStack getHandStack(DisplayItem item) {
        switch (item) {
            case BLOCK: {
                return new ItemStack((IItemProvider)Blocks.field_150348_b);
            }
            case NONE: {
                break;
            }
            case SWORD: {
                return new ItemStack((IItemProvider)Items.field_234754_kI_);
            }
            case SKULL: {
                return new ItemStack((IItemProvider)Items.field_196185_dy);
            }
        }
        return ItemStack.field_190927_a;
    }

    private void renderItem(MatrixStack stack, ItemStack itemstack, ItemSlot hand) {
        if (!itemstack.func_190926_b()) {
            this.matrixstack.func_227860_a_();
            PlayerRenderManager.multiplyStacks(stack.getLast(), this.matrixstack);
            boolean flag = false;
            ItemCameraTransforms.TransformType view = ItemCameraTransforms.TransformType.FIXED;
            if (hand == ItemSlot.LEFT_HAND || hand == ItemSlot.RIGHT_HAND) {
                this.matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                this.matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                flag = hand == ItemSlot.LEFT_HAND;
                view = flag ? ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
                this.matrixstack.func_227861_a_((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            } else if (hand == ItemSlot.HEAD) {
                Item item = itemstack.func_77973_b();
                if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock) {
                    this.matrixstack.func_227862_a_(1.1875f, -1.1875f, -1.1875f);
                    this.matrixstack.func_227861_a_(-0.5, 0.0, -0.5);
                    SkullTileEntityRenderer.func_228879_a_(null, (float)180.0f, (SkullBlock.ISkullType)((AbstractSkullBlock)((BlockItem)item).func_179223_d()).func_196292_N_(), null, (float)0.0f, (com.mojang.blaze3d.matrix.MatrixStack)this.matrixstack, (IRenderTypeBuffer)this.mc.func_228019_au_().func_228487_b_(), (int)LightTexture.func_228451_a_((int)15, (int)15));
                    this.matrixstack.func_227865_b_();
                    return;
                }
                this.matrixstack.func_227861_a_(0.0, -0.25, 0.0);
                this.matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                this.matrixstack.func_227862_a_(0.625f, -0.625f, -0.625f);
                view = ItemCameraTransforms.TransformType.HEAD;
            }
            this.mc.func_175599_af().func_229109_a_(null, itemstack, view, flag, this.matrixstack, (IRenderTypeBuffer)this.mc.func_228019_au_().func_228487_b_(), null, LightTexture.func_228451_a_((int)15, (int)15), OverlayTexture.field_229196_a_);
            this.matrixstack.func_227865_b_();
        }
    }

    private /* synthetic */ VertexBuffer lambda$render$0(IRenderTypeBuffer bufs, int light, VBuffers.NativeRenderType rt) {
        return new VBuffer(bufs.getBuffer((RenderType)rt.getNativeType()), light, OverlayTexture.field_229196_a_, this.matrixstack);
    }
}

