/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tom.cpm.CommonProxy;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.gui.SettingsGui;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import io.netty.buffer.Unpooled;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.CustomizeSkinScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;

public class ClientProxy
extends CommonProxy {
    public static final ResourceLocation DEFAULT_CAPE = new ResourceLocation("cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static ClientProxy INSTANCE;
    public static MinecraftObject mc;
    private Minecraft minecraft;
    public RenderManager<GameProfile, PlayerEntity, Model, IRenderTypeBuffer> manager;
    public NetHandler<ResourceLocation, CompoundNBT, PlayerEntity, PacketBuffer, ClientPlayNetHandler> netHandler;

    @Override
    public void init() {
        super.init();
        INSTANCE = this;
        this.minecraft = Minecraft.func_71410_x();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        KeyBindings.init();
        this.manager = new RenderManager<GameProfile, PlayerEntity, Model, IRenderTypeBuffer>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerEntity::func_146103_bH);
        this.netHandler = new NetHandler(ResourceLocation::new);
        this.netHandler.setNewNbt(CompoundNBT::new);
        this.netHandler.setNewPacketBuffer(() -> new PacketBuffer(Unpooled.buffer()));
        this.netHandler.setWriteCompound(PacketBuffer::func_150786_a, PacketBuffer::func_150793_b);
        this.netHandler.setNBTSetters(CompoundNBT::func_74757_a, CompoundNBT::func_74773_a, CompoundNBT::func_74776_a);
        this.netHandler.setNBTGetters(CompoundNBT::func_74767_n, CompoundNBT::func_74770_j, CompoundNBT::func_74760_g);
        this.netHandler.setContains(CompoundNBT::func_74764_b);
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacket((c, rl, pb) -> c.func_147297_a((IPacket)new CCustomPayloadPacket(rl, pb)), null);
        this.netHandler.setPlayerToLoader(PlayerEntity::func_146103_bH);
        this.netHandler.setReadPlayerId(PacketBuffer::func_150792_a, id -> {
            Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(id.intValue());
            if (ent instanceof PlayerEntity) {
                return (PlayerEntity)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_71439_g);
        this.netHandler.setGetNet(c -> ((ClientPlayerEntity)c).field_71174_a);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, scr) -> new GuiImpl(SettingsGui::new, (Screen)scr));
    }

    @SubscribeEvent
    public void playerRenderPre(RenderPlayerEvent.Pre event) {
        this.manager.bindPlayer(event.getPlayer(), event.getBuffers());
    }

    @SubscribeEvent
    public void playerRenderPost(RenderPlayerEvent.Post event) {
        this.manager.tryUnbind();
    }

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.getGui() instanceof CustomizeSkinScreen) {
            evt.addWidget((Widget)new Button(0, 0, () -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiImpl(EditorGui::new, evt.getGui()))));
        }
    }

    public void renderHand(IRenderTypeBuffer buffer) {
        this.manager.bindHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, buffer);
    }

    public void renderSkull(Model skullModel, GameProfile profile, IRenderTypeBuffer buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderElytra(PlayerEntity player, IRenderTypeBuffer buffer, ElytraModel<LivingEntity> model) {
        this.manager.bindElytra(player, buffer, (Model)model);
    }

    public void renderArmor(BipedModel<LivingEntity> modelArmor, BipedModel<LivingEntity> modelLeggings, PlayerEntity player, IRenderTypeBuffer bufferIn) {
        this.manager.bindArmor(player, bufferIn, (Model)modelArmor, 1);
        this.manager.bindArmor(player, bufferIn, (Model)modelLeggings, 2);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            mc.getPlayerRenderManager().getAnimationEngine().update(evt.renderTickTime);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && !this.minecraft.func_147113_T()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
        }
        if (this.minecraft.field_71439_g == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.func_151468_f()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        for (Map.Entry<Integer, KeyBinding> e : KeyBindings.quickAccess.entrySet()) {
            if (!e.getValue().func_151468_f()) continue;
            mc.getPlayerRenderManager().getAnimationEngine().onKeybind(e.getKey());
        }
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent openGui) {
        if (openGui.getGui() == null && this.minecraft.field_71462_r instanceof GuiImpl.Overlay) {
            openGui.setGui(((GuiImpl.Overlay)this.minecraft.field_71462_r).getGui());
        }
        if (openGui.getGui() instanceof MainMenuScreen && EditorGui.doOpenEditor()) {
            openGui.setGui((Screen)new GuiImpl(EditorGui::new, openGui.getGui()));
        }
    }

    @SubscribeEvent
    public void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent evt) {
        mc.getDefinitionLoader().clearServerData();
    }

    public void unbind(Model model) {
        this.manager.tryUnbind(model);
    }

    public static void renderCape(MatrixStack matrixStackIn, IVertexBuilder buffer, int packedLightIn, AbstractClientPlayerEntity playerIn, float partialTicks, PlayerModel<AbstractClientPlayerEntity> model, ModelDefinition modelDefinition) {
        float f3;
        float f2;
        float f1;
        matrixStackIn.func_227860_a_();
        if (playerIn != null) {
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71091_bM, (double)playerIn.field_71094_bP) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70169_q, (double)playerIn.func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71096_bN, (double)playerIn.field_71095_bQ) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70167_r, (double)playerIn.func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71097_bO, (double)playerIn.field_71085_bR) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70166_s, (double)playerIn.func_226281_cx_());
            float f = playerIn.field_70760_ar + (playerIn.field_70761_aq - playerIn.field_70760_ar);
            double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
            double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
            f1 = (float)d1 * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
            f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = MathHelper.func_76131_a((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = MathHelper.func_219799_g((float)partialTicks, (float)playerIn.field_71107_bF, (float)playerIn.field_71109_bG);
            f1 += MathHelper.func_76126_a((float)(MathHelper.func_219799_g((float)partialTicks, (float)playerIn.field_70141_P, (float)playerIn.field_70140_Q) * 6.0f)) * 32.0f * f4;
            if (playerIn.func_213453_ef()) {
                f1 += 25.0f;
            }
            if (playerIn.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                if (playerIn.func_213453_ef()) {
                    model.field_178729_w.field_78798_e = 1.775f;
                    model.field_178729_w.field_78797_d = 2.35f;
                } else {
                    model.field_178729_w.field_78798_e = 2.0f;
                    model.field_178729_w.field_78797_d = 0.0f;
                }
            } else if (playerIn.func_213453_ef()) {
                model.field_178729_w.field_78798_e = 2.3f;
                model.field_178729_w.field_78797_d = 1.1f;
            } else {
                model.field_178729_w.field_78798_e = 2.9f;
                model.field_178729_w.field_78797_d = 0.14999998f;
            }
        } else {
            f1 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
        }
        model.field_178729_w.field_78795_f = (float)(-Math.toRadians(6.0f + f2 / 2.0f + f1));
        model.field_178729_w.field_78796_g = (float)Math.toRadians(180.0f - f3 / 2.0f);
        model.field_178729_w.field_78808_h = (float)Math.toRadians(f3 / 2.0f);
        model.func_228289_b_(matrixStackIn, buffer, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
    }

    static {
        INSTANCE = null;
    }

    public static class Button
    extends net.minecraft.client.gui.widget.button.Button {
        public Button(int x, int y, Runnable r) {
            super(x, y, 100, 20, (ITextComponent)new TranslationTextComponent("button.cpm.open_editor"), b -> r.run());
        }
    }
}

