/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.google.common.collect.Queues;
import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Quaternion;
import java.util.Deque;

public class MatrixStack {
    private final Deque<Entry> stack = Queues.newArrayDeque();

    public MatrixStack() {
        Mat4f matrix4f = new Mat4f();
        matrix4f.setIdentity();
        Mat3f matrix3f = new Mat3f();
        matrix3f.setIdentity();
        this.stack.add(new Entry(matrix4f, matrix3f));
    }

    public void translate(double x, double y, double z) {
        Entry e = this.stack.getLast();
        e.matrix.mul(Mat4f.makeTranslate((float)x, (float)y, (float)z));
    }

    public void scale(float x, float y, float z) {
        Entry e = this.stack.getLast();
        e.matrix.mul(Mat4f.makeScale(x, y, z));
        if (x == y && y == z) {
            if (x > 0.0f) {
                return;
            }
            e.normal.mul(-1.0f);
        }
        float f = 1.0f / x;
        float f1 = 1.0f / y;
        float f2 = 1.0f / z;
        float f3 = MathHelper.fastInvCubeRoot(f * f1 * f2);
        e.normal.mul(Mat3f.makeScaleMatrix(f3 * f, f3 * f1, f3 * f2));
    }

    public void rotate(Quaternion quaternion) {
        Entry e = this.stack.getLast();
        e.matrix.mul(quaternion);
        e.normal.mul(quaternion);
    }

    public void push() {
        Entry e = this.stack.getLast();
        this.stack.addLast(new Entry(e.matrix.copy(), e.normal.copy()));
    }

    public void pop() {
        this.stack.removeLast();
    }

    public Entry getLast() {
        return this.stack.getLast();
    }

    public boolean clear() {
        return this.stack.size() == 1;
    }

    public Entry storeLast() {
        Entry e = this.stack.getLast();
        return new Entry(e.matrix.copy(), e.normal.copy());
    }

    public void setLast(Entry in) {
        this.pop();
        this.stack.addLast(new Entry(in.matrix.copy(), in.normal.copy()));
    }

    public static final class Entry {
        private final Mat4f matrix;
        private final Mat3f normal;

        private Entry(Mat4f matrix, Mat3f normal) {
            this.matrix = matrix;
            this.normal = normal;
        }

        public Mat4f getMatrix() {
            return this.matrix;
        }

        public Mat3f getNormal() {
            return this.normal;
        }

        public float[] getMatrixArray() {
            return this.matrix.toArray();
        }

        public float[] getNormalArray() {
            return new Mat4f(this.normal).toArray();
        }
    }
}

