/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.math.MathHelper;

public class Slider
extends GuiElement {
    protected String name;
    private Runnable action;
    private boolean enableDrag;
    protected float v;
    protected float steps;

    public Slider(IGui gui, String name) {
        super(gui);
        this.name = name;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int w = this.gui.textWidth(this.name);
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        this.gui.drawBox((int)((float)(this.bounds.x + 1) + this.v * (float)(this.bounds.w - 5)), this.bounds.y + 1, 3, this.bounds.h - 2, this.gui.getColors().slider_bar);
        this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
    }

    @Override
    public boolean mouseClick(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y)) {
            this.enableDrag = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseRelease(int x, int y, int btn) {
        this.enableDrag = false;
        return false;
    }

    @Override
    public boolean mouseDrag(int x, int y, int btn) {
        if (this.enableDrag) {
            this.v = (float)(x - this.bounds.x) / (float)this.bounds.w;
            if (this.steps != 0.0f) {
                this.v = (float)Math.round(this.v / this.steps) * this.steps;
            }
            this.v = (float)MathHelper.clamp(this.v, 0.0, 1.0);
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }
        return false;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public float getValue() {
        return this.v;
    }

    public void setValue(float v) {
        this.v = v;
    }

    public void setText(String name) {
        this.name = name;
    }

    public void setSteps(float steps) {
        this.steps = steps;
    }
}

