/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.util.Stack;
import java.util.function.Consumer;

public interface IGui {
    public void drawBox(int var1, int var2, int var3, int var4, int var5);

    public void drawGradientBox(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public void drawText(int var1, int var2, String var3, int var4);

    public String i18nFormat(String var1, Object ... var2);

    public int textWidth(String var1);

    public void drawTexture(int var1, int var2, int var3, int var4, int var5, int var6, String var7);

    public void drawTexture(int var1, int var2, int var3, int var4, float var5, float var6, float var7, float var8);

    public void close();

    public UIColors getColors();

    public void setCloseListener(Consumer<Runnable> var1);

    public boolean isShiftDown();

    public boolean isCtrlDown();

    public boolean isAltDown();

    public KeyCodes getKeyCodes();

    public NativeGuiComponents getNative();

    public void setClipboardText(String var1);

    public String getClipboardText();

    public Frame getFrame();

    public void setScale(int var1);

    public int getScale();

    public int getMaxScale();

    public CtxStack getStack();

    public void displayError(String var1);

    default public void drawBox(float x, float y, float w, float h, int color) {
        this.drawBox((int)x, (int)y, (int)w, (int)h, color);
    }

    default public void executeLater(Runnable r) {
        MinecraftClientAccess.get().executeLater(() -> {
            try {
                r.run();
            }
            catch (Throwable e) {
                Log.error("Exception while executing task", e);
                ErrorLog.addLog(ErrorLog.LogLevel.ERROR, "Exception while executing task", e);
            }
        });
    }

    default public void pushMatrix() {
        this.getStack().push();
    }

    default public void setPosOffset(Box box) {
        Ctx current = this.getContext();
        current.cutBox = current.cutBox.intersect(new Box(current.off.x + box.x, current.off.y + box.y, box.w, box.h));
        current.cutBox.w = Math.max(current.cutBox.w, 0);
        current.cutBox.h = Math.max(current.cutBox.h, 0);
        current.off = new Vec2i(current.off.x + box.x, current.off.y + box.y);
    }

    public void setupCut();

    default public void popMatrix() {
        this.getStack().pop();
    }

    default public Ctx getContext() {
        return this.getStack().current;
    }

    default public Vec2i getOffset() {
        return ((CtxStack)this.getStack()).current.off;
    }

    default public void drawRectangle(int x, int y, int w, int h, int color) {
        this.drawBox(x, y, w, 1, color);
        this.drawBox(x, y, 1, h, color);
        this.drawBox(x, y + h - 1, w, 1, color);
        this.drawBox(x + w - 1, y, 1, h, color);
    }

    default public void drawRectangle(float x, float y, float w, float h, int color) {
        this.drawBox(x, y, w, 1.0f, color);
        this.drawBox(x, y, 1.0f, h, color);
        this.drawBox(x, y + h - 1.0f, w, 1.0f, color);
        this.drawBox(x + w - 1.0f, y, 1.0f, h, color);
    }

    default public void onGuiException(String msg, Throwable e, boolean fatal) {
        Log.error(msg, e);
        ErrorLog.addLog(ErrorLog.LogLevel.ERROR, msg, e);
        if (fatal) {
            this.displayError(msg + ": " + e.toString());
        } else {
            Frame frm = this.getFrame();
            if (frm != null) {
                try {
                    frm.logMessage(msg + ": " + e.toString());
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                    this.onGuiException(msg, e, true);
                }
            } else {
                this.displayError(msg + "\n" + e.toString());
            }
        }
    }

    public static class CtxStack {
        private Stack<Ctx> stack;
        private Ctx current;

        public CtxStack(int w, int h) {
            this.current = new Ctx(w, h);
            this.stack = new Stack();
        }

        public void push() {
            this.stack.push(this.current);
            this.current = new Ctx(this.current);
        }

        public Ctx pop() {
            this.current = this.stack.pop();
            return this.current;
        }
    }

    public static class Ctx {
        public Vec2i off;
        public Box cutBox;

        public Ctx(Ctx old) {
            this.off = new Vec2i(old.off);
            this.cutBox = new Box(old.cutBox);
        }

        public Ctx(int w, int h) {
            this.off = new Vec2i(0, 0);
            this.cutBox = new Box(0, 0, w, h);
        }
    }
}

