/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonLexer;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\rH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0017H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\rH\u0002J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\rH\u0002J\b\u00103\u001a\u00020\u001bH\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\u0010\u00106\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J!\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:H\u0016\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020?H\u0002J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020?H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006D"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "lexer", "Lkotlinx/serialization/json/internal/JsonLexer;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/JsonLexer;)V", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "currentIndex", "", "getJson", "()Lkotlinx/serialization/json/Json;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "checkLeadingComma", "", "coerceInputValue", "", "index", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "inlineDescriptor", "decodeInt", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeListIndex", "decodeLong", "", "decodeMapIndex", "decodeNotNullMark", "decodeNull", "", "decodeObjectIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "decodeStringKey", "endStructure", "handleUnknown", "key", "kotlinx-serialization-json"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder {
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final JsonLexer lexer;
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @NotNull
    private final JsonConfiguration configuration;

    public StreamingJsonDecoder(@NotNull Json json, @NotNull WriteMode mode, @NotNull JsonLexer lexer) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        this.json = json;
        this.mode = mode;
        this.lexer = lexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.configuration = this.json.getConfiguration();
    }

    @Override
    @NotNull
    public final Json getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return PolymorphicKt.decodeSerializableValuePolymorphic(this, deserializer);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.json, descriptor2);
        this.lexer.consumeNextToken(newMode.begin);
        this.checkLeadingComma();
        WriteMode writeMode = newMode;
        int n = WhenMappings.$EnumSwitchMapping$0[writeMode.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, newMode, this.lexer);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode ? this : new StreamingJsonDecoder(this.json, newMode, this.lexer);
            }
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.lexer.consumeNextToken(this.mode.end);
    }

    @Override
    public boolean decodeNotNullMark() {
        return this.lexer.tryConsumeNotNull();
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            JsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        WriteMode writeMode = this.mode;
        int n2 = WhenMappings.$EnumSwitchMapping$0[writeMode.ordinal()];
        switch (n2) {
            case 4: {
                n = this.decodeObjectIndex(descriptor2);
                break;
            }
            case 2: {
                n = this.decodeMapIndex();
                break;
            }
            default: {
                n = this.decodeListIndex();
            }
        }
        return n;
    }

    private final int decodeMapIndex() {
        int n;
        boolean decodingKey;
        boolean hasComma = false;
        boolean bl = decodingKey = this.currentIndex % 2 != 0;
        if (decodingKey) {
            if (this.currentIndex != -1) {
                hasComma = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            Object object;
            if (decodingKey) {
                JsonLexer this_$iv;
                if (this.currentIndex == -1) {
                    object = this.lexer;
                    boolean condition$iv = !hasComma;
                    int position$iv = this_$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        JsonLexer jsonLexer = this_$iv;
                        boolean bl2 = false;
                        String string = "Unexpected trailing comma";
                        jsonLexer.fail(string, position$iv);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    this_$iv = this.lexer;
                    int position$iv = this_$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!hasComma) {
                        JsonLexer jsonLexer = this_$iv;
                        boolean bl3 = false;
                        String string = "Expected comma after the key-value pair";
                        jsonLexer.fail(string, position$iv);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            object = this;
            n = ++((StreamingJsonDecoder)object).currentIndex;
        } else {
            if (hasComma) {
                JsonLexer.fail$default(this.lexer, "Expected '}', but had ',' instead", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index) {
        void $this$tryCoerceValue$iv;
        void elementDescriptor$iv;
        Json json = this.json;
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            boolean bl = false;
            if (!this.lexer.tryConsumeNotNull()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        boolean bl = false;
        String string = this.lexer.peekString(this.configuration.isLenient());
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        boolean bl3 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int decodeObjectIndex(SerialDescriptor descriptor2) {
        boolean hasComma = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean isUnknown;
            boolean bl;
            hasComma = false;
            String key = this.decodeStringKey();
            this.lexer.consumeNextToken(':');
            int index = JsonNamesMapKt.getJsonNameIndex(descriptor2, this.json, key);
            if (index != -3) {
                if (!this.configuration.getCoerceInputValues() || !this.coerceInputValue(descriptor2, index)) return index;
                hasComma = this.lexer.tryConsumeComma();
                bl = false;
            } else {
                bl = true;
            }
            if (!(isUnknown = bl)) continue;
            hasComma = this.handleUnknown(key);
        }
        if (!hasComma) return -1;
        JsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, 2, null);
        throw new KotlinNothingValueException();
    }

    private final boolean handleUnknown(String key) {
        if (this.configuration.getIgnoreUnknownKeys()) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.failOnUnknownKey(key);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n;
        boolean hasComma = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !hasComma) {
                JsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            StreamingJsonDecoder streamingJsonDecoder = this;
            n = ++streamingJsonDecoder.currentIndex;
        } else {
            if (hasComma) {
                JsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    @Override
    public boolean decodeBoolean() {
        return this.configuration.isLenient() ? this.lexer.consumeBooleanLenient() : this.lexer.consumeBoolean();
    }

    @Override
    public byte decodeByte() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((byte)value)) {
            JsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + value + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return (byte)value;
    }

    @Override
    public short decodeShort() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((short)value)) {
            JsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + value + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return (short)value;
    }

    @Override
    public int decodeInt() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((int)value)) {
            JsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + value + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return (int)value;
    }

    @Override
    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public float decodeFloat() {
        block8: {
            block7: {
                var2_1 = this.lexer;
                expectedType$iv = "float";
                $i$f$parseString = false;
                input$iv = $this$parseString$iv.consumeStringLenient();
                try {
                    $this$decodeFloat_u24lambda_u2d5 = input$iv;
                    $i$a$-parseString-StreamingJsonDecoder$decodeFloat$result$1 = false;
                    var8_12 = $this$decodeFloat_u24lambda_u2d5;
                    var9_13 = false;
                    v0 = Float.parseFloat(var8_12);
                }
                catch (IllegalArgumentException e$iv) {
                    JsonLexer.fail$default((JsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                result = v0;
                specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
                if (specialFp) break block7;
                var3_4 = result;
                var4_5 = false;
                var5_7 = var3_4;
                var6_10 = false;
                if (Float.isInfinite(var5_7)) ** GOTO lbl-1000
                var5_7 = var3_4;
                var6_10 = false;
                if (!Float.isNaN(var5_7)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) break block8;
            }
            return result;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(result));
        throw new KotlinNothingValueException();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double decodeDouble() {
        block8: {
            block7: {
                var3_1 = this.lexer;
                expectedType$iv = "double";
                $i$f$parseString = false;
                input$iv = $this$parseString$iv.consumeStringLenient();
                try {
                    $this$decodeDouble_u24lambda_u2d6 = input$iv;
                    $i$a$-parseString-StreamingJsonDecoder$decodeDouble$result$1 = false;
                    var9_12 = $this$decodeDouble_u24lambda_u2d6;
                    var10_14 = false;
                    v0 = Double.parseDouble(var9_12);
                }
                catch (IllegalArgumentException e$iv) {
                    JsonLexer.fail$default((JsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                result = v0;
                specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
                if (specialFp) break block7;
                var4_4 = result;
                var6_7 = false;
                var7_10 = var4_4;
                var9_13 = false;
                if (Double.isInfinite(var7_10)) ** GOTO lbl-1000
                var7_10 = var4_4;
                var9_13 = false;
                if (!Double.isNaN(var7_10)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) break block8;
            }
            return result;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, result);
        throw new KotlinNothingValueException();
    }

    @Override
    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            JsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    @Override
    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter(inlineDescriptor, "inlineDescriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(inlineDescriptor) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(inlineDescriptor);
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(enumDescriptor, this.json, this.decodeString());
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            nArray[WriteMode.LIST.ordinal()] = 1;
            nArray[WriteMode.MAP.ordinal()] = 2;
            nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            nArray[WriteMode.OBJ.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

