/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\n\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a%\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\u001a?\u0010\u0016\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0011*\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00110\f2\u0006\u0010\u0018\u001a\u0002H\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\f*\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"checkKind", "", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "throwSerializerNotFound", "", "type", "", "jsonTree", "Lkotlinx/serialization/json/JsonObject;", "validateIfSealed", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "actualSerializer", "", "classDiscriminator", "decodeSerializableValuePolymorphic", "T", "Lkotlinx/serialization/json/JsonDecoder;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Lkotlinx/serialization/json/JsonEncoder;", "value", "ifPolymorphic", "Lkotlin/Function0;", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "findActualSerializer", "kotlinx-serialization-json"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer, T value, @NotNull Function0<Unit> ifPolymorphic) {
        Intrinsics.checkNotNullParameter($this$encodePolymorphically, "<this>");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, "ifPolymorphic");
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer.serialize($this$encodePolymorphically, value);
            return;
        }
        if (value == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
        }
        SerializationStrategy actualSerializer = PolymorphicKt.findActualSerializer($this$encodePolymorphically, serializer, value);
        ifPolymorphic.invoke();
        actualSerializer.serialize($this$encodePolymorphically, value);
    }

    private static final SerializationStrategy<Object> findActualSerializer(JsonEncoder $this$findActualSerializer, SerializationStrategy<Object> serializer, Object value) {
        AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer;
        SerializationStrategy<Object> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, $this$findActualSerializer, value);
        PolymorphicKt.validateIfSealed(casted, actualSerializer, $this$findActualSerializer.getJson().getConfiguration().getClassDiscriminator());
        SerialKind kind = actualSerializer.getDescriptor().getKind();
        PolymorphicKt.checkKind(kind);
        return actualSerializer;
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer, SerializationStrategy<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            String string = "Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (kind instanceof SerialKind.ENUM) {
            String string = "Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (kind instanceof PrimitiveKind) {
            String string = "Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (kind instanceof PolymorphicKind) {
            String string = "Actual serializer for polymorphic cannot be polymorphic itself";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<T> deserializer) {
        DeserializationStrategy deserializationStrategy;
        void value$iv;
        Intrinsics.checkNotNullParameter($this$decodeSerializableValuePolymorphic, "<this>");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast22 = false;
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        String discriminator = $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getClassDiscriminator();
        JsonElement $i$f$cast22 = (JsonElement)jsonTree.get((Object)discriminator);
        String type2 = $i$f$cast22 == null ? null : ((deserializationStrategy = JsonElementKt.getJsonPrimitive($i$f$cast22)) == null ? null : ((JsonPrimitive)((Object)deserializationStrategy)).getContent());
        deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull($this$decodeSerializableValuePolymorphic, type2);
        if (deserializationStrategy == null) {
            PolymorphicKt.throwSerializerNotFound(type2, jsonTree);
            throw new KotlinNothingValueException();
        }
        DeserializationStrategy actualSerializer = deserializationStrategy;
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, actualSerializer);
    }

    private static final Void throwSerializerNotFound(String type2, JsonObject jsonTree) {
        String suffix = type2 == null ? "missing class discriminator ('null')" : "class discriminator '" + type2 + '\'';
        throw JsonExceptionsKt.JsonDecodingException(-1, Intrinsics.stringPlus("Polymorphic serializer was not found for ", suffix), jsonTree.toString());
    }
}

