/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.platform.forge;

import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class NecPlatformImpl
implements NecPlatform {
    @Override
    public Map<URI, Set<CommonModMetadata>> getModsAtLocationsInDisk() {
        HashMap<URI, Set<CommonModMetadata>> modMap = new HashMap<URI, Set<CommonModMetadata>>();
        for (ModFileInfo modFile : ModList.get().getModFiles()) {
            URI modJar = modFile.getFile().getFilePath().toUri();
            for (IModInfo modInfo : modFile.getMods()) {
                modMap.computeIfAbsent(modJar, f -> new HashSet()).add(NecPlatformImpl.toCommon(modInfo));
            }
        }
        return modMap;
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public List<CommonModMetadata> getModMetadatas(String modId) {
        ModFileInfo mod = ModList.get().getModFileById(modId);
        if (mod == null) {
            return Collections.emptyList();
        }
        return mod.getMods().stream().map(NecPlatformImpl::toCommon).collect(Collectors.toList());
    }

    private static CommonModMetadata toCommon(IModInfo imod) {
        if (!(imod instanceof ModInfo)) {
            return CommonModMetadata.STUB;
        }
        ModInfo mod = (ModInfo)imod;
        URL issueUrl = mod.getOwningFile().getIssueURL();
        Object authorsObj = mod.getConfigElement(new String[]{"authors"}).orElse(null);
        List<String> authors = authorsObj instanceof String ? Collections.singletonList(authorsObj) : (List<String>)authorsObj;
        return new CommonModMetadata(mod.getModId(), mod.getDisplayName(), issueUrl == null ? null : issueUrl.toExternalForm(), authors);
    }
}

