/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium._impl.TagConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TagUtil {
    public static <T> boolean hasTag(T type, Tag<T> tag) {
        return tag.func_230235_a_(type);
    }

    public static ITagCollection<Block> getAllBlockTags(World world) {
        return world.func_205772_D().func_241835_a();
    }

    public static ITagCollection<Item> getAllItemTags(World world) {
        return world.func_205772_D().func_241836_b();
    }

    public static ITagCollection<Fluid> getAllFluidTags(World world) {
        return world.func_205772_D().func_241837_c();
    }

    public static <T> Collection<T> getAllEntries(Tag<T> ... tags) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        if (tags.length == 1) {
            return tags[0].func_230236_b_();
        }
        ArrayList list = new ArrayList();
        for (Tag<T> tag : tags) {
            list.addAll(tag.func_230236_b_());
        }
        return list;
    }

    public static <T> Collection<T> getAllEntries(Tag<T> tag) {
        return tag.func_230236_b_();
    }

    public static <T> ITag<T> getOrCreateTag(ITagCollection<T> collection, ResourceLocation resourceLocation) {
        if (collection.func_199908_a().contains(resourceLocation)) {
            return collection.func_199910_a(resourceLocation);
        }
        return collection.func_241834_b(resourceLocation);
    }

    public static ITag<Item> getItemTag(ResourceLocation resourceLocation) {
        if (ItemTags.func_199903_a().func_199908_a().contains(resourceLocation)) {
            return ItemTags.func_199903_a().func_199910_a(resourceLocation);
        }
        return ItemTags.func_199901_a((String)resourceLocation.toString());
    }

    public static ITag<Block> getBlockTag(ResourceLocation resourceLocation) {
        if (BlockTags.func_199896_a().func_199908_a().contains(resourceLocation)) {
            return BlockTags.func_199896_a().func_199910_a(resourceLocation);
        }
        return BlockTags.func_199894_a((String)resourceLocation.toString());
    }

    public static ITag<EntityType<?>> getEntityTypeTag(ResourceLocation resourceLocation) {
        if (EntityTypeTags.func_219762_a().func_199908_a().contains(resourceLocation)) {
            return EntityTypeTags.func_219762_a().func_199910_a(resourceLocation);
        }
        return EntityTypeTags.func_232896_a_((String)resourceLocation.toString());
    }

    public static ITag<Fluid> getFluidTag(ResourceLocation resourceLocation) {
        if (FluidTags.func_226157_a_().func_199908_a().contains(resourceLocation)) {
            return FluidTags.func_226157_a_().func_199910_a(resourceLocation);
        }
        return FluidTags.func_206956_a((String)resourceLocation.toString());
    }

    public static ItemStack getItemWithPreference(ITag<Item> tag) {
        if (tag.func_230236_b_().isEmpty()) {
            return ItemStack.field_190927_a;
        }
        List elements = tag.func_230236_b_();
        for (String modid : TagConfig.ITEM_PREFERENCE) {
            for (Item allElement : elements) {
                if (!allElement.getRegistryName().func_110624_b().equalsIgnoreCase(modid)) continue;
                return new ItemStack((IItemProvider)allElement);
            }
        }
        return new ItemStack((IItemProvider)elements.get(0));
    }
}

