/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material.advancedtype;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.material.IAdvancedResourceType;
import com.hrznstudio.titanium.material.ResourceMaterial;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public enum ItemAdvancedResourceType implements IAdvancedResourceType
{
    SIMPLE((material, integer) -> material.getColor(), type -> {
        JsonObject object = new JsonObject();
        object.addProperty("parent", "item/generated");
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", new ResourceLocation("titanium", "items/resource/" + type.func_176610_l()).toString());
        object.add("textures", (JsonElement)textures);
        return object;
    });

    private final BiFunction<ResourceMaterial, Integer, Integer> colorFunction;
    private final Function<IResourceType, JsonObject> jsonObjectSupplier;

    private ItemAdvancedResourceType(BiFunction<ResourceMaterial, Integer, Integer> colorFunction, Function<IResourceType, JsonObject> jsonObjectSupplier) {
        this.colorFunction = colorFunction;
        this.jsonObjectSupplier = jsonObjectSupplier;
    }

    @Override
    public int getColor(ResourceMaterial material, int tintIndex) {
        return this.colorFunction.apply(material, tintIndex);
    }

    @Override
    public JsonObject generate(IResourceType type) {
        return this.jsonObjectSupplier.apply(type);
    }
}

