/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.actions;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.jeitweaker.JEIManager;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class ActionHideRegex
implements IUndoableAction {
    private List<MCItemStackMutable> collectedStacks;
    private final String regex;

    public ActionHideRegex(String regex) {
        this.regex = regex;
    }

    public void apply() {
        Pattern compile = Pattern.compile(this.regex);
        this.collectedStacks = ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> compile.matcher(((RegistryKey)entry.getKey()).func_240901_a_().toString()).matches()).map(registryKeyItemEntry -> new ItemStack((IItemProvider)registryKeyItemEntry.getValue())).filter(itemStack -> !itemStack.func_190926_b()).map(MCItemStackMutable::new).collect(Collectors.toList());
        JEIManager.HIDDEN_ITEMS.addAll(this.collectedStacks);
    }

    public void undo() {
        this.collectedStacks.forEach(JEIManager.HIDDEN_ITEMS::remove);
    }

    public String describeUndo() {
        return "Undoing JEI hiding all Items from Mod: " + this.regex;
    }

    public String describe() {
        return "JEI Hiding all Items from by Regex: " + this.regex;
    }

    public boolean shouldApplyOn(LogicalSide side) {
        return !CraftTweakerAPI.isServer();
    }
}

