/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.io;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ConfigLoader {
    public static ConfigHolder loadConfigFromFileForDimension(String dimensionName) {
        String fileName = "DIM_" + dimensionName.replace(':', '-') + ".toml";
        File configFile = new File(BetterCaves.customConfigDir, fileName);
        if (!configFile.exists() || configFile.isDirectory()) {
            BetterCaves.LOGGER.info(String.format("Better Caves config file for dimension %s not found. Using global config...", dimensionName));
            return new ConfigHolder();
        }
        if (!configFile.canRead()) {
            BetterCaves.LOGGER.warn(String.format("Better Caves config file for dimension %s not readable. Using global config...", dimensionName));
            return new ConfigHolder();
        }
        BetterCaves.LOGGER.info(String.format("Reading Better Caves config from file for dimension %s...", dimensionName));
        return ConfigLoader.parseConfigFromFile(configFile);
    }

    private static ConfigHolder parseConfigFromFile(File file) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((File)file).sync().preserveInsertionOrder().build();
        try {
            configData.load();
        }
        catch (Exception e) {
            BetterCaves.LOGGER.error(String.format("ERROR - Failed to parse Better Caves config for file %s", file.getName()));
            BetterCaves.LOGGER.error(String.format("RECEIVED ERROR %s", e));
            BetterCaves.LOGGER.info("USING GLOBAL CONFIG FILE INSTEAD...");
            return new ConfigHolder();
        }
        if (configData.valueMap().size() == 0) {
            return new ConfigHolder();
        }
        if (configData.valueMap().size() != 1 || configData.valueMap().get("Better Caves") == null) {
            BetterCaves.LOGGER.error(String.format("ERROR - Invalid Better Caves config file %s", file.getName()));
            BetterCaves.LOGGER.error("Is there only one topmost category level, called \"Better Caves\"?");
            BetterCaves.LOGGER.info("USING GLOBAL CONFIG FILE INSTEAD...");
            return new ConfigHolder();
        }
        Map<String, Object> pathMap = ConfigLoader.configToMap((AbstractConfig)configData.valueMap().get("Better Caves"));
        configData.close();
        ConfigHolder config = new ConfigHolder();
        for (Map.Entry<String, Object> entry : pathMap.entrySet()) {
            String fullName = entry.getKey();
            Object value = entry.getValue();
            ConfigHolder.ConfigOption<?> configOption = config.properties.get(fullName);
            if (configOption == null) {
                BetterCaves.LOGGER.error(String.format("ERROR: INVALID PROPERTY %s in config %s. Skipping...", fullName, file.getName()));
                continue;
            }
            Class<?> type = configOption.getType();
            if ((type == Double.TYPE || type == Double.class) && value.getClass() == Integer.class) {
                configOption.set(((Integer)value).doubleValue());
                BetterCaves.LOGGER.debug(String.format("%s: overriding config option: %s", file.getName(), fullName));
                continue;
            }
            if (type != value.getClass()) {
                BetterCaves.LOGGER.error(String.format("ERROR: WRONG TYPE for %s in config %s. Skipping...", fullName, file.getName()));
                continue;
            }
            configOption.set(value);
            BetterCaves.LOGGER.debug(String.format("%s: overriding config option: %s", file.getName(), fullName));
        }
        return config;
    }

    private static Map<String, Object> configToMap(AbstractConfig config) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>();
        ConfigLoader.fillPathMap(config, pathMap, "Better Caves");
        return pathMap;
    }

    private static void fillPathMap(AbstractConfig config, Map<String, Object> pathMap, String currPath) {
        if (config == null) {
            return;
        }
        Map configMap = (Map)ObfuscationReflectionHelper.getPrivateValue(AbstractConfig.class, (Object)config, (String)"map");
        if (configMap.size() == 0) {
            return;
        }
        for (Map.Entry entry : configMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String path = currPath + "." + key;
            if (value instanceof AbstractConfig) {
                ConfigLoader.fillPathMap((AbstractConfig)value, pathMap, path);
                continue;
            }
            pathMap.put(path, value);
        }
    }
}

