/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;
import team.chisel.common.item.ChiselMode;
import team.chisel.common.util.NBTUtil;

public class PacketChiselMode {
    private final int slot;
    @Nonnull
    private final IChiselMode mode;

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.slot);
        buf.func_211400_a(this.mode.name(), 256);
    }

    public static PacketChiselMode decode(PacketBuffer buf) {
        int slot = buf.readInt();
        IChiselMode mode = CarvingUtils.getModeRegistry().getModeByName(buf.func_150789_c(256));
        if (mode == null) {
            mode = ChiselMode.SINGLE;
        }
        return new PacketChiselMode(slot, mode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ((NetworkEvent.Context)ctx.get()).getSender().field_71071_by.func_70301_a(this.slot);
            if (stack.func_77973_b() instanceof IChiselItem && ((IChiselItem)stack.func_77973_b()).supportsMode((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), stack, this.mode)) {
                NBTUtil.setChiselMode(stack, this.mode);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public PacketChiselMode(int slot, @Nonnull IChiselMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.slot = slot;
        this.mode = mode;
    }
}

