/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.network.MessageIrrigationNeighbourUpdate;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.block.tile.TileEntityDynamicTexture;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class TileEntityIrrigationComponent
extends TileEntityDynamicTexture
implements ITickableTileEntity {
    public static final float NETHER_DRAIN_FRACTION = 0.01f;
    private final int capacity;
    private final float minLevel;
    private final float maxLevel;
    private int contentBuffer;
    private float levelBuffer;
    private float prevLevel;
    private final TileEntityBase.AutoSyncedField<Integer> content;
    private final TileEntityBase.AutoSyncedField<Float> level;
    private final NeighbourCache neighbours;

    public TileEntityIrrigationComponent(TileEntityType<?> type, int capacity, float minLevel, float maxLevel) {
        super(type);
        this.capacity = capacity;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.content = this.getAutoSyncedFieldBuilder(0).withCallBack(this::setContentBuffer).build();
        this.level = this.getAutoSyncedFieldBuilder(this.minLevel).withCallBack(this::setLevelBuffer).build();
        this.neighbours = new NeighbourCache(this);
    }

    public final void func_73660_a() {
        this.prevLevel = this.levelBuffer;
        if (this.getContent() > 0) {
            this.balanceWithNeighbours();
            this.runNetherLogic();
        }
        this.tickComponent();
    }

    protected abstract void tickComponent();

    protected void balanceWithNeighbours() {
        this.neighbours.streamNeighbours(true).forEach(component -> {
            float y_b;
            float y_a = this.getLevel();
            if (y_a > (y_b = component.getLevel())) {
                float y_a1;
                float v;
                float f_a = this.getSurfaceFactor();
                float f_b = component.getSurfaceFactor();
                float dv = f_b * (v = (y_a - Math.max(y_b, y_a1 = this.getMinLevel())) * this.getSurfaceFactor()) / (f_a + f_b);
                if (dv > 0.0f) {
                    int transfer = (int)dv;
                    transfer = Math.min(transfer, this.getContent());
                    transfer = Math.min(transfer, component.getCapacity() - component.getContent());
                    transfer = component.pushWater(transfer, true);
                    this.drainWater(transfer, true);
                }
            }
        });
    }

    protected void runNetherLogic() {
        if (this.func_145831_w() != null && this.func_145831_w().func_230315_m_().func_236040_e_()) {
            this.drainWater(Math.max(1, (int)(this.getNetherEvaporationRate() * (float)this.getCapacity())), true);
            if (this.func_145831_w() instanceof ServerWorld && this.func_145831_w().func_201674_k().nextDouble() <= 0.2) {
                double x = (double)this.func_174877_v().func_177958_n() + 0.5 * (this.func_145831_w().func_201674_k().nextDouble() - 0.5);
                double y = this.getLevel();
                double z = (double)this.func_174877_v().func_177952_p() + 0.5 * (this.func_145831_w().func_201674_k().nextDouble() - 0.5);
                ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197613_f, x, y, z, 1, 0.0, 0.15, 0.0, 1.0);
                this.func_145831_w().func_184133_a(AgriCraft.instance.getClientPlayer(), this.func_174877_v(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.func_145831_w().func_201674_k().nextFloat() - this.func_145831_w().func_201674_k().nextFloat()) * 0.8f);
            }
        }
    }

    protected float getNetherEvaporationRate() {
        return 0.01f;
    }

    public int getContent() {
        return this.contentBuffer;
    }

    public float getLevel() {
        return this.levelBuffer + (float)this.func_174877_v().func_177956_o();
    }

    public float getRenderLevel(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLevel, (float)this.levelBuffer) + (float)this.func_174877_v().func_177956_o();
    }

    public int pushWater(int max, boolean execute) {
        int fill = Math.min(this.getCapacity() - this.getContent(), max);
        if (execute) {
            this.setContent(this.getContent() + fill);
        }
        return fill;
    }

    public int drainWater(int max, boolean execute) {
        int drain = Math.min(this.getContent(), max);
        if (execute) {
            this.setContent(this.getContent() - drain);
        }
        return drain;
    }

    protected void setContent(int content) {
        this.contentBuffer = Math.max(0, Math.min(this.getCapacity(), content));
        this.levelBuffer = this.calculateHeight(this.contentBuffer);
        this.checkAndSyncIfNeeded();
    }

    private void setContentBuffer(int contents) {
        this.contentBuffer = contents;
    }

    protected void setLevel(float level) {
        this.levelBuffer = Math.max(this.getMinLevel(), Math.min(this.getMaxLevel(), level)) - (float)this.func_174877_v().func_177956_o();
        this.contentBuffer = this.calculateContents(this.levelBuffer);
        this.checkAndSyncIfNeeded();
    }

    private void setLevelBuffer(float level) {
        this.levelBuffer = level;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public float getMinLevel() {
        return this.minLevel + (float)this.func_174877_v().func_177956_o();
    }

    public float getMaxLevel() {
        return this.maxLevel + (float)this.func_174877_v().func_177956_o();
    }

    public float getSurfaceFactor() {
        return (float)this.getCapacity() / (this.getMaxLevel() - this.getMinLevel());
    }

    protected int calculateContents(float height) {
        return (int)((float)this.getCapacity() * (height + (float)this.func_174877_v().func_177956_o() - this.getMinLevel()) / (this.getMaxLevel() - this.getMinLevel()));
    }

    protected float calculateHeight(int contents) {
        return this.getMinLevel() - (float)this.func_174877_v().func_177956_o() + ((float)contents + 0.0f) * (this.getMaxLevel() - this.getMinLevel()) / ((float)this.getCapacity() + 0.0f);
    }

    protected void onNeighbourUpdate(BlockPos pos) {
        Arrays.stream(Direction.values()).filter(dir -> dir.func_176740_k().func_176722_c()).filter(dir -> this.func_174877_v().func_177972_a(dir).equals((Object)pos)).forEach(this::onNeighbourUpdate);
    }

    public void onNeighbourUpdate(Direction dir) {
        this.neighbours.onNeighbourUpdate(dir);
        if (this.func_145831_w() != null && !this.func_145831_w().func_201670_d()) {
            new MessageIrrigationNeighbourUpdate(this.func_174877_v(), dir).sendToDimension(this.func_145831_w());
        }
    }

    protected void checkAndSyncIfNeeded() {
        boolean content;
        boolean level = Math.abs(this.levelBuffer - ((Float)this.level.get()).floatValue()) >= (this.getMaxLevel() - this.getMinLevel()) / (float)this.getLevelIntervalCount();
        boolean bl = content = (float)Math.abs(this.contentBuffer - (Integer)this.content.get()) >= this.getContentDeltaFraction() * (float)this.getCapacity();
        if (content || level) {
            this.content.set((Object)this.contentBuffer);
            this.level.set((Object)Float.valueOf(this.levelBuffer));
        }
    }

    @Nullable
    public TileEntityIrrigationComponent getNeighbour(Direction direction) {
        return this.neighbours.getNeighbour(direction);
    }

    protected abstract boolean canConnect(TileEntityIrrigationComponent var1);

    protected abstract boolean canTransfer(TileEntityIrrigationComponent var1, Direction var2);

    protected abstract int getLevelIntervalCount();

    protected abstract float getContentDeltaFraction();

    protected final void writeTileNBT(@Nonnull CompoundNBT tag) {
        tag.func_74768_a("agri_connections", this.contentBuffer);
        tag.func_74776_a("agri_level", this.levelBuffer);
        this.writeComponentNBT(tag);
    }

    protected final void readTileNBT(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
        this.contentBuffer = tag.func_74762_e("agri_connections");
        this.levelBuffer = tag.func_74760_g("agri_level");
        this.readComponentNBT(state, tag);
    }

    protected void writeComponentNBT(@Nonnull CompoundNBT tag) {
    }

    protected void readComponentNBT(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
    }

    public String describeNeighbour(Direction direction) {
        TileEntityIrrigationComponent component = this.getNeighbour(direction);
        return component == null ? "none" : component.description();
    }

    protected abstract String description();

    private static class Neighbour {
        private final NeighbourCache cache;
        private final Direction dir;
        private TileEntityIrrigationComponent neighbour;
        private boolean needsUpdating;

        public Neighbour(NeighbourCache cache, Direction dir) {
            this.cache = cache;
            this.dir = dir;
            this.needsUpdating = true;
        }

        public TileEntityIrrigationComponent getComponent() {
            return this.cache.getComponent();
        }

        public Direction getDirection() {
            return this.dir;
        }

        public boolean needsUpdate() {
            return this.needsUpdating;
        }

        @Nullable
        public TileEntityIrrigationComponent getNeighbour() {
            return this.updateIfNecessary().neighbour;
        }

        public boolean canTransfer() {
            TileEntityIrrigationComponent neighbour = this.getNeighbour();
            if (neighbour == null) {
                return false;
            }
            return this.getComponent().canTransfer(neighbour, this.getDirection()) && neighbour.canTransfer(this.getComponent(), this.getDirection().func_176734_d());
        }

        protected Neighbour updateIfNecessary() {
            World world;
            if (this.needsUpdate() && (world = this.getComponent().func_145831_w()) != null) {
                TileEntity tile = world.func_175625_s(this.getComponent().func_174877_v().func_177972_a(this.getDirection()));
                if (tile instanceof TileEntityIrrigationComponent) {
                    TileEntityIrrigationComponent neighbour = (TileEntityIrrigationComponent)tile;
                    this.neighbour = this.getComponent().canConnect(neighbour) ? neighbour : null;
                } else {
                    this.neighbour = null;
                }
                this.needsUpdating = false;
            }
            return this;
        }

        public void clear() {
            this.neighbour = null;
            this.needsUpdating = true;
        }
    }

    private static class NeighbourCache {
        private final TileEntityIrrigationComponent component;
        private final EnumMap<Direction, Neighbour> neighbours;

        public NeighbourCache(TileEntityIrrigationComponent component) {
            this.component = component;
            this.neighbours = Maps.newEnumMap(Direction.class);
            Arrays.stream(Direction.values()).filter(dir -> dir.func_176740_k().func_176722_c()).forEach(dir -> this.neighbours.put((Direction)dir, new Neighbour(this, (Direction)dir)));
        }

        public TileEntityIrrigationComponent getComponent() {
            return this.component;
        }

        @Nullable
        public TileEntityIrrigationComponent getNeighbour(Direction dir) {
            return this.neighbours.containsKey(dir) ? this.neighbours.get(dir).getNeighbour() : null;
        }

        public void onNeighbourUpdate(Direction dir) {
            if (dir.func_176740_k().func_176722_c()) {
                this.neighbours.get(dir).clear();
            }
        }

        public Stream<TileEntityIrrigationComponent> streamComponents() {
            return Stream.concat(Stream.of(this.getComponent()), this.streamNeighbours());
        }

        public Stream<TileEntityIrrigationComponent> streamNeighbours() {
            return this.streamNeighbours(false);
        }

        public Stream<TileEntityIrrigationComponent> streamNeighbours(boolean transfer) {
            return this.neighbours.values().stream().filter(neighbour -> !transfer || neighbour.canTransfer()).map(Neighbour::getNeighbour).filter(Objects::nonNull);
        }
    }
}

