/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1;

import com.infinityraider.agricraft.api.v1.AgriApiConnectorFake;
import com.infinityraider.agricraft.api.v1.AgriApiState;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.config.IAgriConfig;
import com.infinityraider.agricraft.api.v1.content.IAgriContent;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationHandler;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.AgriPlantIngredient;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowthRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlantRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeedRegistry;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import com.infinityraider.agricraft.api.v1.requirement.AnySoilIngredient;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.requirement.IDefaultGrowConditionFactory;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public interface IAgriApiConnector {
    public static final IAgriApiConnector FAKE = new AgriApiConnectorFake();

    @Nonnull
    public AgriApiState getState();

    @Nonnull
    public IAgriContent connectAgriContent();

    @Nonnull
    public IAgriConfig connectAgriConfig();

    @Nonnull
    public IAgriPlantRegistry connectPlantRegistry();

    @Nonnull
    public IAgriGrowthRegistry connectGrowthStageRegistry();

    @Nonnull
    public IAgriWeedRegistry connectWeedRegistry();

    @Nonnull
    public IAgriMutationRegistry connectMutationRegistry();

    @Nonnull
    public IAgriGeneRegistry connectGeneRegistry();

    @Nonnull
    public IAgriStatRegistry connectStatRegistry();

    @Nonnull
    public IAgriSoilRegistry connectSoilRegistry();

    @Nonnull
    public IAgriAdapterizer<IAgriGenome> connectGenomeAdapterizer();

    @Nonnull
    public IAgriAdapterizer<IAgriFertilizer> connectFertilizerRegistry();

    @Nonnull
    public IAgriSeasonLogic connectSeasonLogic();

    @Nonnull
    public ItemStack plantToSeedStack(IAgriPlant var1, int var2);

    @Nonnull
    public IIngredientSerializer<AgriPlantIngredient> connectPlantIngredientSerializer();

    @Nonnull
    public IIngredientSerializer<AnySoilIngredient> connectAnySoilIngredientSerializer();

    @Nonnull
    public Optional<IAgriCrop> getCrop(IBlockReader var1, BlockPos var2);

    @Nonnull
    public Optional<IAgriSoil> getSoil(IBlockReader var1, BlockPos var2);

    @Nonnull
    public Optional<IAgriFertilizer> getFertilizer(ItemStack var1);

    @Nonnull
    public ItemStack attemptConversionToAgriSeed(ItemStack var1);

    public void registerVanillaPlantingOverrideException(Item var1);

    public <T extends TileEntity, C extends IAgriCrop> void registerCapabilityCropInstance(CropCapability.Instance<T, C> var1);

    @Nonnull
    public IAgriGrowthRequirement.Builder getGrowthRequirementBuilder();

    @Nonnull
    public IDefaultGrowConditionFactory getDefaultGrowConditionFactory();

    @Nonnull
    public List<IAgriGrowthStage> getDefaultGrowthStages(int var1);

    @Nonnull
    public IAgriMutationHandler getAgriMutationHandler();

    @Nonnull
    public IAgriGenome.Builder getAgriGenomeBuilder(@Nonnull IAgriPlant var1);

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public IAgriPlantQuadGenerator getPlantQuadGenerator();

    @Nonnull
    public Optional<IJsonPlantCallback> getJsonPlantCallback(String var1);

    public boolean registerJsonPlantCallback(@Nonnull IJsonPlantCallback var1);

    public boolean isObservingWithMagnifyingGlass(PlayerEntity var1);
}

