/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.module;

import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.BlackHoleControllerBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleUnitBlock;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBlinkingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBouncingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDetectorUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDroppingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorExtractionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorInsertionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorSplittingUpgrade;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterFluidType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterItemType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterWorldType;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.item.ItemConveyorUpgrade;
import com.buuz135.industrial.item.ItemTransporterType;
import com.buuz135.industrial.module.IModule;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.client.model.ConveyorBlockModel;
import com.buuz135.industrial.proxy.client.model.TransporterBlockModel;
import com.google.common.collect.ImmutableMap;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.Feature;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModuleTransportStorage
implements IModule {
    public static AdvancedTitaniumTab TAB_TRANSPORT = new AdvancedTitaniumTab("industrialforegoing_transport", true);
    public static ConveyorUpgradeFactory upgrade_extraction = new ConveyorExtractionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_insertion = new ConveyorInsertionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_detector = new ConveyorDetectorUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_bouncing = new ConveyorBouncingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_dropping = new ConveyorDroppingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_blinking = new ConveyorBlinkingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_splitting = new ConveyorSplittingUpgrade.Factory();
    public static ConveyorBlock CONVEYOR = new ConveyorBlock((ItemGroup)TAB_TRANSPORT);
    public static HashMap<ResourceLocation, IBakedModel> CONVEYOR_UPGRADES_CACHE = new HashMap();
    public static BlackHoleUnitBlock BLACK_HOLE_UNIT_COMMON = new BlackHoleUnitBlock(Rarity.COMMON);
    public static BlackHoleUnitBlock BLACK_HOLE_UNIT_PITY = new BlackHoleUnitBlock(ModuleCore.PITY_RARITY);
    public static BlackHoleUnitBlock BLACK_HOLE_UNIT_SIMPLE = new BlackHoleUnitBlock(ModuleCore.SIMPLE_RARITY);
    public static BlackHoleUnitBlock BLACK_HOLE_UNIT_ADVANCED = new BlackHoleUnitBlock(ModuleCore.ADVANCED_RARITY);
    public static BlackHoleUnitBlock BLACK_HOLE_UNIT_SUPREME = new BlackHoleUnitBlock(ModuleCore.SUPREME_RARITY);
    public static BlackHoleTankBlock BLACK_HOLE_TANK_COMMON = new BlackHoleTankBlock(Rarity.COMMON);
    public static BlackHoleTankBlock BLACK_HOLE_TANK_PITY = new BlackHoleTankBlock(ModuleCore.PITY_RARITY);
    public static BlackHoleTankBlock BLACK_HOLE_TANK_SIMPLE = new BlackHoleTankBlock(ModuleCore.SIMPLE_RARITY);
    public static BlackHoleTankBlock BLACK_HOLE_TANK_ADVANCED = new BlackHoleTankBlock(ModuleCore.ADVANCED_RARITY);
    public static BlackHoleTankBlock BLACK_HOLE_TANK_SUPREME = new BlackHoleTankBlock(ModuleCore.SUPREME_RARITY);
    public static BlackHoleControllerBlock BLACK_HOLE_CONTROLLER = new BlackHoleControllerBlock();
    public static TransporterTypeFactory ITEM_TRANSPORTER = new TransporterItemType.Factory();
    public static TransporterTypeFactory FLUID_TRANSPORTER = new TransporterFluidType.Factory();
    public static TransporterTypeFactory WORLD_TRANSPORTER = new TransporterWorldType.Factory();
    public static TransporterBlock TRANSPORTER = new TransporterBlock((ItemGroup)TAB_TRANSPORT);
    public static HashMap<ResourceLocation, IBakedModel> TRANSPORTER_CACHE = new HashMap();

    @Override
    public List<Feature.Builder> generateFeatures() {
        TAB_TRANSPORT.addIconStack(new ItemStack((IItemProvider)CONVEYOR));
        ArrayList<Feature.Builder> features = new ArrayList<Feature.Builder>();
        features.add(Feature.builder((String)"conveyor").content(Block.class, (IForgeRegistryEntry)CONVEYOR).content(ContainerType.class, (IForgeRegistryEntry)((ContainerType)IForgeContainerType.create(ContainerConveyor::new).setRegistryName(new ResourceLocation("industrialforegoing", "conveyor")))).eventClient(() -> () -> EventManager.mod(FMLClientSetupEvent.class).process(this::onClientSetupConveyor)));
        Feature.Builder builder = Feature.builder((String)"conveyor_upgrades").eventClient(() -> () -> EventManager.mod(ModelBakeEvent.class).process(this::conveyorBake)).eventClient(() -> () -> EventManager.mod(TextureStitchEvent.Pre.class).process(this::textureStitch));
        ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> builder.content(Item.class, (IForgeRegistryEntry)new ItemConveyorUpgrade((ConveyorUpgradeFactory)((Object)conveyorUpgradeFactory), (ItemGroup)TAB_TRANSPORT)));
        features.add(builder);
        features.add(Feature.builder((String)"black_hole_units").content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_UNIT_COMMON).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_UNIT_PITY).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_UNIT_SIMPLE).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_UNIT_ADVANCED).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_UNIT_SUPREME));
        features.add(Feature.builder((String)"black_hole_tanks").content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_TANK_COMMON).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_TANK_PITY).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_TANK_SIMPLE).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_TANK_ADVANCED).content(Block.class, (IForgeRegistryEntry)BLACK_HOLE_TANK_SUPREME));
        features.add(this.createFeature((ForgeRegistryEntry)BLACK_HOLE_CONTROLLER));
        Feature.Builder transporters = Feature.builder((String)"transporters").content(Block.class, (IForgeRegistryEntry)TRANSPORTER).eventClient(() -> () -> EventManager.mod(ModelBakeEvent.class).process(this::transporterBake)).eventClient(() -> () -> EventManager.mod(TextureStitchEvent.Pre.class).process(this::transporterTextureStitch)).content(ContainerType.class, (IForgeRegistryEntry)((ContainerType)IForgeContainerType.create(ContainerTransporter::new).setRegistryName(new ResourceLocation("industrialforegoing", "transporter")))).eventClient(() -> () -> EventManager.mod(FMLClientSetupEvent.class).process(this::onClientSetupTransporter));
        TransporterTypeFactory.FACTORIES.forEach(transporterTypeFactory -> builder.content(Item.class, (IForgeRegistryEntry)new ItemTransporterType((TransporterTypeFactory)((Object)transporterTypeFactory), (ItemGroup)TAB_TRANSPORT)));
        features.add(transporters);
        return features;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void conveyorBake(ModelBakeEvent event) {
        for (ResourceLocation resourceLocation : event.getModelRegistry().keySet()) {
            if (!resourceLocation.func_110624_b().equals("industrialforegoing") || !resourceLocation.func_110623_a().contains("conveyor") || resourceLocation.func_110623_a().contains("upgrade")) continue;
            event.getModelRegistry().put(resourceLocation, new ConveyorBlockModel((IBakedModel)event.getModelRegistry().get(resourceLocation)));
        }
        for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
            for (Direction upgradeFacing : conveyorUpgradeFactory.getValidFacings()) {
                for (Direction conveyorFacing : ConveyorBlock.FACING.func_177700_c()) {
                    try {
                        ResourceLocation resourceLocation = conveyorUpgradeFactory.getModel(upgradeFacing, conveyorFacing);
                        IUnbakedModel unbakedModel = event.getModelLoader().func_209597_a(resourceLocation);
                        CONVEYOR_UPGRADES_CACHE.put(resourceLocation, unbakedModel.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)new SimpleModelTransform(ImmutableMap.of()), resourceLocation));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void textureStitch(TextureStitchEvent.Pre pre) {
        if (pre.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> conveyorUpgradeFactory.getTextures().forEach(arg_0 -> ((TextureStitchEvent.Pre)pre).addSprite(arg_0)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void transporterBake(ModelBakeEvent event) {
        for (ResourceLocation resourceLocation : event.getModelRegistry().keySet()) {
            if (!resourceLocation.func_110624_b().equals("industrialforegoing") || !resourceLocation.func_110623_a().contains("transporter") || resourceLocation.func_110623_a().contains("transporters/") || resourceLocation.func_110623_a().contains("type")) continue;
            event.getModelRegistry().put(resourceLocation, new TransporterBlockModel((IBakedModel)event.getModelRegistry().get(resourceLocation)));
        }
        for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
            String itemRL = "industrialforegoing:" + transporterTypeFactory.getRegistryName().func_110623_a() + "_transporter_type#inventory";
            for (Direction upgradeFacing : transporterTypeFactory.getValidFacings()) {
                for (TransporterTypeFactory.TransporterAction actions : TransporterTypeFactory.TransporterAction.values()) {
                    try {
                        ResourceLocation resourceLocation = transporterTypeFactory.getModel(upgradeFacing, actions);
                        IUnbakedModel unbakedModel = event.getModelLoader().func_209597_a(resourceLocation);
                        TRANSPORTER_CACHE.put(resourceLocation, unbakedModel.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)new SimpleModelTransform(ImmutableMap.of()), resourceLocation));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (ResourceLocation resourceLocation : event.getModelRegistry().keySet()) {
                if (!resourceLocation.func_110624_b().equals("industrialforegoing") || !resourceLocation.toString().equals(itemRL)) continue;
                event.getModelRegistry().put(resourceLocation, TRANSPORTER_CACHE.get(transporterTypeFactory.getItemModel()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void transporterTextureStitch(TextureStitchEvent.Pre pre) {
        if (pre.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            TransporterTypeFactory.FACTORIES.forEach(transporterTypeFactory -> transporterTypeFactory.getTextures().forEach(arg_0 -> ((TextureStitchEvent.Pre)pre).addSprite(arg_0)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetupConveyor(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ContainerConveyor.TYPE, GuiConveyor::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetupTransporter(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ContainerTransporter.TYPE, GuiTransporter::new);
    }
}

