/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;

public class ConveyorInsertionUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTHBB = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)-0.125, (double)0.875, (double)0.5625, (double)0.125);
    public static VoxelShape SOUTHBB = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.5625, (double)1.125);
    public static VoxelShape EASTBB = VoxelShapes.func_197873_a((double)0.875, (double)0.0, (double)0.125, (double)1.125, (double)0.5625, (double)0.875);
    public static VoxelShape WESTBB = VoxelShapes.func_197873_a((double)-0.125, (double)0.0, (double)0.125, (double)0.125, (double)0.5625, (double)0.875);
    public static VoxelShape NORTHBB_BIG = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)-0.125, (double)0.875, (double)0.5625, (double)0.875);
    public static VoxelShape SOUTHBB_BIG = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5625, (double)1.125);
    public static VoxelShape EASTBB_BIG = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)1.125, (double)0.5625, (double)0.875);
    public static VoxelShape WESTBB_BIG = VoxelShapes.func_197873_a((double)-0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5625, (double)0.875);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private boolean fullArea = false;

    public ConveyorInsertionUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (entity instanceof ItemEntity) {
            this.getHandlerCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                if (this.getWorkingBox().func_197752_a().func_186670_a(this.getPos()).func_186662_g(0.01).func_72326_a(entity.func_174813_aQ())) {
                    if (this.whitelist != this.filter.matches((Entity)((ItemEntity)entity))) {
                        return;
                    }
                    ItemStack stack = ((ItemEntity)entity).func_92059_d();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if ((stack = handler.insertItem(i, stack, false)).func_190926_b()) {
                            ((ItemEntity)entity).func_92058_a(ItemStack.field_190927_a);
                            entity.func_70106_y();
                            break;
                        }
                        ((ItemEntity)entity).func_92058_a(stack);
                    }
                }
            });
        }
    }

    @Override
    public void update() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getWorld().func_82737_E() % 2L == 0L && this.getContainer() instanceof ConveyorTile) {
            FluidTank tank = ((ConveyorTile)this.getContainer()).getTank();
            this.getHandlerCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(arg_0 -> this.lambda$update$1((IFluidTank)tank, arg_0));
        }
    }

    private <T> LazyOptional<T> getHandlerCapability(Capability<T> capability) {
        BlockPos offsetPos = this.getPos().func_177972_a(this.getSide());
        TileEntity tile = this.getWorld().func_175625_s(offsetPos);
        if (tile != null && tile.getCapability(capability, this.getSide().func_176734_d()).isPresent()) {
            return tile.getCapability(capability, this.getSide().func_176734_d());
        }
        Iterator iterator = this.getWorld().func_217357_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(offsetPos)).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            if (!entity.getCapability(capability, (entity = (Entity)iterator.next()) instanceof ServerPlayerEntity ? null : this.getSide().func_176734_d()).isPresent()) continue;
            return entity.getCapability(capability, entity instanceof ServerPlayerEntity ? null : this.getSide().func_176734_d());
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT() == null ? new CompoundNBT() : super.serializeNBT();
        compound.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        compound.func_74757_a("FullArea", this.fullArea);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
        this.fullArea = nbt.func_74767_n("FullArea");
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    private VoxelShape getWorkingBox() {
        if (!this.fullArea) {
            return this.getBoundingBox();
        }
        switch (this.getSide()) {
            default: {
                return NORTHBB_BIG;
            }
            case SOUTH: {
                return SOUTHBB_BIG;
            }
            case EAST: {
                return EASTBB_BIG;
            }
            case WEST: 
        }
        return WESTBB_BIG;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.func_199557_a((CompoundNBT)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.fullArea = !this.fullArea;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorInsertionUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorInsertionUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 55, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 39, 214, new String[]{"insert_near"}), new StateButtonInfo(1, res, 58, 214, new String[]{"insert_all"})}){

            @Override
            public int getState() {
                return ConveyorInsertionUpgrade.this.fullArea ? 1 : 0;
            }
        });
    }

    private /* synthetic */ void lambda$update$1(IFluidTank tank, IFluidHandler fluidHandler) {
        FluidStack drain;
        if (!tank.drain(50, IFluidHandler.FluidAction.SIMULATE).isEmpty() && fluidHandler.fill(tank.drain(50, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0 && this.whitelist == this.filter.matches(tank.drain(50, IFluidHandler.FluidAction.SIMULATE)) && !(drain = tank.drain(fluidHandler.fill(tank.drain(50, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drain.getAmount() > 0) {
            this.getContainer().requestFluidSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("insertion");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorInsertionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_inserter_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_insertion_upgrade");
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem()).func_200472_a("IPI").func_200472_a("IDI").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150438_bZ).func_200462_a(Character.valueOf('C'), (IItemProvider)ModuleTransportStorage.CONVEYOR).func_200464_a(consumer);
        }
    }
}

