/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.capability.tile.BigEnergyHandler;
import com.buuz135.industrial.config.machine.agriculturehusbandry.MobDuplicatorConfig;
import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MobDuplicatorTile
extends IndustrialAreaWorkingTile<MobDuplicatorTile> {
    private int maxProgress;
    private int powerPerOperation;
    private boolean exactCopy;
    @Save
    private SidedFluidTankComponent<MobDuplicatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", MobDuplicatorConfig.tankSize, 43, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207185_a(IndustrialTags.Fluids.EXPERIENCE));
    @Save
    private SidedInventoryComponent<MobDuplicatorTile> input;

    public MobDuplicatorTile() {
        super(ModuleAgricultureHusbandry.MOB_DUPLICATOR, RangeManager.RangeType.TOP_UP, true, MobDuplicatorConfig.powerPerOperation);
        this.addTank(this.tank);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("mob_imprisonment_tool", 64, 22, 1, 1).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> itemStack.func_77973_b().equals((Object)ModuleTool.MOB_IMPRISONMENT_TOOL)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.maxProgress = MobDuplicatorConfig.maxProgress;
        this.powerPerOperation = MobDuplicatorConfig.powerPerOperation;
        this.exactCopy = MobDuplicatorConfig.exactCopy;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.input.getStackInSlot(0).func_190926_b() || !this.hasEnergy(MobDuplicatorConfig.powerPerOperation)) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        if (this.tank.getFluid().isEmpty()) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        ItemStack stack = this.input.getStackInSlot(0);
        LivingEntity entity = (LivingEntity)((MobImprisonmentToolItem)stack.func_77973_b()).getEntityFromStack(stack, this.field_145850_b, MobDuplicatorConfig.exactCopy && this.exactCopy);
        if (entity == null) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        List entityAmount = this.field_145850_b.func_217357_a(entity.getClass(), this.getWorkingArea().func_197752_a());
        entityAmount.removeIf(entityLiving -> !entityLiving.func_70089_S());
        if (entityAmount.size() > 32) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        int essenceNeeded = (int)(entity.func_110143_aJ() * (float)MobDuplicatorConfig.essenceNeeded);
        int canSpawn = (this.tank.getFluid().isEmpty() ? 0 : this.tank.getFluid().getAmount()) / Math.max(essenceNeeded, 1);
        if (canSpawn == 0) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        int spawnAmount = 1 + this.field_145850_b.field_73012_v.nextInt(Math.min(canSpawn, 4));
        List<BlockPos> blocks = BlockUtils.getBlockPosInAABB(this.getWorkingArea().func_197752_a());
        while (spawnAmount > 0) {
            if (this.tank.getFluid().getAmount() >= essenceNeeded) {
                entity = (LivingEntity)((MobImprisonmentToolItem)stack.func_77973_b()).getEntityFromStack(stack, this.field_145850_b, MobDuplicatorConfig.exactCopy && this.exactCopy);
                int tries = 20;
                Vector3d random = this.blockPosToVec3d(blocks.get(this.field_145850_b.field_73012_v.nextInt(blocks.size())));
                random = random.func_72441_c(0.5, 0.0, 0.5);
                entity.func_70012_b(random.field_72450_a, random.field_72448_b, random.field_72449_c, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                entity.func_184221_a(UUID.randomUUID());
                if (entity instanceof MobEntity) {
                    ((MobEntity)entity).func_213386_a((IServerWorld)this.field_145850_b, this.field_145850_b.func_175649_E(this.field_174879_c), SpawnReason.MOB_SUMMONED, null, null);
                }
                while (tries > 0 && !this.canEntitySpawn(entity)) {
                    random = this.blockPosToVec3d(blocks.get(this.field_145850_b.field_73012_v.nextInt(blocks.size())));
                    random = random.func_72441_c(0.5, 0.0, 0.5);
                    entity.func_70012_b(random.field_72450_a, random.field_72448_b, random.field_72449_c, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    --tries;
                }
                if (tries <= 0) {
                    --spawnAmount;
                    continue;
                }
                this.field_145850_b.func_217376_c((Entity)entity);
                this.tank.drainForced(essenceNeeded, IFluidHandler.FluidAction.EXECUTE);
            }
            --spawnAmount;
        }
        if (canSpawn > 0) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, MobDuplicatorConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private boolean canEntitySpawn(LivingEntity living) {
        return this.field_145850_b.func_226668_i_((Entity)living) && !this.field_145850_b.func_72953_d(living.func_174813_aQ());
    }

    private Vector3d blockPosToVec3d(BlockPos blockPos) {
        return new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.field_174879_c, this.getFacingDirection(), RangeManager.RangeType.TOP_UP){

            @Override
            public AxisAlignedBB getBox() {
                return super.getBox().func_72321_a(0.0, 1.0, 0.0);
            }
        }.get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    @Nonnull
    public MobDuplicatorTile getSelf() {
        return this;
    }

    @Nonnull
    protected EnergyStorageComponent<MobDuplicatorTile> createEnergyStorage() {
        return new BigEnergyHandler<MobDuplicatorTile>(MobDuplicatorConfig.maxStoredPower, 10, 20){

            @Override
            public void sync() {
                MobDuplicatorTile.this.syncObject(MobDuplicatorTile.this.getEnergyStorage());
            }
        };
    }

    @Override
    public int getMaxProgress() {
        return MobDuplicatorConfig.maxProgress;
    }
}

