/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.util;

import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModUtils {
    public static final boolean DECK_THE_HALLS;

    private ModUtils() {
    }

    public static <T extends IForgeRegistryEntry<T>> Set<T> getRegistryEntries(DeferredRegister<T> registry) {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (RegistryObject entry : registry.getEntries()) {
            entries.add((Object)entry.get());
        }
        return entries.build();
    }

    @Nullable
    public static ItemStack getHeldStack(PlayerEntity player, Item item) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return item == main.func_77973_b() ? main : (item == off.func_77973_b() ? off : null);
    }

    @Nullable
    public static <T extends Entity> EntityType<T> getEntityTypeByKey(@Nonnull String key) {
        return EntityType.func_220327_a((String)key).orElse(null);
    }

    public static void playLocalSound(World world, BlockPos pos, SoundEvent sound, float volume, float pitch) {
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), sound, SoundCategory.NEUTRAL, volume, pitch, false);
    }

    public static Iterable<BlockPos> getBlockPosesInAABB(AxisAlignedBB aabb) {
        return BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)aabb.field_72340_a), (int)MathHelper.func_76128_c((double)aabb.field_72338_b), (int)MathHelper.func_76128_c((double)aabb.field_72339_c), (int)MathHelper.func_76143_f((double)aabb.field_72336_d), (int)MathHelper.func_76143_f((double)aabb.field_72337_e), (int)MathHelper.func_76143_f((double)aabb.field_72334_f));
    }

    @SafeVarargs
    public static <T> boolean equalsAny(T comparator, T ... comparing) {
        for (T t : comparing) {
            if (!comparator.equals(t)) continue;
            return true;
        }
        return false;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        DECK_THE_HALLS = calendar.get(2) == 11 && calendar.get(5) >= 19;
    }
}

