/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.network.packets;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.client.ClientEvents;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class AddPassengerPacket {
    public final int passengerID;
    public final int vehicleID;

    AddPassengerPacket(Entity passenger, Entity vehicle) {
        this.passengerID = passenger.func_145782_y();
        this.vehicleID = vehicle.func_145782_y();
    }

    public AddPassengerPacket(PacketBuffer buf) {
        this.passengerID = buf.readInt();
        this.vehicleID = buf.readInt();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.passengerID);
        buf.writeInt(this.vehicleID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        ClientWorld world = ClientEvents.getWorld();
        Entity passenger = world.func_73045_a(this.passengerID);
        Entity vehicle = world.func_73045_a(this.vehicleID);
        if (passenger == null || vehicle == null || !passenger.func_184205_a(vehicle, true)) {
            Wyrmroost.LOG.warn("Could not add passenger on client...");
        }
    }

    public static void send(Entity passenger, Entity vehicle) {
        Wyrmroost.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> vehicle), (Object)new AddPassengerPacket(passenger, vehicle));
    }
}

