/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.items.staff;

import com.github.wolfshotz.wyrmroost.client.ClientEvents;
import com.github.wolfshotz.wyrmroost.client.render.RenderHelper;
import com.github.wolfshotz.wyrmroost.client.screen.StaffScreen;
import com.github.wolfshotz.wyrmroost.containers.DragonInvContainer;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.items.staff.DragonStaffItem;
import com.github.wolfshotz.wyrmroost.util.Mafs;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public enum StaffAction {
    DEFAULT{

        @Override
        public boolean rightClick(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
            if (player.field_70170_p.field_72995_K) {
                StaffScreen.open(dragon, stack);
            }
            return true;
        }
    }
    ,
    INVENTORY{

        @Override
        public void onSelected(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
            DragonStaffItem.setAction(DEFAULT, player, stack);
            if (!player.field_70170_p.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)DragonInvContainer.getProvider(dragon), b -> b.writeInt(dragon.func_145782_y()));
            }
        }
    }
    ,
    SIT{

        @Override
        public void onSelected(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
            dragon.setSit(!dragon.func_233684_eK_());
            DragonStaffItem.setAction(DEFAULT, player, stack);
        }

        @Override
        public String getTranslateKey(@Nullable AbstractDragonEntity dragon) {
            if (dragon != null && dragon.func_233684_eK_()) {
                return "item.wyrmroost.dragon_staff.action.sit.come";
            }
            return "item.wyrmroost.dragon_staff.action.sit.stay";
        }
    }
    ,
    HOME{

        @Override
        public void onSelected(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
            if (dragon.getHomePos().isPresent()) {
                dragon.clearHome();
                DragonStaffItem.setAction(DEFAULT, player, stack);
            }
        }

        @Override
        public boolean clickBlock(AbstractDragonEntity dragon, ItemUseContext context) {
            BlockPos pos = context.func_195995_a();
            World world = context.func_195991_k();
            ItemStack stack = context.func_195996_i();
            DragonStaffItem.setAction(DEFAULT, context.func_195999_j(), stack);
            if (world.func_180495_p(pos).func_185904_a().func_76220_a()) {
                dragon.setHomePos(pos);
                ModUtils.playLocalSound(world, pos, SoundEvents.field_226131_af_, 1.0f, 1.0f);
            } else {
                ModUtils.playLocalSound(world, pos, SoundEvents.field_187745_eA, 1.0f, 1.0f);
                for (int i = 0; i < 10; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 0.0, (double)i * 0.025, 0.0);
                }
            }
            return true;
        }

        @Override
        public void render(AbstractDragonEntity dragon, MatrixStack ms, float partialTicks) {
            RayTraceResult rtr = ClientEvents.getClient().field_71476_x;
            if (rtr instanceof BlockRayTraceResult) {
                RenderHelper.drawBlockPos(ms, ((BlockRayTraceResult)rtr).func_216350_a(), dragon.field_70170_p, Math.cos((double)((float)dragon.field_70173_aa + partialTicks) * 0.2) * 4.5 + 4.5, 1291845887);
            }
        }

        @Override
        public String getTranslateKey(@Nullable AbstractDragonEntity dragon) {
            if (dragon != null && dragon.getHomePos().isPresent()) {
                return "item.wyrmroost.dragon_staff.action.home.remove";
            }
            return "item.wyrmroost.dragon_staff.action.home.set";
        }
    }
    ,
    TARGET{
        private static final int TARGET_RANGE = 40;

        @Override
        public void onSelected(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
            dragon.clearAI();
            dragon.clearHome();
            dragon.setSit(false);
        }

        @Override
        public boolean rightClick(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
            EntityRayTraceResult ertr = this.rayTrace(player, dragon);
            if (ertr != null) {
                dragon.func_70624_b((LivingEntity)ertr.func_216348_a());
                if (player.field_70170_p.field_72995_K) {
                    ModUtils.playLocalSound(player.field_70170_p, player.func_233580_cy_(), SoundEvents.field_187606_E, 1.0f, 0.5f);
                }
                return true;
            }
            return false;
        }

        @Override
        public void render(AbstractDragonEntity dragon, MatrixStack ms, float partialTicks) {
            EntityRayTraceResult rtr = this.rayTrace(ClientEvents.getPlayer(), dragon);
            if (rtr != null && rtr.func_216348_a() != dragon.func_70638_az()) {
                RenderHelper.renderEntityOutline(rtr.func_216348_a(), 255, 0, 0, (int)(MathHelper.func_76134_b((float)(((float)dragon.field_70173_aa + partialTicks) * 0.2f)) * 35.0f + 45.0f));
            }
        }

        @Nullable
        private EntityRayTraceResult rayTrace(PlayerEntity player, AbstractDragonEntity dragon) {
            return Mafs.rayTraceEntities((Entity)player, 40.0, e -> e instanceof LivingEntity && dragon.func_142018_a((LivingEntity)e, dragon.func_70902_q()));
        }
    };

    public static final StaffAction[] VALUES;
    private static final String TRANSLATE_PATH = "item.wyrmroost.dragon_staff.action.";

    public boolean clickBlock(AbstractDragonEntity dragon, ItemUseContext context) {
        return false;
    }

    public boolean rightClick(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
        return false;
    }

    public void onSelected(AbstractDragonEntity dragon, PlayerEntity player, ItemStack stack) {
    }

    public void render(AbstractDragonEntity dragon, MatrixStack ms, float partialTicks) {
    }

    protected String getTranslateKey(@Nullable AbstractDragonEntity dragon) {
        return TRANSLATE_PATH + this.name().toLowerCase();
    }

    public TranslationTextComponent getTranslation(@Nullable AbstractDragonEntity dragon) {
        return new TranslationTextComponent(this.getTranslateKey(dragon));
    }

    static {
        VALUES = StaffAction.values();
    }
}

