/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.items;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LazySpawnEggItem
extends SpawnEggItem {
    public static final Set<LazySpawnEggItem> SPAWN_EGGS = new HashSet<LazySpawnEggItem>();
    public final Lazy<EntityType<?>> type;

    public LazySpawnEggItem(Supplier<EntityType<? extends Entity>> type, int primaryColor, int secondaryColor) {
        super(null, primaryColor, secondaryColor, WRItems.builder());
        this.type = Lazy.of(type);
        SPAWN_EGGS.add(this);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ResourceLocation regName = ((EntityType)this.type.get()).getRegistryName();
        return new TranslationTextComponent("entity." + regName.func_110624_b() + "." + regName.func_110623_a()).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("item.wyrmroost.spawn_egg"));
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT tag) {
        CompoundNBT childTag;
        if (tag != null && tag.func_150297_b("EntityTag", 10) && (childTag = tag.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return (EntityType)EntityType.func_220327_a((String)childTag.func_74779_i("id")).orElse(this.type.get());
        }
        return (EntityType)this.type.get();
    }

    public static void addEggsToMap() {
        try {
            Map eggMap = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"field_195987_b");
            for (LazySpawnEggItem item : SPAWN_EGGS) {
                eggMap.put(item.type.get(), item);
            }
        }
        catch (Exception e) {
            Wyrmroost.LOG.fatal("Something threw a fit when trying to touch the SpawnEgg map", (Throwable)e);
        }
    }
}

