/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.projectile;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.projectile.DragonProjectileEntity;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.util.Mafs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WindGustEntity
extends DragonProjectileEntity {
    public WindGustEntity(EntityType<? extends DragonProjectileEntity> type, World world) {
        super(type, world);
    }

    public WindGustEntity(AbstractDragonEntity shooter, Vector3d position, Vector3d acceleration) {
        super((EntityType<? extends DragonProjectileEntity>)((EntityType)WREntities.WIND_GUST.get()), shooter, position, acceleration);
        this.life = 20;
    }

    public WindGustEntity(AbstractDragonEntity shooter) {
        this(shooter, shooter.func_70040_Z().func_178787_e(shooter.func_213303_ch().func_72441_c(0.0, -1.5, 0.0)), shooter.func_70040_Z());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            double multiplier = Math.min((double)this.field_70173_aa / 5.0, 4.0);
            Vector3d motion = this.func_213322_ci().func_216371_e().func_216372_d(0.1, 0.1, 0.1);
            for (int i = 0; i < 30; ++i) {
                Vector3d vec3d = this.func_213303_ch().func_178787_e(this.func_213322_ci()).func_72441_c(Mafs.nextDouble(this.field_70146_Z) * multiplier, Mafs.nextDouble(this.field_70146_Z) * multiplier, Mafs.nextDouble(this.field_70146_Z) * multiplier);
                double xMot = motion.field_72450_a + Mafs.nextDouble(this.field_70146_Z) * 0.1;
                double yMot = motion.field_72448_b + Mafs.nextDouble(this.field_70146_Z) * 0.1;
                double zMot = motion.field_72449_c + Mafs.nextDouble(this.field_70146_Z) * 0.1;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, xMot, yMot, zMot);
            }
        }
    }

    @Override
    public void onEntityImpact(Entity entity) {
        if (!this.field_70170_p.field_72995_K) {
            entity.func_70024_g(this.acceleration.func_82615_a() * 5.0, 1.0 + this.acceleration.func_82617_b() * 3.0, this.acceleration.func_82616_c() * 5.0);
            entity.func_70097_a(this.getDamageSource("windGust"), 3.0f);
            if (entity instanceof ServerPlayerEntity) {
                ((ServerWorld)this.field_70170_p).func_72863_F().func_217216_a(entity, (IPacket)new SEntityVelocityPacket(entity));
            }
        }
    }

    @Override
    public void onBlockImpact(BlockPos pos, Direction direction) {
        int PARTICLE_COUNT = 75;
        BlockParticleData blockParticle = new BlockParticleData(ParticleTypes.field_197611_d, this.field_70170_p.func_180495_p(pos));
        pos = pos.func_177972_a(direction);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 75; ++i) {
                Vector3d motion = new Vector3d(1.0, 1.0, 0.0);
                motion = direction.func_176740_k().func_176716_d() == Direction.Plane.VERTICAL ? motion.func_178789_a(1.5707964f) : motion.func_178785_b(direction.func_185119_l() / 180.0f * (float)Math.PI);
                motion = motion.func_216372_d(Mafs.nextDouble(this.field_70146_Z) * 0.8, Mafs.nextDouble(this.field_70146_Z) * 0.8, Mafs.nextDouble(this.field_70146_Z) * 0.8);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                this.field_70170_p.func_195594_a((IParticleData)blockParticle, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), motion.field_72450_a * 10.0, motion.field_72448_b, motion.field_72449_c * 10.0);
            }
        } else {
            for (LivingEntity e : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(1.0), this::canImpactEntity)) {
                double angle = Mafs.getAngle(this.func_226277_ct_(), this.func_226281_cx_(), e.func_226277_ct_(), e.func_226281_cx_()) * Math.PI / 180.0;
                e.func_70024_g(2.0 * -Math.cos(angle), 0.5, 2.0 * -Math.sin(angle));
            }
        }
        this.func_70106_y();
    }

    @Override
    protected double getAccelerationOffset() {
        return 0.0;
    }

    @Override
    protected float getMotionFactor() {
        return 1.5f;
    }

    @Override
    protected DragonProjectileEntity.EffectType getEffectType() {
        return DragonProjectileEntity.EffectType.COLLIDING;
    }
}

