/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.projectile;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class DragonProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    @Nullable
    public AbstractDragonEntity shooter;
    public Vector3d acceleration;
    public float growthRate = 1.0f;
    public int life;
    public boolean hasCollided;

    protected DragonProjectileEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public DragonProjectileEntity(EntityType<? extends DragonProjectileEntity> type, AbstractDragonEntity shooter, Vector3d position, Vector3d velocity) {
        super(type, shooter.field_70170_p);
        velocity = velocity.func_72441_c(this.field_70146_Z.nextGaussian() * this.getAccelerationOffset(), this.field_70146_Z.nextGaussian() * this.getAccelerationOffset(), this.field_70146_Z.nextGaussian() * this.getAccelerationOffset());
        double length = velocity.func_72433_c();
        this.acceleration = new Vector3d(velocity.field_72450_a / length * (double)this.getMotionFactor(), velocity.field_72448_b / length * (double)this.getMotionFactor(), velocity.field_72449_c / length * (double)this.getMotionFactor());
        this.shooter = shooter;
        this.life = 50;
        this.func_213317_d(this.func_213322_ci().func_178787_e(this.acceleration));
        position = position.func_178787_e(this.func_213322_ci());
        Vector3d motion = this.func_213322_ci();
        float x = (float)(motion.field_72450_a - position.field_72450_a);
        float y = (float)(motion.field_72448_b - position.field_72448_b);
        float z = (float)(motion.field_72449_c - position.field_72449_c);
        float planeSqrt = MathHelper.func_76129_c((float)(x * x + z * z));
        float yaw = (float)MathHelper.func_181159_b((double)z, (double)x) * 180.0f / (float)Math.PI - 90.0f;
        float pitch = (float)(-(MathHelper.func_181159_b((double)y, (double)planeSqrt) * 180.0 / 3.1415927410125732));
        this.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, yaw, pitch);
    }

    public void func_70071_h_() {
        if (!((this.field_70170_p.field_72995_K || this.shooter.func_70089_S() && this.field_70173_aa <= this.life && this.field_70173_aa <= this.getMaxLife()) && this.field_70170_p.func_175667_e(this.func_233580_cy_()))) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
        if (this.growthRate != 1.0f) {
            this.func_213323_x_();
        }
        switch (this.getEffectType()) {
            case RAYTRACE: {
                RayTraceResult rayTrace = ProjectileHelper.func_234618_a_((Entity)this, this::canImpactEntity);
                if (rayTrace.func_216346_c() == RayTraceResult.Type.MISS || ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)rayTrace)) break;
                this.hit(rayTrace);
                break;
            }
            case COLLIDING: {
                Vector3d end;
                AxisAlignedBB box = this.func_174813_aQ().func_186662_g(0.05);
                for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, box, this::canImpactEntity)) {
                    this.onEntityImpact(entity);
                }
                Vector3d position = this.func_213303_ch();
                BlockRayTraceResult rtr = this.field_70170_p.func_217299_a(new RayTraceContext(position, end = position.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                if (rtr.func_216346_c() == RayTraceResult.Type.MISS) break;
                this.onBlockImpact(rtr.func_216350_a(), rtr.func_216354_b());
            }
        }
        Vector3d motion = this.func_213322_ci();
        if (!this.func_189652_ae()) {
            motion = motion.func_72441_c(0.0, -0.05, 0.0);
            this.func_213317_d(motion);
        }
        double x = this.func_226277_ct_() + motion.field_72450_a;
        double y = this.func_226278_cu_() + motion.field_72448_b;
        double z = this.func_226281_cx_() + motion.field_72449_c;
        if (this.func_70090_H()) {
            this.func_213317_d(motion.func_186678_a((double)0.95f));
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() * 0.25, this.func_226278_cu_() * 0.25, this.func_226281_cx_() * 0.25, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            }
        }
        this.func_70107_b(x, y, z);
    }

    public boolean canImpactEntity(Entity entity) {
        if (entity == this.shooter) {
            return false;
        }
        if (!entity.func_70089_S()) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity.func_184208_bv() == this.shooter) {
            return false;
        }
        if (entity.func_175149_v() || !entity.func_70067_L() || entity.field_70145_X) {
            return false;
        }
        return this.shooter != null && !entity.func_184191_r((Entity)this.shooter);
    }

    public void hit(RayTraceResult result) {
        RayTraceResult.Type type = result.func_216346_c();
        if (type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult brtr = (BlockRayTraceResult)result;
            this.onBlockImpact(brtr.func_216350_a(), brtr.func_216354_b());
        } else if (type == RayTraceResult.Type.ENTITY) {
            this.onEntityImpact(((EntityRayTraceResult)result).func_216348_a());
        }
    }

    public void onEntityImpact(Entity entity) {
    }

    public void onBlockImpact(BlockPos pos, Direction direction) {
    }

    public void func_213317_d(Vector3d motionIn) {
        super.func_213317_d(motionIn);
        ProjectileHelper.func_188803_a((Entity)this, (float)1.0f);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.growthRate == 1.0f) {
            return this.func_200600_R().func_220334_j();
        }
        float size = Math.min(this.func_213311_cf() * this.growthRate, 2.25f);
        return EntitySize.func_220314_b((float)size, (float)size);
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public DamageSource getDamageSource(String name) {
        return new IndirectEntityDamageSource(name, (Entity)this, (Entity)this.shooter).func_76349_b().func_76351_m();
    }

    protected EffectType getEffectType() {
        return EffectType.NONE;
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected double getAccelerationOffset() {
        return 0.1;
    }

    protected int getMaxLife() {
        return 150;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public float func_70111_Y() {
        return this.func_213311_cf();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeInt(this.shooter.func_145782_y());
        buf.writeFloat(this.growthRate);
    }

    public void readSpawnData(PacketBuffer buf) {
        this.shooter = (AbstractDragonEntity)this.field_70170_p.func_73045_a(buf.readInt());
        this.growthRate = buf.readFloat();
    }

    protected static enum EffectType {
        NONE,
        RAYTRACE,
        COLLIDING;

    }
}

