/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon;

import com.github.wolfshotz.wyrmroost.WRConfig;
import com.github.wolfshotz.wyrmroost.client.screen.StaffScreen;
import com.github.wolfshotz.wyrmroost.client.sounds.BreathSound;
import com.github.wolfshotz.wyrmroost.containers.DragonInvContainer;
import com.github.wolfshotz.wyrmroost.containers.util.SlotBuilder;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.DragonInvHandler;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.LessShitLookController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.DefendHomeGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.FlyerWanderGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import com.github.wolfshotz.wyrmroost.entities.projectile.breath.FireBreathEntity;
import com.github.wolfshotz.wyrmroost.entities.util.EntityDataEntry;
import com.github.wolfshotz.wyrmroost.items.DragonArmorItem;
import com.github.wolfshotz.wyrmroost.items.staff.StaffAction;
import com.github.wolfshotz.wyrmroost.network.packets.AnimationPacket;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.registry.WRSounds;
import com.github.wolfshotz.wyrmroost.util.Mafs;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.items.IItemHandler;

public class RoyalRedEntity
extends AbstractDragonEntity {
    public static final int ARMOR_SLOT = 0;
    public static final Animation ROAR_ANIMATION = new Animation(70);
    public static final Animation SLAP_ATTACK_ANIMATION = new Animation(30);
    public static final Animation BITE_ATTACK_ANIMATION = new Animation(15);
    public static final DataParameter<Boolean> BREATHING_FIRE = EntityDataManager.func_187226_a(RoyalRedEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> KNOCKED_OUT = EntityDataManager.func_187226_a(RoyalRedEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final int MAX_KNOCKOUT_TIME = 3600;
    public final TickFloat flightTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat breathTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat knockOutTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private int knockOutTime = 0;

    public RoyalRedEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.field_70158_ak = WRConfig.disableFrustumCheck;
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.registerDataEntry("Gender", EntityDataEntry.BOOLEAN, GENDER, this.func_70681_au().nextBoolean());
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
        this.registerDataEntry("KnockOutTime", EntityDataEntry.INTEGER, () -> this.knockOutTime, this::setKnockoutTime);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BREATHING_FIRE, (Object)false);
        this.field_70180_af.func_187214_a(KNOCKED_OUT, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(ARMOR, (Object)ItemStack.field_190927_a);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new DragonBreedGoal(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new FlyerWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, LivingEntity.class, false, e -> e.func_200600_R() == EntityType.field_200729_aH || e instanceof AnimalEntity));
    }

    @Override
    public DragonInvHandler createInv() {
        return new DragonInvHandler(this, 1);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.flightTimer.add(this.isFlying() ? 0.1f : -0.05f);
        this.sitTimer.add(this.func_233684_eK_() ? 0.1f : -0.1f);
        this.sleepTimer.add(this.func_70608_bn() ? 0.035f : -0.1f);
        this.breathTimer.add(this.isBreathingFire() ? 0.15f : -0.2f);
        this.knockOutTimer.add(this.isKnockedOut() ? 0.05f : -0.1f);
        if (!this.field_70170_p.field_72995_K) {
            if (this.isBreathingFire() && this.getControllingPlayer() == null && this.func_70638_az() == null) {
                this.setBreathingFire(false);
            }
            if (this.breathTimer.get() == 1.0f) {
                this.field_70170_p.func_217376_c((Entity)new FireBreathEntity(this));
            }
            if (this.noActiveAnimation() && !this.isKnockedOut() && !this.func_70608_bn() && !this.isBreathingFire() && !this.func_70631_g_() && this.func_70681_au().nextDouble() < 4.0E-4) {
                AnimationPacket.send(this, ROAR_ANIMATION);
            }
            if (this.isKnockedOut() && --this.knockOutTime <= 0) {
                this.setKnockedOut(false);
            }
        }
        Animation anim = this.getAnimation();
        int animTime = this.getAnimationTick();
        if (anim == ROAR_ANIMATION) {
            if (animTime == 0) {
                this.playSound((SoundEvent)WRSounds.ENTITY_ROYALRED_ROAR.get(), 6.0f, 1.0f, true);
            }
            ((LessShitLookController)this.func_70671_ap()).restore();
            for (LivingEntity entity : this.getEntitiesNearby(10.0, this::func_184191_r)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76420_g, 60));
            }
        } else if (anim == SLAP_ATTACK_ANIMATION && (animTime == 7 || animTime == 12)) {
            this.attackInBox(this.getOffsetBox(this.func_213311_cf()).func_186662_g(0.2), 50);
            if (animTime == 7) {
                this.playSound((SoundEvent)WRSounds.ENTITY_ROYALRED_HURT.get(), 1.0f, 1.0f, true);
            }
            this.field_70177_z = this.field_70759_as;
        } else if (anim == BITE_ATTACK_ANIMATION && animTime == 4) {
            this.attackInBox(this.getOffsetBox(this.func_213311_cf()).func_186662_g(-0.3), 100);
            this.playSound((SoundEvent)WRSounds.ENTITY_ROYALRED_HURT.get(), 1.0f, 1.0f, true);
        }
    }

    @Override
    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        if (!this.func_70909_n() && this.isFoodItem(stack)) {
            if (this.func_70631_g_() || player.func_184812_l_()) {
                this.eat(stack);
                this.tame(this.func_70681_au().nextDouble() < 0.1, player);
                this.setKnockedOut(false);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.isKnockedOut() && this.knockOutTime <= 1800) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.tame((double)this.func_70681_au().nextInt(this.knockOutTime) < 720.0, player)) {
                        this.setKnockedOut(false);
                        AnimationPacket.send(this, ROAR_ANIMATION);
                    } else {
                        this.knockOutTime += 600;
                    }
                    this.eat(stack);
                    player.func_184609_a(hand);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.CONSUME;
            }
        }
        return super.playerInteraction(player, hand, stack);
    }

    public void func_70645_a(DamageSource cause) {
        if (this.func_70909_n() || this.isKnockedOut() || cause.func_76355_l().equals(DamageSource.field_76380_i.func_76355_l())) {
            super.func_70645_a(cause);
        } else {
            this.func_70606_j(this.func_110138_aP() * 0.25f);
            this.setKnockedOut(true);
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K && key.equals(BREATHING_FIRE) && this.isBreathingFire()) {
            BreathSound.play(this);
        } else {
            super.func_184206_a(key);
        }
    }

    @Override
    public void onInvContentsChanged(int slot, ItemStack stack, boolean onLoad) {
        if (slot == 0) {
            this.setArmor(stack);
        }
    }

    @Override
    public void addContainerInfo(DragonInvContainer container) {
        super.addContainerInfo(container);
        container.func_75146_a((Slot)new SlotBuilder((IItemHandler)container.inventory, 0).only(DragonArmorItem.class));
    }

    @Override
    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
        if (!this.noActiveAnimation()) {
            return;
        }
        if (key == 1 && pressed && !this.isBreathingFire()) {
            if ((mods & 2) != 0) {
                this.setAnimation(ROAR_ANIMATION);
            } else {
                this.meleeAttack();
            }
        }
        if (key == 2) {
            this.setBreathingFire(pressed);
        }
    }

    public void meleeAttack() {
        if (!this.field_70170_p.field_72995_K) {
            AnimationPacket.send(this, this.isFlying() || this.func_70681_au().nextBoolean() ? BITE_ATTACK_ANIMATION : SLAP_ATTACK_ANIMATION);
        }
    }

    @Override
    public Vector3d getApproximateMouthPos() {
        Vector3d position = this.func_174824_e(1.0f).func_178786_a(0.0, 1.3, 0.0);
        position = position.func_178787_e(this.func_174806_f(this.field_70125_A, this.field_70761_aq).func_186678_a((double)(this.func_213311_cf() / 2.0f)));
        return position.func_178787_e(this.func_174806_f(this.field_70125_A, this.field_70759_as).func_186678_a(2.75));
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
        float heightFactor = this.func_70608_bn() ? 0.5f : (this.func_233684_eK_() ? 0.9f : 1.0f);
        return size.func_220312_a(1.0f, heightFactor);
    }

    @Override
    public void addScreenInfo(StaffScreen screen) {
        screen.addAction(StaffAction.INVENTORY);
        screen.addAction(StaffAction.TARGET);
        super.addScreenInfo(screen);
    }

    @Override
    public void setMountCameraAngles(boolean backView, EntityViewRenderEvent.CameraSetup event) {
        if (backView) {
            event.getInfo().func_216782_a(-8.5, 3.0, 0.0);
        } else {
            event.getInfo().func_216782_a(-5.0, -0.75, 0.0);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || super.func_180431_b(source);
    }

    @Override
    public int determineVariant() {
        return this.func_70681_au().nextDouble() < 0.03 ? -1 : 0;
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isKnockedOut();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_213302_cg() * (this.isFlying() ? 0.95f : 1.13f);
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return !this.func_70631_g_() && !this.isKnockedOut() && this.func_70909_n();
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 3;
    }

    @Override
    public Vector3d getPassengerPosOffset(Entity entity, int index) {
        return new Vector3d(0.0, (double)(this.func_213302_cg() * 0.85f), index == 0 ? 0.5 : -1.0);
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.3f : (this.isMale() ? 0.8f : 1.0f);
    }

    @Override
    public int getYawRotationSpeed() {
        return this.isFlying() ? 5 : 7;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.field_70180_af.func_187225_a(BREATHING_FIRE);
    }

    public void setBreathingFire(boolean b) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BREATHING_FIRE, (Object)b);
        }
    }

    public boolean isKnockedOut() {
        return (Boolean)this.field_70180_af.func_187225_a(KNOCKED_OUT);
    }

    public void setKnockedOut(boolean b) {
        this.field_70180_af.func_187227_b(KNOCKED_OUT, (Object)b);
        if (!this.field_70170_p.field_72995_K) {
            int n = this.knockOutTime = b ? 3600 : 0;
            if (b) {
                this.field_70759_as = this.field_70177_z;
                this.clearAI();
                this.setFlying(false);
            }
        }
    }

    public void setKnockoutTime(int i) {
        this.knockOutTime = Math.max(0, i);
        if (i > 0 && !this.isKnockedOut()) {
            this.field_70180_af.func_187227_b(KNOCKED_OUT, (Object)true);
        }
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.isKnockedOut()) {
            return false;
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    @Override
    public boolean canFly() {
        return super.canFly() && !this.isKnockedOut();
    }

    @Override
    public boolean isImmuneToArrows() {
        return true;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Override
    public boolean shouldSleep() {
        return !this.isKnockedOut() && super.shouldSleep();
    }

    @Override
    public boolean defendsHome() {
        return true;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_ROYALRED_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_ROYALRED_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_ROYALRED_DEATH.get();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ROAR_ANIMATION, SLAP_ATTACK_ANIMATION, BITE_ATTACK_ANIMATION};
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.ROYAL_RED.get(), 1, 1, 1));
        }
    }

    @Override
    public void applyAttributes() {
        if (!this.isMale()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(130.0);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.22);
            this.func_110148_a(Attributes.field_233824_g_).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233822_e_).func_111128_a(0.121);
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233821_d_, 0.2275).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233824_g_, 3.0).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233822_e_, 0.125).func_233815_a_((Attribute)WREntities.Attributes.PROJECTILE_DAMAGE.get(), 4.0);
    }

    class AttackGoal
    extends Goal {
        public AttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = RoyalRedEntity.this.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public boolean func_75253_b() {
            LivingEntity target = RoyalRedEntity.this.func_70638_az();
            if (target != null && target.func_70089_S()) {
                if (!RoyalRedEntity.this.func_213389_a(target.func_233580_cy_())) {
                    return false;
                }
                return EntityPredicates.field_188444_d.test(target);
            }
            return false;
        }

        public void func_75246_d() {
            boolean shouldBreatheFire;
            LivingEntity target = RoyalRedEntity.this.func_70638_az();
            double distFromTarget = RoyalRedEntity.this.func_70068_e((Entity)target);
            double degrees = Math.atan2(target.func_226281_cx_() - RoyalRedEntity.this.func_226281_cx_(), target.func_226277_ct_() - RoyalRedEntity.this.func_226277_ct_()) * 57.29577951308232 - 90.0;
            boolean isBreathingFire = RoyalRedEntity.this.isBreathingFire();
            boolean canSeeTarget = RoyalRedEntity.this.func_70635_at().func_75522_a((Entity)target);
            RoyalRedEntity.this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 90.0f);
            double headAngle = Math.abs(MathHelper.func_76138_g((double)(degrees - (double)RoyalRedEntity.this.field_70759_as)));
            boolean bl = shouldBreatheFire = (!RoyalRedEntity.this.func_213394_dL() || !RoyalRedEntity.this.func_213383_dH()) && (distFromTarget > 100.0 || target.func_226278_cu_() - RoyalRedEntity.this.func_226278_cu_() > 3.0 || RoyalRedEntity.this.isFlying()) && headAngle < 30.0;
            if (isBreathingFire != shouldBreatheFire) {
                isBreathingFire = shouldBreatheFire;
                RoyalRedEntity.this.setBreathingFire(isBreathingFire);
            }
            if (RoyalRedEntity.this.func_70681_au().nextDouble() < 0.001 || distFromTarget > 900.0) {
                RoyalRedEntity.this.setFlying(true);
            } else if (distFromTarget <= 24.0 && RoyalRedEntity.this.noActiveAnimation() && !isBreathingFire && canSeeTarget) {
                RoyalRedEntity.this.field_70761_aq = RoyalRedEntity.this.field_70177_z = (float)Mafs.getAngle((Entity)RoyalRedEntity.this, (Entity)target) + 90.0f;
                RoyalRedEntity.this.meleeAttack();
            }
            if (RoyalRedEntity.this.func_70661_as().func_75500_f() || RoyalRedEntity.this.field_70173_aa % 10 == 0) {
                boolean isFlyingTarget = target instanceof AbstractDragonEntity && ((AbstractDragonEntity)target).isFlying();
                double y = target.func_226278_cu_() + (double)(!isFlyingTarget && RoyalRedEntity.this.func_70681_au().nextDouble() > 0.1 ? 8 : 0);
                RoyalRedEntity.this.func_70661_as().func_75492_a(target.func_226277_ct_(), y, target.func_226281_cx_(), !RoyalRedEntity.this.isFlying() && isBreathingFire ? 0.8 : 1.3);
            }
        }
    }
}

