/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.render.entity.dragon_egg;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.client.model.WRModelRenderer;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;

public class DragonEggRenderer
extends EntityRenderer<DragonEggEntity> {
    public static final ResourceLocation DEFAULT_TEXTURE = Wyrmroost.rl("textures/entity/dragon/dragon_egg.png");
    public static final Model MODEL = new Model();
    private static final Map<EntityType<?>, ResourceLocation> TEXTURE_MAP = new HashMap();

    public DragonEggRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(DragonEggEntity entity, float entityYaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int packedLightIn) {
        ms.func_227860_a_();
        this.scale(entity, ms);
        ms.func_227861_a_(0.0, -1.5, 0.0);
        MODEL.animate(entity, partialTicks);
        IVertexBuilder builder = buffer.getBuffer(MODEL.func_228282_a_(this.getEntityTexture(entity)));
        MODEL.func_225598_a_(ms, builder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        ms.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, ms, buffer, packedLightIn);
    }

    protected boolean canRenderName(DragonEggEntity entity) {
        return false;
    }

    public ResourceLocation getEntityTexture(DragonEggEntity entity) {
        return DragonEggRenderer.getDragonEggTexture(entity.containedDragon);
    }

    public static ResourceLocation getDragonEggTexture(EntityType<?> type) {
        return TEXTURE_MAP.computeIfAbsent(type, t -> {
            ResourceLocation textureLoc = Wyrmroost.rl(String.format("textures/entity/dragon/%s/egg.png", type.getRegistryName().func_110623_a()));
            if (Minecraft.func_71410_x().func_195551_G().func_219533_b(textureLoc)) {
                return textureLoc;
            }
            return DEFAULT_TEXTURE;
        });
    }

    private void scale(DragonEggEntity entity, MatrixStack ms) {
        EntitySize size = entity.getSize();
        if (size != null) {
            ms.func_227862_a_(size.field_220315_a * 2.95f, -(size.field_220316_b * 2.0f), -(size.field_220315_a * 2.95f));
        }
    }

    public static class Model
    extends EntityModel<DragonEggEntity> {
        public WRModelRenderer base;
        public ModelRenderer two;
        public ModelRenderer three;
        public ModelRenderer four;

        public Model() {
            super(RenderType::func_228634_a_);
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this.four = new ModelRenderer((net.minecraft.client.renderer.model.Model)this, 0, 19);
            this.four.func_78793_a(0.0f, -1.3f, 0.0f);
            this.four.func_228301_a_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f);
            this.two = new ModelRenderer((net.minecraft.client.renderer.model.Model)this, 17, 0);
            this.two.func_78793_a(0.0f, -1.5f, 0.0f);
            this.two.func_228301_a_(-2.5f, -3.0f, -2.5f, 5.0f, 6.0f, 5.0f, 0.0f);
            this.three = new ModelRenderer((net.minecraft.client.renderer.model.Model)this, 0, 9);
            this.three.func_78793_a(0.0f, -2.0f, 0.0f);
            this.three.func_228301_a_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f);
            this.base = new WRModelRenderer((net.minecraft.client.renderer.model.Model)this, 0, 0);
            this.base.func_78793_a(0.0f, 22.0f, 0.0f);
            this.base.addBox(-2.0f, -2.0f, -2.0f, 4, 4, 4, 0.0f);
            this.three.func_78792_a(this.four);
            this.base.func_78792_a(this.two);
            this.two.func_78792_a(this.three);
            this.base.setDefaultPose();
        }

        public void setRotationAngles(DragonEggEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void animate(DragonEggEntity entity, float partialTicks) {
            float time = entity.wiggleTime.get(partialTicks);
            this.base.field_78795_f = time * (float)entity.wiggleDirection.func_82601_c();
            this.base.field_78808_h = time * (float)entity.wiggleDirection.func_82599_e();
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.base.func_228309_a_(ms, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.base.resetToDefaultPose();
        }
    }
}

