/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.render.entity;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.client.model.WREntityModel;
import com.github.wolfshotz.wyrmroost.client.render.RenderHelper;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractDragonRenderer<T extends AbstractDragonEntity, M extends WREntityModel<T>>
extends MobRenderer<T, M> {
    public static final String BASE_PATH = "textures/entity/dragon/";

    public AbstractDragonRenderer(EntityRendererManager manager, M model, float shadowSize) {
        super(manager, model, shadowSize);
    }

    protected void preRenderCallback(T entity, MatrixStack ms, float partialTicks) {
        float scale = entity.func_213355_cm();
        ms.func_227862_a_(scale, scale, scale);
    }

    public class ArmorLayer
    extends LayerRenderer<T, M> {
        private final int slotIndex;

        public ArmorLayer(int slotIndex) {
            super((IEntityRenderer)AbstractDragonRenderer.this);
            this.slotIndex = slotIndex;
        }

        public void render(MatrixStack ms, IRenderTypeBuffer type, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (((AbstractDragonEntity)entity).hasArmor()) {
                IVertexBuilder builder = type.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getArmorTexture(entity)));
                ((WREntityModel)this.func_215332_c()).func_225598_a_(ms, builder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public ResourceLocation getArmorTexture(T entity) {
            String path = ((AbstractDragonEntity)entity).getArmor().func_77973_b().getRegistryName().func_110623_a().replace("_dragon_armor", "");
            return Wyrmroost.rl(String.format("%s%s/accessories/armor_%s.png", AbstractDragonRenderer.BASE_PATH, entity.func_200600_R().getRegistryName().func_110623_a(), path));
        }
    }

    public class GlowLayer
    extends ConditionalLayer {
        public final Function<T, ResourceLocation> texture;

        public GlowLayer(Function<T, ResourceLocation> texture) {
            super(e -> true, null);
            this.texture = texture;
        }

        @Override
        public void render(MatrixStack ms, IRenderTypeBuffer buffer, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ResourceLocation rl;
            if (this.conditions.test(entity) && (rl = this.texture.apply(entity)) != null) {
                IVertexBuilder builder = buffer.getBuffer(RenderHelper.getAdditiveGlow(rl));
                ((WREntityModel)this.func_215332_c()).func_225598_a_(ms, builder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public class ConditionalLayer
    extends LayerRenderer<T, M> {
        public Predicate<T> conditions;
        public final Function<T, RenderType> type;

        public ConditionalLayer(Predicate<T> conditions, Function<T, RenderType> type) {
            super((IEntityRenderer)AbstractDragonRenderer.this);
            this.conditions = conditions;
            this.type = type;
        }

        public void render(MatrixStack ms, IRenderTypeBuffer buffer, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (this.conditions.test(entity)) {
                this.renderLayer(ms, buffer, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }

        public void renderLayer(MatrixStack ms, IRenderTypeBuffer buffer, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder builder = buffer.getBuffer(this.type.apply(entity));
            ((WREntityModel)this.func_215332_c()).func_225598_a_(ms, builder, packedLightIn, LivingRenderer.func_229117_c_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }

        public ConditionalLayer addCondition(Predicate<T> condition) {
            this.conditions = this.conditions.and(condition);
            return this;
        }
    }
}

